/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import com.sun.deploy.Environment;
import com.sun.deploy.association.Action;
import com.sun.deploy.association.Association;
import com.sun.deploy.association.AssociationAlreadyRegisteredException;
import com.sun.deploy.association.AssociationDesc;
import com.sun.deploy.association.AssociationNotRegisteredException;
import com.sun.deploy.association.AssociationService;
import com.sun.deploy.association.RegisterFailedException;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.OSType;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.uitoolkit.ui.ComponentRef;
import com.sun.javaws.Globals;
import com.sun.javaws.IconUtil;
import com.sun.javaws.LocalInstallHandlerFactory;
import com.sun.javaws.Main;
import com.sun.javaws.jnl.IconDesc;
import com.sun.javaws.jnl.InformationDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchDescFactory;
import com.sun.javaws.jnl.RContentDesc;
import com.sun.javaws.jnl.ShortcutDesc;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;

public abstract class LocalInstallHandler {
    private static LocalInstallHandler _installHandler;
    public static final int DESKTOP_INDEX = 0;
    public static final int MENU_INDEX = 1;

    public static synchronized LocalInstallHandler getInstance() {
        if (_installHandler == null) {
            _installHandler = LocalInstallHandlerFactory.newInstance();
        }
        return _installHandler;
    }

    public void install(LaunchDesc ld, LocalApplicationProperties lap, boolean updated, boolean isSilent, ComponentRef owner) {
        if (ld.isApplicationDescriptor()) {
            boolean needAssociation = false;
            boolean needShortcut = false;
            if (this.isLocalInstallSupported()) {
                AssociationDesc[] ad = lap.getAssociations();
                if (ad == null || ad.length <= 0) {
                    AssociationDesc[] adesc = ld.getInformation().getAssociations();
                    needAssociation = this.isAssociationSupported() && adesc != null && adesc.length > 0;
                } else if (updated) {
                    this.removeAssociations(ld, lap);
                    this.createAssociations(ld, lap);
                }
                if (lap.isShortcutInstalled()) {
                    if (!lap.isShortcutInstalledSystem() && updated) {
                        boolean[] which = this.whichShortcutsExist(lap);
                        this.removeShortcuts(ld, lap, true);
                        if (!which[0] && !which[1]) {
                            needShortcut = true;
                        } else {
                            this.createShortcuts(ld, lap, which);
                        }
                    }
                } else {
                    needShortcut = true;
                }
            } else if (!lap.getAskedForInstall()) {
                try {
                    this.performIntegration(owner, ld, lap, isSilent, false, false);
                }
                catch (Throwable t) {
                    Trace.ignored((Throwable)t);
                }
                lap.setAskedForInstall(true);
            }
            if ((needShortcut || needAssociation) && !lap.getAskedForInstall()) {
                try {
                    this.performIntegration(owner, ld, lap, isSilent, needShortcut, needAssociation);
                }
                catch (Throwable t) {
                    Trace.ignored((Throwable)t);
                }
                lap.setAskedForInstall(true);
            }
            if (updated || lap.getLaunchCount() <= 1) {
                this.updateInstallPanel(ld, lap);
            }
        }
    }

    public void updateInstallPanel(LaunchDesc ld, LocalApplicationProperties lap) {
        this.removeFromInstallPanel(ld, lap, false);
        if (lap.isJnlpInstalled()) {
            this.registerWithInstallPanel(ld, lap);
        }
    }

    public void uninstall(LaunchDesc ld, LocalApplicationProperties lap) {
        this.uninstall(ld, lap, false);
    }

    public void uninstall(LaunchDesc ld, LocalApplicationProperties lap, boolean forceRemove) {
        this.removeShortcuts(ld, lap, true);
        this.removeAssociations(ld, lap);
        if (lap.isJnlpInstalled() || forceRemove) {
            this.removeFromInstallPanel(ld, lap, forceRemove);
            lap.setJnlpInstalled(false);
        }
    }

    public abstract boolean isLocalInstallSupported();

    public abstract boolean isAssociationSupported();

    protected abstract boolean isAssociationFileExtSupported(String var1);

    public abstract String getAssociationOpenCommand(String var1);

    public abstract String getAssociationPrintCommand(String var1);

    public abstract void registerAssociationInternal(LaunchDesc var1, LocalApplicationProperties var2, Association var3) throws AssociationAlreadyRegisteredException, RegisterFailedException;

    public abstract void unregisterAssociationInternal(LaunchDesc var1, LocalApplicationProperties var2, Association var3) throws AssociationNotRegisteredException, RegisterFailedException;

    public abstract boolean hasAssociation(LaunchDesc var1, LocalApplicationProperties var2, Association var3);

    public abstract String getDefaultIconPath();

    public abstract boolean isShortcutExists(LocalApplicationProperties var1);

    public abstract boolean[] whichShortcutsExist(LocalApplicationProperties var1);

    protected abstract boolean createShortcuts(LaunchDesc var1, LocalApplicationProperties var2, boolean[] var3);

    protected abstract boolean removeShortcuts(LaunchDesc var1, LocalApplicationProperties var2, boolean var3);

    protected abstract boolean removePathShortcut(String var1);

    public boolean updateShortcutToLatestJRE(LaunchDesc ld, LocalApplicationProperties lap) {
        return false;
    }

    protected abstract void registerWithInstallPanel(LaunchDesc var1, LocalApplicationProperties var2);

    protected abstract void removeFromInstallPanel(LaunchDesc var1, LocalApplicationProperties var2, boolean var3);

    private String getJnlpLocation(LaunchDesc ld) {
        File f = ResourceProvider.get().getCachedJNLPFile(ld.getCanonicalHome(), null);
        String jnlpLocation = f != null ? f.getAbsolutePath() : ld.getLocation().toString();
        return jnlpLocation;
    }

    private String getOpenActionCommand(Association assoc) {
        Action action = assoc.getActionByVerb("open");
        String command = null;
        if (action != null) {
            command = action.getCommand();
        }
        return command;
    }

    private boolean registerAssociation(LaunchDesc ld, LocalApplicationProperties lap, String extensions, String mimeType, String description, URL iconRef) {
        Association extAssoc;
        AssociationService assocService = new AssociationService(lap);
        Association assoc = new Association();
        boolean assocExist = false;
        Object desc = "";
        String command = null;
        if (extensions != null) {
            StringTokenizer st = new StringTokenizer(extensions);
            while (st.hasMoreTokens()) {
                String ext = "." + st.nextToken();
                Trace.println((String)("associate with ext: " + ext), (TraceLevel)TraceLevel.BASIC);
                if (!this.isAssociationFileExtSupported(ext)) {
                    Trace.println((String)("association with ext: " + ext + " is not supported"), (TraceLevel)TraceLevel.BASIC);
                    return false;
                }
                if (((String)desc).isEmpty()) {
                    desc = ext + " file";
                }
                if ((extAssoc = assocService.getFileExtensionAssociation(ext)) != null) {
                    Trace.println((String)("associate with ext: " + ext + " already EXIST"), (TraceLevel)TraceLevel.BASIC);
                    if (command == null) {
                        command = this.getOpenActionCommand(extAssoc);
                    }
                    assocExist = true;
                    if (command == null || !this.promptReplace(ld, ext, null, command)) {
                        return false;
                    }
                }
                assoc.addFileExtension(ext);
            }
        }
        if (description != null && description.length() > 0) {
            desc = description;
        }
        if (mimeType != null) {
            Trace.println((String)("associate with mime: " + mimeType), (TraceLevel)TraceLevel.BASIC);
            extAssoc = assocService.getMimeTypeAssociation(mimeType);
            if (extAssoc != null & !assocExist) {
                Trace.println((String)("associate with mime: " + mimeType + " already EXIST"), (TraceLevel)TraceLevel.BASIC);
                String newCommand = this.getOpenActionCommand(extAssoc);
                if (newCommand.equals(command) && !this.promptReplace(ld, null, mimeType, newCommand)) {
                    return false;
                }
            }
            assoc.setMimeType(mimeType);
        }
        assoc.setName(ld.getInformation().getTitle());
        assoc.setDescription((String)desc);
        String iconPath = iconRef != null ? IconUtil.getIconPath(iconRef, null) : IconUtil.getIconPath(ld);
        if (iconPath == null) {
            iconPath = this.getDefaultIconPath();
        }
        assoc.setIconFileName(iconPath);
        String jnlpLocation = this.getJnlpLocation(ld);
        String openAction = this.getAssociationOpenCommand(jnlpLocation);
        String printAction = this.getAssociationPrintCommand(jnlpLocation);
        Trace.println((String)("register OPEN using: " + openAction), (TraceLevel)TraceLevel.BASIC);
        Action oneAction = new Action("open", openAction, "open the file");
        assoc.addAction(oneAction);
        if (printAction != null) {
            Trace.println((String)("register PRINT using: " + printAction), (TraceLevel)TraceLevel.BASIC);
            oneAction = new Action("print", printAction, "print the file");
            assoc.addAction(oneAction);
        }
        try {
            this.registerAssociationInternal(ld, lap, assoc);
        }
        catch (AssociationAlreadyRegisteredException e) {
            try {
                this.unregisterAssociationInternal(ld, lap, assoc);
                this.registerAssociationInternal(ld, lap, assoc);
            }
            catch (AssociationNotRegisteredException anre) {
                Trace.ignoredException((Exception)((Object)anre));
                return false;
            }
            catch (AssociationAlreadyRegisteredException aare) {
                Trace.ignoredException((Exception)((Object)aare));
                return false;
            }
            catch (RegisterFailedException rfe) {
                Trace.ignoredException((Exception)((Object)rfe));
                return false;
            }
        }
        catch (RegisterFailedException e) {
            Trace.ignoredException((Exception)((Object)e));
            return false;
        }
        return true;
    }

    private void unregisterAssociation(LaunchDesc ld, LocalApplicationProperties lap, String mimeType, String extensions) {
        Association assoc;
        AssociationService assocService = new AssociationService(lap);
        if (extensions != null) {
            StringTokenizer st = new StringTokenizer(extensions);
            while (st.hasMoreTokens()) {
                String ext = "." + st.nextToken();
                assoc = assocService.getFileExtensionAssociation(ext);
                if (assoc == null) continue;
                assoc.setName(ld.getInformation().getTitle());
                Trace.println((String)("remove association with ext: " + ext), (TraceLevel)TraceLevel.BASIC);
                try {
                    this.unregisterAssociationInternal(ld, lap, assoc);
                }
                catch (AssociationNotRegisteredException anre) {
                    Trace.ignoredException((Exception)((Object)anre));
                }
                catch (RegisterFailedException rfe) {
                    Trace.ignoredException((Exception)((Object)rfe));
                }
            }
        }
        if (mimeType != null && (assoc = assocService.getMimeTypeAssociation(mimeType)) != null) {
            assoc.setName(ld.getInformation().getTitle());
            Trace.println((String)("remove association with mime: " + mimeType), (TraceLevel)TraceLevel.BASIC);
            try {
                this.unregisterAssociationInternal(ld, lap, assoc);
            }
            catch (AssociationNotRegisteredException anre) {
                Trace.ignoredException((Exception)((Object)anre));
            }
            catch (RegisterFailedException rfe) {
                Trace.ignoredException((Exception)((Object)rfe));
            }
        }
    }

    public void removeAssociations(LaunchDesc ld, LocalApplicationProperties lap) {
        AssociationDesc[] adesc;
        if (this.isAssociationSupported() && (adesc = lap.getAssociations()) != null) {
            for (AssociationDesc app : adesc) {
                this.removeAssociationIfCurent(ld, lap, app.getMimeType(), app.getExtensions());
            }
            lap.setAssociations(null);
        }
    }

    private void removeAssociationIfCurent(LaunchDesc ld, LocalApplicationProperties lap, String mimeType, String extensions) {
        String openAction = this.getAssociationOpenCommand(this.getJnlpLocation(ld));
        AssociationService assocService = new AssociationService(lap);
        Association extAssoc = assocService.getMimeTypeAssociation(mimeType);
        if (extAssoc != null) {
            String existingOpenAction = this.getOpenActionCommand(extAssoc);
            if (openAction.equals(existingOpenAction)) {
                this.unregisterAssociation(ld, lap, mimeType, extensions);
            } else {
                Trace.println((String)("Not removing association because existing command is: " + existingOpenAction + " instead of: " + openAction), (TraceLevel)TraceLevel.BASIC);
            }
        }
    }

    public boolean createAssociations(LaunchDesc ld, LocalApplicationProperties lap) {
        if (Config.getAssociationValue() == 0) {
            return false;
        }
        boolean success = true;
        if (this.isAssociationSupported()) {
            AssociationDesc[] adesc = ld.getInformation().getAssociations();
            for (int i = 0; adesc != null && i < adesc.length; ++i) {
                URL iconRef;
                String description;
                String mimeType;
                String extensions = adesc[i].getExtensions();
                if (this.registerAssociation(ld, lap, extensions, mimeType = adesc[i].getMimeType(), description = adesc[i].getMimeDescription(), iconRef = adesc[i].getIconUrl())) {
                    lap.addAssociation(adesc[i]);
                    LocalInstallHandler.save(lap);
                    continue;
                }
                success = false;
            }
        } else {
            success = false;
        }
        return success;
    }

    public boolean performIntegration(ComponentRef owner, LaunchDesc ld, LocalApplicationProperties lap, boolean isSilent, boolean needShortcut, boolean needAssociation) {
        boolean successShortcut = true;
        boolean successAssociation = true;
        boolean allow = true;
        boolean doShortcut = false;
        boolean doAssociation = false;
        boolean doInstall = false;
        boolean promptShortcut = false;
        boolean promptAssociation = false;
        boolean hintInstall = false;
        boolean allPermissions = ld.getSecurityModel() != 0;
        ShortcutDesc hints = ld.getInformation().getShortcut();
        if (hints != null) {
            if (!(hints.getDesktop() || hints.getMenu() || OSType.isMac())) {
                needShortcut = false;
            }
            hintInstall = hints.getInstall();
        }
        if (needShortcut) {
            if (isSilent) {
                doShortcut = hints != null && (Globals.createShortcut() || Config.getShortcutValue() == 1);
                promptShortcut = false;
            } else {
                switch (Config.getShortcutValue()) {
                    case 0: {
                        doShortcut = false;
                        promptShortcut = false;
                        break;
                    }
                    case 1: {
                        doShortcut = hints != null;
                        promptShortcut = false;
                        break;
                    }
                    default: {
                        doShortcut = hints != null;
                        promptShortcut = hints != null;
                        break;
                    }
                    case 3: {
                        doShortcut = hints != null;
                        boolean bl = promptShortcut = !allPermissions && hints != null;
                    }
                }
            }
        }
        if (needAssociation) {
            AssociationService assocService = new AssociationService(lap);
            boolean allNew = true;
            AssociationDesc[] adesc = ld.getInformation().getAssociations();
            block20: for (int i = 0; adesc != null && i < adesc.length; ++i) {
                if (assocService.getMimeTypeAssociation(adesc[i].getMimeType()) != null) {
                    allNew = false;
                    break;
                }
                String extensions = adesc[i].getExtensions();
                StringTokenizer st = new StringTokenizer(extensions);
                while (st.hasMoreTokens()) {
                    String ext = "." + st.nextToken();
                    if (assocService.getFileExtensionAssociation(ext) == null) continue;
                    allNew = false;
                    continue block20;
                }
            }
            if (isSilent) {
                promptAssociation = false;
                switch (Config.getAssociationValue()) {
                    case 0: {
                        doAssociation = false;
                        break;
                    }
                    case 1: {
                        doAssociation = allNew;
                        break;
                    }
                    case 3: {
                        doAssociation = allNew || Globals.createAssoc();
                        break;
                    }
                    case 4: {
                        doAssociation = true;
                        break;
                    }
                    default: {
                        doAssociation = Globals.createAssoc();
                        break;
                    }
                }
            } else {
                switch (Config.getAssociationValue()) {
                    case 0: {
                        doAssociation = false;
                        promptAssociation = false;
                        break;
                    }
                    case 1: {
                        doAssociation = allNew;
                        promptAssociation = false;
                        break;
                    }
                    case 3: {
                        doAssociation = true;
                        promptAssociation = !allNew;
                        break;
                    }
                    case 4: {
                        doAssociation = true;
                        promptAssociation = false;
                        break;
                    }
                    default: {
                        doAssociation = true;
                        promptAssociation = true;
                    }
                }
            }
        }
        if (hintInstall) {
            switch (Config.getInstallMode()) {
                case 0: 
                case 1: 
                case 2: {
                    doInstall = false;
                    break;
                }
                default: {
                    doInstall = true;
                }
            }
        }
        if (promptShortcut || promptAssociation) {
            if (this.showDialog(owner == null ? null : owner.get(), ld, lap, doShortcut, doAssociation)) {
                if (promptShortcut) {
                    doShortcut = true;
                }
                if (promptAssociation) {
                    doAssociation = true;
                }
            } else {
                if (promptShortcut) {
                    doShortcut = false;
                }
                if (promptAssociation) {
                    doAssociation = false;
                }
            }
        }
        if (doShortcut) {
            String title = ld.getInformation().getTitle();
            if (title != null && title.length() > 0) {
                successShortcut = this.installShortcuts(ld, lap, null);
            } else {
                Trace.println((String)"Cannot create shortcut(s) without a valid title", (TraceLevel)TraceLevel.BASIC);
                successShortcut = false;
            }
        }
        if (doAssociation) {
            successAssociation = this.createAssociations(ld, lap);
        }
        if (doInstall) {
            lap.setJnlpInstalled(true);
            this.updateInstallPanel(ld, lap);
            LocalInstallHandler.save(lap);
        }
        return successShortcut && successAssociation;
    }

    public boolean installShortcuts(LaunchDesc ld, LocalApplicationProperties lap) {
        return this.installShortcuts(ld, lap, null);
    }

    private boolean installShortcuts(LaunchDesc ld, LocalApplicationProperties lap, boolean[] which) {
        boolean success = this.createShortcuts(ld, lap, which);
        lap.setAskedForInstall(true);
        RContentDesc[] rc = ld.getInformation().getRelatedContent();
        if (rc != null) {
            for (RContentDesc rc1 : rc) {
                URL href = rc1.getHref();
                if ("jar".equals(href.getProtocol()) || !href.toString().endsWith(".jnlp")) continue;
                try {
                    Main.importApp(href.toString());
                }
                catch (Exception e) {
                    Trace.ignoredException((Exception)e);
                }
            }
        }
        if (success && !lap.isJnlpInstalled()) {
            int mode = Config.getInstallMode();
            ShortcutDesc sd = ld.getInformation().getShortcut();
            if (mode == 1 || mode == 2 && sd != null && sd.getInstall()) {
                lap.setJnlpInstalled(true);
                this.updateInstallPanel(ld, lap);
                LocalInstallHandler.save(lap);
            }
        }
        return success;
    }

    private boolean showDialog(Object owner, LaunchDesc ld, LocalApplicationProperties lap, boolean doShortcut, boolean doAssociation) {
        InformationDesc id = ld.getInformation();
        IconDesc icon = id.getIconLocation(48, 0);
        URL iconRef = icon == null ? null : icon.getLocation();
        String iconVer = icon == null ? null : icon.getVersion();
        boolean desktop = false;
        boolean menu = false;
        String submenu = null;
        String title = id.getTitle();
        if (doShortcut) {
            if (title == null || title.length() == 0) {
                Trace.println((String)"Cannot ask user to create shortcut(s) without a valid title", (TraceLevel)TraceLevel.BASIC);
            } else {
                ShortcutDesc sd = id.getShortcut();
                if (sd != null) {
                    desktop = sd.getDesktop();
                    menu = sd.getMenu();
                    submenu = sd.getSubmenu();
                } else {
                    desktop = true;
                    menu = true;
                }
            }
        }
        AssociationDesc[] associations = doAssociation ? id.getAssociations() : new AssociationDesc[]{};
        AppInfo ainfo = new AppInfo(ld.getLaunchType(), id.getTitle(), id.getVendor(), ld.getCanonicalHome(), ld.getSourceURL(), iconRef, iconVer, desktop, menu, submenu, associations);
        if (associations.length > 0 || desktop | menu) {
            return ToolkitStore.getUI().showMessageDialog(owner, ainfo, 5, null, null, null, null, null, null, null) == 0;
        }
        return false;
    }

    private boolean promptReplace(LaunchDesc ld, String extension, String mime, String command) {
        String msg = extension != null ? ResourceManager.getString((String)"association.replace.ext", (Object[])new Object[]{extension}) : ResourceManager.getString((String)"association.replace.mime", (Object[])new Object[]{mime});
        String appTitle = command;
        String dir = ResourceProvider.get().getCacheDir().toString();
        int start = command.indexOf(dir);
        if (start >= 0) {
            int end = command.indexOf("\"", start + dir.length());
            if (end < 0) {
                end = command.indexOf(" ", start + dir.length());
            }
            String path = end >= 0 ? command.substring(start, end) : command.substring(start);
            try {
                LaunchDesc appLd = LaunchDescFactory.buildDescriptor(path);
                if (appLd != null) {
                    appTitle = appLd.getInformation().getTitle();
                    if (appLd.getCanonicalHome().toString().equals(ld.getCanonicalHome().toString())) {
                        return true;
                    }
                }
            }
            catch (Exception e) {
                return true;
            }
        }
        String info = ResourceManager.getString((String)"association.replace.info", (Object[])new Object[]{appTitle});
        String title = ResourceManager.getString((String)"association.replace.title");
        String okBtn = ResourceManager.getString((String)"common.ok_btn");
        String cancelBtn = ResourceManager.getString((String)"common.cancel_btn");
        return ToolkitStore.getUI().showMessageDialog(null, ld.getAppInfo(), 3, title, null, msg, info, okBtn, cancelBtn, null) == 0;
    }

    public boolean uninstallShortcuts(LaunchDesc ld, LocalApplicationProperties lap) {
        return this.removeShortcuts(ld, lap, true);
    }

    public static boolean shouldInstallOverExisting(final LaunchDesc ld) {
        final int[] result = new int[]{-1};
        Runnable confirmRunnable = new Runnable(){

            @Override
            public void run() {
                String title = ResourceManager.getString((String)"install.alreadyInstalledTitle");
                String msg = ResourceManager.getString((String)"install.alreadyInstalled", (Object[])new Object[]{ld.getInformation().getTitle()});
                String okBtn = ResourceManager.getString((String)"common.ok_btn");
                String cancelBtn = ResourceManager.getString((String)"common.cancel_btn");
                result[0] = ToolkitStore.getUI().showMessageDialog(null, ld.getAppInfo(), 3, title, null, msg, null, okBtn, cancelBtn, null);
            }
        };
        if (!Globals.isSilentMode()) {
            LocalInstallHandler.invokeRunnable(confirmRunnable);
        }
        return result[0] == 0;
    }

    public static void invokeRunnable(Runnable runner) {
        if (SwingUtilities.isEventDispatchThread()) {
            runner.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runner);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    public static void save(LocalApplicationProperties lap) {
        try {
            lap.store();
        }
        catch (IOException ioe) {
            Trace.ignoredException((Exception)ioe);
        }
    }

    public boolean addUninstallShortcut() {
        return Config.getBooleanProperty((String)"deployment.javaws.uninstall.shortcut") && !Environment.isSystemCacheMode();
    }

    boolean removeShortcuts(String path) {
        return this.removePathShortcut(path);
    }

    void removeAssociations(LaunchDesc ld, LocalApplicationProperties lap, String mime, String extensions) {
        Association assoc = new Association();
        Object desc = "";
        if (extensions != null) {
            StringTokenizer st = new StringTokenizer(extensions);
            while (st.hasMoreTokens()) {
                String ext = "." + st.nextToken();
                if (((String)desc).isEmpty()) {
                    desc = ext + " file";
                }
                assoc.addFileExtension(ext);
            }
        }
        if (mime != null) {
            assoc.setMimeType(mime);
        }
        assoc.setName(" ");
        assoc.setDescription((String)desc);
        try {
            this.unregisterAssociationInternal(ld, lap, assoc);
        }
        catch (Exception e) {
            Trace.ignored((Throwable)e);
        }
    }

    void reinstallShortcuts(LaunchDesc ld, LocalApplicationProperties lap, boolean doDesktop, boolean doMenu) {
        boolean[] which = new boolean[]{doDesktop, doMenu};
        this.installShortcuts(ld, lap, which);
    }

    void reinstallAssociations(LaunchDesc ld, LocalApplicationProperties lap) {
        this.createAssociations(ld, lap);
    }

    protected String checkTitleString(String name, String badChars, char replacement) {
        int codepoint;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < name.length(); i += Character.charCount(codepoint)) {
            codepoint = name.codePointAt(i);
            if (badChars.indexOf(codepoint) >= 0) {
                sb.appendCodePoint(replacement);
                continue;
            }
            if (!LocalInstallHandler.isShortCutSafe(codepoint)) {
                sb.appendCodePoint(replacement);
                continue;
            }
            sb.appendCodePoint(codepoint);
        }
        return sb.toString();
    }

    private static boolean isShortCutSafe(int ch) {
        return !Character.isIdentifierIgnorable(ch) && ch >= 32;
    }
}

