/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import com.sun.deploy.Environment;
import com.sun.deploy.association.Action;
import com.sun.deploy.association.Association;
import com.sun.deploy.association.AssociationAlreadyRegisteredException;
import com.sun.deploy.association.AssociationNotRegisteredException;
import com.sun.deploy.association.AssociationService;
import com.sun.deploy.association.RegisterFailedException;
import com.sun.deploy.association.utility.DesktopEntry;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.Platform;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.javaws.CacheUtil;
import com.sun.javaws.IconUtil;
import com.sun.javaws.LocalInstallHandler;
import com.sun.javaws.jnl.InformationDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.RContentDesc;
import com.sun.javaws.jnl.ShortcutDesc;
import java.io.File;
import java.net.URL;
import java.util.StringTokenizer;

public abstract class UnixInstallHandler
extends LocalInstallHandler {
    private static final String INSTALLED_DESKTOP_SHORTCUT_KEY = "installed.desktop";
    private static final String INSTALLED_START_MENU_KEY = "installed.menu";
    private static final String INSTALLED_DIRECTORY_KEY = "installed.directory";
    private static final String INSTALLED_UNINSTALL_KEY = "installed.uninstalled";
    private static final String INSTALLED_RC_KEY = "installed.rc";
    private final String nameBadChars = "\"\\/|:?*<>#";
    private final String dirBadChars = "\"|:?*<>#";

    @Override
    public boolean isShortcutExists(LocalApplicationProperties lap) {
        String desktopPath = lap.get(INSTALLED_DESKTOP_SHORTCUT_KEY);
        String menuPath = lap.get(INSTALLED_START_MENU_KEY);
        boolean desktopExists = false;
        boolean menuExists = false;
        if (desktopPath != null) {
            desktopExists = this.desktopEntryExists(desktopPath);
        }
        if (menuPath != null) {
            menuExists = this.desktopEntryExists(menuPath);
        }
        if (desktopPath != null && menuPath != null) {
            return desktopExists && menuExists;
        }
        return desktopExists || menuExists;
    }

    protected abstract boolean desktopEntryExists(String var1);

    @Override
    public boolean[] whichShortcutsExist(LocalApplicationProperties lap) {
        String desktopPath = lap.get(INSTALLED_DESKTOP_SHORTCUT_KEY);
        String menuPath = lap.get(INSTALLED_START_MENU_KEY);
        boolean[] which = new boolean[]{desktopPath != null && this.desktopEntryExists(desktopPath), menuPath != null && this.desktopEntryExists(menuPath)};
        return which;
    }

    @Override
    public String getAssociationPrintCommand(String jnlpLocation) {
        return null;
    }

    @Override
    public String getAssociationOpenCommand(String jnlpLocation) {
        return Platform.get().getSystemJavawsPath() + " -localfile " + jnlpLocation + " -open";
    }

    @Override
    public void registerAssociationInternal(LaunchDesc ld, LocalApplicationProperties lap, Association assoc) throws AssociationAlreadyRegisteredException, RegisterFailedException {
        AssociationService assocService = new AssociationService(lap);
        if (Environment.isSystemCacheMode()) {
            assocService.registerSystemAssociation(assoc);
        } else {
            assocService.registerUserAssociation(assoc);
        }
    }

    @Override
    public void unregisterAssociationInternal(LaunchDesc ld, LocalApplicationProperties lap, Association assoc) throws AssociationNotRegisteredException, RegisterFailedException {
        AssociationService assocService = new AssociationService(lap);
        if (Environment.isSystemCacheMode()) {
            assocService.unregisterSystemAssociation(assoc);
        } else {
            assocService.unregisterUserAssociation(assoc);
        }
    }

    @Override
    public boolean hasAssociation(LaunchDesc ld, LocalApplicationProperties lap, Association assoc) {
        AssociationService assocService = new AssociationService(lap);
        return assocService.hasAssociation(assoc);
    }

    @Override
    protected boolean createShortcuts(LaunchDesc desc, LocalApplicationProperties lap, boolean[] which) {
        return this.createShortcuts(desc, lap, which, null, -1);
    }

    private static String getJnlpLocation(LaunchDesc ld) {
        File f = ResourceProvider.get().getCachedJNLPFile(ld.getCanonicalHome(), null);
        String jnlpLocation = f != null ? f.getAbsolutePath() : ld.getLocation().toString();
        return jnlpLocation;
    }

    protected boolean createShortcuts(LaunchDesc desc, LocalApplicationProperties lap, boolean[] which, Association assoc, int level) {
        Trace.println((String)"createShortcuts called in UnixInstallHandler", (TraceLevel)TraceLevel.BASIC);
        ShortcutDesc sd = desc.getInformation().getShortcut();
        boolean doDesktop = sd == null ? true : sd.getDesktop();
        boolean doMenu = sd == null ? true : sd.getMenu();
        boolean doAssociation = assoc != null;
        boolean allUsers = false;
        boolean installSuccess = true;
        if (Environment.isSystemCacheMode()) {
            doDesktop = false;
            allUsers = true;
        }
        if (which != null) {
            doDesktop = doDesktop && which[0];
            boolean bl = doMenu = doMenu && which[1];
        }
        if (this.isShortcutExists(lap)) {
            if (!UnixInstallHandler.shouldInstallOverExisting(desc) && !doAssociation) {
                Trace.println((String)"Skip creating shortcut as it exists", (TraceLevel)TraceLevel.UI);
                return false;
            }
            this.removeShortcuts(desc, lap, doDesktop);
        }
        if (doMenu || doDesktop || doAssociation) {
            String jnlpLocation = UnixInstallHandler.getJnlpLocation(desc);
            if ((doDesktop || doAssociation) && installSuccess) {
                String desktopFilePath = this.createDesktopShortcut(desc, jnlpLocation, assoc, level);
                if (desktopFilePath != null) {
                    lap.put(INSTALLED_DESKTOP_SHORTCUT_KEY, desktopFilePath);
                }
                if (desktopFilePath == null) {
                    installSuccess = false;
                    Trace.println((String)"Skip creating shortcut - can not find desktop location", (TraceLevel)TraceLevel.UI);
                }
            }
            if (doMenu && installSuccess) {
                String[] startmenuFilePath = this.createStartMenuShortcut(desc, jnlpLocation, allUsers);
                if (startmenuFilePath[0] != null) {
                    lap.put(INSTALLED_START_MENU_KEY, startmenuFilePath[0]);
                    if (startmenuFilePath[1] != null) {
                        lap.put(INSTALLED_DIRECTORY_KEY, startmenuFilePath[1]);
                    }
                    if (startmenuFilePath[2] != null) {
                        lap.put(INSTALLED_UNINSTALL_KEY, startmenuFilePath[2]);
                    }
                    if (startmenuFilePath[3] != null) {
                        lap.put(INSTALLED_RC_KEY, startmenuFilePath[3]);
                    }
                } else {
                    installSuccess = false;
                    this.removeShortcuts(desc, lap, doDesktop);
                }
            }
            if (installSuccess) {
                lap.setShortcutInstalled(true);
                UnixInstallHandler.save(lap);
            } else {
                this.installFailed(desc);
            }
        }
        return installSuccess;
    }

    @Override
    protected void registerWithInstallPanel(LaunchDesc ld, LocalApplicationProperties lap) {
    }

    @Override
    protected void removeFromInstallPanel(LaunchDesc ld, LocalApplicationProperties lap, boolean force) {
    }

    @Override
    public String getDefaultIconPath() {
        return Environment.getJavaHome() + File.separator + "lib" + File.separator + "deploy" + File.separator + "java-icon.ico";
    }

    private String getIcon(LaunchDesc ld, boolean forDesktop) {
        String iconPath = IconUtil.getIconPath(ld, forDesktop);
        if (iconPath == null) {
            iconPath = this.getDefaultIconPath();
        }
        return iconPath;
    }

    private String getRCIcon(RContentDesc rc, LaunchDesc ld) {
        URL iconUrl = rc.getIcon();
        String rciconPath = null;
        if (iconUrl != null) {
            rciconPath = IconUtil.getIconPath(iconUrl, null);
        }
        if (rciconPath == null) {
            rciconPath = this.getIcon(ld, false);
        }
        return rciconPath;
    }

    private String[] createStartMenuShortcut(LaunchDesc ld, String jnlpLocation, boolean allUsers) {
        InformationDesc iDesc = ld.getInformation();
        ShortcutDesc sd = iDesc.getShortcut();
        String[] menuPath = new String[5];
        String name = this.nameFilter(iDesc.getTitle());
        String iconPath = this.getIcon(ld, false);
        boolean online = !iDesc.supportsOfflineOperation() || sd == null || sd.getOnline();
        String onlineArg = online ? "" : "-offline ";
        String home = ld.getLocation() != null ? ld.getLocation().toString() : null;
        String homeString = home == null || home.endsWith(".jarjnlp") ? "" : "-J-Djnlp.application.href=" + home + " ";
        String launchArgs = "-localfile " + onlineArg + homeString;
        String menuEntryDirPath = this.getMenuEntryDirPath(ld, allUsers);
        menuPath[0] = this.createDesktopFile(ld, name, iconPath, menuEntryDirPath, jnlpLocation, launchArgs, false, null, -1);
        menuPath[1] = menuEntryDirPath;
        if (this.addUninstallShortcut()) {
            menuPath[2] = this.createDesktopFile(ld, ResourceManager.getString((String)"install.startMenuUninstallShortcutName", (Object[])new Object[]{name}), iconPath, menuEntryDirPath, jnlpLocation, "-uninstall", false, null, -1);
        }
        Trace.println((String)("directoryFileName: " + menuPath[1]), (TraceLevel)TraceLevel.BASIC);
        Trace.println((String)("desktopFileName: " + menuPath[0]), (TraceLevel)TraceLevel.BASIC);
        RContentDesc[] rc = iDesc.getRelatedContent();
        if (rc != null) {
            StringBuilder rcFilePaths = new StringBuilder(512 * rc.length);
            for (RContentDesc rcDesc : rc) {
                String rcFile;
                URL url = rcDesc.getHref();
                if (url != null && url.toString().endsWith(".jnlp") || (rcFile = this.createRCDesktopFile(rcDesc, this.getRCIcon(rcDesc, ld), menuEntryDirPath)) == null) continue;
                rcFilePaths.append(rcFile);
                rcFilePaths.append(";");
            }
            menuPath[3] = rcFilePaths.toString();
        }
        return menuPath;
    }

    private String getFolderName(LaunchDesc ld) {
        String folderName = null;
        if (ld.getInformation().getShortcut() != null) {
            folderName = ld.getInformation().getShortcut().getSubmenu();
        }
        if (folderName == null) {
            folderName = this.nameFilter(ld.getInformation().getTitle());
        }
        folderName = folderName.replace('<', '-');
        folderName = folderName.replace('>', '-');
        return folderName;
    }

    protected abstract String writeDesktopEntry(DesktopEntry var1, String var2, Association var3, int var4);

    private String createDesktopShortcut(LaunchDesc ld, String jnlpLocation, Association assoc, int level) {
        InformationDesc iDesc = ld.getInformation();
        ShortcutDesc sd = iDesc.getShortcut();
        String name = this.nameFilter(iDesc.getTitle());
        String iconPath = this.getIcon(ld, true);
        boolean online = !iDesc.supportsOfflineOperation() || sd == null || sd.getOnline();
        String onlineArg = online ? "" : "-offline ";
        Trace.println((String)("iconPath: " + iconPath), (TraceLevel)TraceLevel.TEMP);
        String home = ld.getLocation() != null ? ld.getLocation().toString() : null;
        String homeString = home == null || home.endsWith(".jarjnlp") ? "" : "-J-Djnlp.application.href=" + home + " ";
        String launchArgs = "-localfile " + onlineArg + homeString;
        return this.createDesktopFile(ld, name, iconPath, null, jnlpLocation, launchArgs, true, assoc, level);
    }

    protected abstract String getMenuEntryDirPath(LaunchDesc var1, boolean var2);

    private String getRCCommand(URL url) {
        String filePath;
        File f = CacheUtil.getCachedFileNative(url);
        String browserPath = "";
        if (url.toString().endsWith(".jnlp")) {
            return Environment.getJavawsCommand() + " " + url.toString();
        }
        if (f != null) {
            Action act;
            AssociationService assocService;
            Association assoc;
            filePath = f.getAbsolutePath();
            String ext = filePath.substring(filePath.lastIndexOf("."), filePath.length());
            if (this.isAssociationSupported() && !ext.equals(".html") && (assoc = (assocService = new AssociationService(null)).getFileExtensionAssociation(ext)) != null && (act = assoc.getActionByVerb("open")) != null) {
                String command = act.getCommand();
                StringTokenizer st = new StringTokenizer(command);
                if (st.hasMoreTokens()) {
                    command = st.nextToken();
                }
                browserPath = command;
            }
            if ("".equals(browserPath)) {
                browserPath = Config.getStringProperty((String)"deployment.browser.path");
            }
        } else {
            filePath = url.toString();
            browserPath = Config.getStringProperty((String)"deployment.browser.path");
        }
        return browserPath + " " + filePath;
    }

    private String createRCDesktopFile(RContentDesc rc, String iconPath, String menuEntryDirPath) {
        URL url = rc.getHref();
        String appTitle = this.nameFilter(rc.getTitle());
        DesktopEntry desktopEntry = new DesktopEntry();
        desktopEntry.setType("Application");
        desktopEntry.setExec(this.getRCCommand(url));
        desktopEntry.setIcon(iconPath);
        desktopEntry.setTerminal(false);
        desktopEntry.setName(appTitle);
        desktopEntry.setComment(rc.getDescription());
        desktopEntry.setCategories("Applications;" + appTitle);
        return this.writeMenuEntry(desktopEntry, menuEntryDirPath, this.uniqDesktopFileName(appTitle));
    }

    protected abstract String writeMenuEntry(DesktopEntry var1, String var2, String var3);

    private String createDesktopFile(LaunchDesc ld, String appTitle, String iconPath, String desktopPath, String jnlpLocation, String args, boolean isDesktop, Association assoc, int level) {
        String description;
        InformationDesc id = ld.getInformation();
        String categories = this.getFolderName(ld);
        String default_desc = id.getDescription(0);
        String tooltip_desc = id.getDescription(3);
        String string = description = tooltip_desc == null ? default_desc : tooltip_desc;
        if (args == null) {
            args = "";
        } else if (((String)args).length() > 0 && !((String)args).endsWith(" ")) {
            args = (String)args + " ";
        }
        DesktopEntry desktopEntry = new DesktopEntry();
        desktopEntry.setEncoding("UTF-8");
        desktopEntry.setType("Application");
        String exec = assoc != null ? Environment.getJavawsCommand() + " -open %U " + (String)args + jnlpLocation : Environment.getJavawsCommand() + " " + (String)args + jnlpLocation;
        desktopEntry.setExec(exec);
        desktopEntry.setIcon(iconPath);
        desktopEntry.setTerminal(false);
        desktopEntry.setName(appTitle);
        desktopEntry.setComment(description);
        desktopEntry.setCategories("Applications;" + categories);
        if (assoc != null) {
            desktopEntry.set("MimeType", assoc.getMimeType());
        }
        String name = this.uniqDesktopFileName(appTitle);
        String resultPath = isDesktop ? this.writeDesktopEntry(desktopEntry, name, assoc, level) : this.writeMenuEntry(desktopEntry, desktopPath, name);
        return resultPath;
    }

    private String uniqDesktopFileName(String name) {
        return "jws_app_shortcut_" + System.currentTimeMillis() + ".desktop";
    }

    private void installFailed(final LaunchDesc desc) {
        Runnable jOptionPaneRunnable = new Runnable(){

            @Override
            public void run() {
                ToolkitStore.getUI().showMessageDialog(null, null, 0, ResourceManager.getString((String)"install.installFailedTitle"), ResourceManager.getString((String)"install.installFailed"), UnixInstallHandler.this.nameFilter(desc.getInformation().getTitle()), null, null, null, null);
            }
        };
        UnixInstallHandler.invokeRunnable(jOptionPaneRunnable);
    }

    @Override
    public boolean removePathShortcut(String path) {
        return this.removeDesktopPath(path);
    }

    protected abstract boolean removeDesktopPath(String var1);

    protected abstract boolean removeDirectory(String var1);

    @Override
    protected boolean removeShortcuts(LaunchDesc desc, LocalApplicationProperties lap, boolean desktop) {
        String directoryFilePath;
        String startmenuFilePath;
        String desktopFilePath;
        boolean allUsers = false;
        if (Environment.isSystemCacheMode()) {
            desktop = false;
            allUsers = true;
        }
        Trace.println((String)"uninstall called in UnixInstallHandler", (TraceLevel)TraceLevel.BASIC);
        if (desktop && (desktopFilePath = lap.get(INSTALLED_DESKTOP_SHORTCUT_KEY)) != null) {
            this.removeDesktopPath(desktopFilePath);
            lap.put(INSTALLED_DESKTOP_SHORTCUT_KEY, null);
        }
        if ((startmenuFilePath = lap.get(INSTALLED_START_MENU_KEY)) != null) {
            this.removeDesktopPath(startmenuFilePath);
            lap.put(INSTALLED_START_MENU_KEY, null);
        }
        if ((startmenuFilePath = lap.get(INSTALLED_UNINSTALL_KEY)) != null) {
            this.removeDesktopPath(startmenuFilePath);
            lap.put(INSTALLED_UNINSTALL_KEY, null);
        }
        if ((startmenuFilePath = lap.get(INSTALLED_RC_KEY)) != null) {
            StringTokenizer st = new StringTokenizer(startmenuFilePath, ";");
            while (st.hasMoreElements()) {
                String filePath = st.nextToken();
                if (filePath == null || filePath.trim().length() == 0) continue;
                this.removeDesktopPath(filePath);
            }
            lap.put(INSTALLED_RC_KEY, null);
        }
        if ((directoryFilePath = lap.get(INSTALLED_DIRECTORY_KEY)) != null) {
            this.removeDirectory(directoryFilePath);
            lap.put(INSTALLED_DIRECTORY_KEY, null);
        }
        lap.setShortcutInstalled(false);
        UnixInstallHandler.save(lap);
        return true;
    }

    @Override
    protected boolean isAssociationFileExtSupported(String extension) {
        return true;
    }

    private String nameFilter(String name) {
        return this.Filter(name, "\"\\/|:?*<>#", '-');
    }

    protected String dirFilter(String name) {
        String dir = this.Filter(name, "\"|:?*<>#", '-');
        return this.Filter(dir, "/\\", File.separatorChar);
    }

    private String Filter(String name, String badChars, char replacement) {
        if (name == null) {
            return null;
        }
        return this.checkTitleString(name, badChars, replacement);
    }
}

