/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.security;

import com.sun.deploy.model.DeployCacheJarAccess;
import com.sun.deploy.model.Resource;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.net.JARSigningException;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.JarUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class SigningInfo {
    private static DeployCacheJarAccess jarAccess = ResourceProvider.get().getJarAccess();
    private Resource ce = null;
    private URL location = null;
    private String version = null;
    private boolean fileInCache;
    private boolean jarIsEmpty;
    private String jarFilePath = null;
    private boolean wasChecked = false;

    public static Certificate[] toCertificateArray(List<CertChain> chains) {
        Iterator<CertChain> it = chains.iterator();
        int len = 0;
        while (it.hasNext()) {
            CertChain o = it.next();
            if (o instanceof CertChain) {
                len += o.getLength();
                continue;
            }
            return null;
        }
        Certificate[] ret = new Certificate[len];
        it = chains.iterator();
        int i = 0;
        while (it.hasNext()) {
            Certificate[] chain = it.next().getCertificates();
            System.arraycopy(chain, 0, ret, i, chain.length);
            i += chain.length;
        }
        return ret;
    }

    private static boolean setContains(List<CodeSigner> signerList, CodeSigner otherSigner) {
        if (signerList == null || otherSigner == null) {
            return false;
        }
        for (CodeSigner signer : signerList) {
            if (!signer.getSignerCertPath().equals(otherSigner.getSignerCertPath())) continue;
            return true;
        }
        return false;
    }

    public static List<CertChain> overlapChainLists(List<CertChain> oldCertChains, List<CertChain> jarCertChains) {
        if (oldCertChains == null || jarCertChains == null) {
            return null;
        }
        ArrayList<CertChain> next = new ArrayList<CertChain>();
        for (CertChain oldChain : oldCertChains) {
            if (!jarCertChains.contains(oldChain)) continue;
            next.add(oldChain);
        }
        if (next.isEmpty()) {
            return null;
        }
        return next;
    }

    public static List<CodeSigner> overlapSigners(List<CodeSigner> commonSigners, CodeSigner[] signers) {
        ArrayList<CodeSigner> next = new ArrayList<CodeSigner>();
        if (signers == null) {
            return next;
        }
        for (CodeSigner signer : signers) {
            if (commonSigners != null && !SigningInfo.setContains(commonSigners, signer)) continue;
            next.add(signer);
        }
        return next;
    }

    private static CertChain getAChain(Certificate[] certs, int startIndex) {
        if (startIndex > certs.length - 1) {
            return null;
        }
        int i = 0;
        for (i = startIndex; i < certs.length - 1 && ((X509Certificate)certs[i + 1]).getSubjectDN().equals(((X509Certificate)certs[i]).getIssuerDN()); ++i) {
        }
        return new CertChain(certs, startIndex, i);
    }

    public SigningInfo(URL location, String version) {
        this.location = location;
        this.version = version;
        boolean ignoreVersion = false;
        try {
            this.jarFilePath = ResourceProvider.get().getCachedResourceFilePath(location, version);
            this.fileInCache = true;
        }
        catch (IOException ioe) {
            if (version != null) {
                try {
                    this.jarFilePath = ResourceProvider.get().getCachedResourceFilePath(location, null);
                    ignoreVersion = true;
                }
                catch (IOException e) {
                    this.fileInCache = false;
                }
            }
            this.fileInCache = false;
        }
        if (this.fileInCache && ResourceProvider.get().canCache(null)) {
            this.ce = ResourceProvider.get().getCachedResource(location, ignoreVersion ? null : version);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CodeSigner> check() throws IOException, JARSigningException {
        List<CodeSigner> result = null;
        if (this.ce != null) {
            JarFile f = this.ce.getJarFile();
            Trace.println((String)("Validating cached jar url=" + this.ce.getURL() + " ffile=" + this.ce.getResourceFilename() + " " + f), (TraceLevel)TraceLevel.SECURITY);
            result = this.getCommonCodeSignersForJar(f);
            if (result != null && result.isEmpty()) {
                result = null;
                throw new JARSigningException(this.location, this.version, 1);
            }
            this.wasChecked = true;
        } else {
            try (ZipFile toClose = null;){
                JarFile jarFile = ResourceProvider.get().getCachedJarFile(this.location, this.version);
                if (jarFile == null) {
                    if (this.jarFilePath != null) {
                        jarFile = JarUtil.createJarFile((File)new File(this.jarFilePath), (boolean)true);
                        toClose = jarFile;
                    } else {
                        throw new SecurityException("Unable to get path for main jar");
                    }
                }
                if ((result = this.getCommonCodeSignersForJar(jarFile)) != null && result.isEmpty()) {
                    result = null;
                    throw new JARSigningException(this.location, this.version, 1);
                }
            }
        }
        return result;
    }

    public List<CertChain> signersToCertChains(List<CodeSigner> signerList) throws IOException, JARSigningException {
        ArrayList<CertChain> certChains = new ArrayList<CertChain>();
        if (signerList != null) {
            for (CodeSigner signer : signerList) {
                CertChain chain;
                List<? extends Certificate> certList = signer.getSignerCertPath().getCertificates();
                Certificate[] certs = certList.toArray(new Certificate[0]);
                int startIndex = 0;
                while ((chain = SigningInfo.getAChain(certs, startIndex)) != null) {
                    certChains.add(chain);
                    startIndex += chain.getLength();
                }
            }
        }
        return certChains;
    }

    public List<CodeSigner> getCertificates() {
        if (this.ce != null) {
            return SigningInfo.overlapSigners(null, this.ce.getCodeSigners());
        }
        return null;
    }

    public boolean isFileKnownToBeNotCached() {
        return !this.fileInCache;
    }

    public boolean isJarKnownToBeEmpty() {
        return this.jarIsEmpty;
    }

    List<CodeSigner> getCommonCodeSignersForJar(JarFile jf) throws IOException {
        List<CodeSigner> commonSigners = null;
        boolean jarEntryFound = false;
        try {
            if (jarAccess != null) {
                jarAccess.getCodeSource(jf, new URL("http:"), "/NOP");
                CodeSource[] codeSources = jarAccess.getCodeSources(jf, null);
                jarAccess.setEagerValidation(jf, true);
                Enumeration entries = jarAccess.entryNames(jf, codeSources);
                while (entries.hasMoreElements() && (commonSigners == null || !commonSigners.isEmpty())) {
                    String entryName = (String)entries.nextElement();
                    CodeSource cs = jarAccess.getCodeSource(jf, null, entryName);
                    jarEntryFound = true;
                    CodeSigner[] signers = cs.getCodeSigners();
                    if (signers == null) continue;
                    commonSigners = SigningInfo.overlapSigners(commonSigners, signers);
                }
            } else {
                Enumeration<JarEntry> entries = jf.entries();
                while (entries.hasMoreElements() && (commonSigners == null || !commonSigners.isEmpty())) {
                    byte[] buffer = new byte[8192];
                    JarEntry je = entries.nextElement();
                    if (JarUtil.canSkipEntry((ZipEntry)je)) continue;
                    jarEntryFound = true;
                    InputStream is = jf.getInputStream(je);
                    while (is.read(buffer, 0, buffer.length) != -1) {
                    }
                    is.close();
                    CodeSigner[] signers = je.getCodeSigners();
                    if (signers == null) continue;
                    commonSigners = SigningInfo.overlapSigners(commonSigners, signers);
                }
            }
        }
        catch (JARSigningException jse) {
            throw jse;
        }
        catch (IOException ioe) {
            throw new JARSigningException(this.location, this.version, 2, (Exception)ioe);
        }
        catch (SecurityException e) {
            throw new JARSigningException(this.location, this.version, 2, (Exception)e);
        }
        this.jarIsEmpty = !jarEntryFound;
        return commonSigners;
    }

    static class CertChain {
        Certificate[] certs;

        CertChain(Certificate[] certs, int startIndex, int endIndex) {
            this.certs = new Certificate[endIndex - startIndex + 1];
            for (int j = 0; j < this.certs.length; ++j) {
                this.certs[j] = certs[startIndex + j];
            }
        }

        Certificate[] getCertificates() {
            return this.certs;
        }

        int getLength() {
            return this.certs.length;
        }

        public int hashCode() {
            if (this.certs.length == 0) {
                return 0;
            }
            return this.certs[0].hashCode();
        }

        public boolean equals(Object o) {
            CertChain c = (CertChain)o;
            if (c == null || c.getLength() != this.getLength()) {
                return false;
            }
            for (int i = 0; i < this.certs.length; ++i) {
                if (c.certs[i].equals(this.certs[i])) continue;
                return false;
            }
            return true;
        }
    }
}

