/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.xdg;

import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.xdg.BaseDir;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

final class UserDirs {
    private static final String XDG_DESKTOP_DIR = "XDG_DESKTOP_DIR";
    private static UserDirs instance;

    UserDirs() {
    }

    public static synchronized UserDirs getInstance() {
        if (instance == null) {
            instance = new UserDirs();
        }
        return instance;
    }

    public String getDesktopDir() {
        Object configuredDesktop = this.getEnvVarFromDirsConfig(XDG_DESKTOP_DIR);
        if (configuredDesktop == null) {
            configuredDesktop = System.getProperty("user.home") + File.separatorChar + "Desktop";
        }
        return configuredDesktop;
    }

    private String getEnvVarFromDirsConfig(String var) {
        BaseDir bd = BaseDir.getInstance();
        String confPath = bd.getUserConfigDir();
        File userDirsConfFile = new File(confPath, "user-dirs.dirs");
        String value = null;
        if (userDirsConfFile.exists()) {
            try {
                Map vars = this.parseDirsConfig(userDirsConfFile);
                return (String)vars.get(var);
            }
            catch (IOException ex) {
                Trace.ignored((Throwable)ex);
            }
        }
        return value;
    }

    private Map parseDirsConfig(File userDirsConfFile) throws IOException {
        HashMap<String, String> keyvals = new HashMap<String, String>();
        FileInputStream fis = new FileInputStream(userDirsConfFile);
        InputStreamReader isr = new InputStreamReader(fis);
        BufferedReader br = new BufferedReader(isr);
        String line = br.readLine();
        while (line != null) {
            int splitIdx;
            if (!line.startsWith("#") && (splitIdx = line.indexOf(61)) != -1) {
                int len;
                String key = line.substring(0, splitIdx).trim();
                String value = line.substring(splitIdx + 1, line.length()).trim();
                if (value.charAt(0) == '\"') {
                    value = value.substring(1);
                }
                if (value.charAt((len = value.length()) - 1) == '\"') {
                    value = value.substring(0, len - 1);
                }
                value = value.replace("$HOME", System.getProperty("user.home"));
                Trace.println((String)("Adding env var: " + key + "=" + value), (TraceLevel)TraceLevel.UI);
                keyvals.put(key, value);
            }
            line = br.readLine();
        }
        return keyvals;
    }
}

