/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.javaws.util.JNLPUtils;
import com.sun.jnlp.ApiDialog;
import com.sun.jnlp.CheckServicePermission;
import java.awt.AWTPermission;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.FilePermission;
import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import javax.jnlp.ClipboardService;

public final class ClipboardServiceImpl
implements ClipboardService {
    private static ClipboardServiceImpl _sharedInstance = null;
    private Clipboard _sysClipboard = null;
    private ApiDialog _readDialog = new ApiDialog();
    private ApiDialog _writeDialog = new ApiDialog();
    private static final AccessControlContext ACC_CLIPBOARD_INSTANCE = AccessController.doPrivileged(new PrivilegedAction<AccessControlContext>(){

        @Override
        public AccessControlContext run() {
            Permissions perms = new Permissions();
            AWTPermission perm = new AWTPermission("accessClipboard");
            ((PermissionCollection)perms).add(perm);
            return new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, perms)});
        }
    });
    private static final AccessControlContext ACC_FILE_INSTANCE = AccessController.doPrivileged(new PrivilegedAction<AccessControlContext>(){

        @Override
        public AccessControlContext run() {
            Permissions perms = new Permissions();
            FilePermission perm = new FilePermission("<<ALL FILES>>", "read,write");
            ((PermissionCollection)perms).add(perm);
            return new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, perms)});
        }
    });

    private ClipboardServiceImpl() {
        final Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (toolkit != null) {
            this._sysClipboard = AccessController.doPrivileged(new PrivilegedAction<Clipboard>(){

                @Override
                public Clipboard run() {
                    return toolkit.getSystemClipboard();
                }
            }, ACC_CLIPBOARD_INSTANCE);
        }
    }

    public static synchronized ClipboardServiceImpl getInstance() {
        if (_sharedInstance == null) {
            _sharedInstance = new ClipboardServiceImpl();
        }
        return _sharedInstance;
    }

    public Transferable getContents() {
        if (!this.askUser(false)) {
            return null;
        }
        return AccessController.doPrivileged(new PrivilegedAction<Transferable>(){

            @Override
            public Transferable run() {
                return ClipboardServiceImpl.this._sysClipboard.getContents(null);
            }
        }, ACC_CLIPBOARD_INSTANCE);
    }

    public void setContents(final Transferable contents) {
        if (!this.askUser(true)) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                if (contents != null) {
                    DataFlavor[] flavors = contents.getTransferDataFlavors();
                    if (flavors == null || flavors[0] == null) {
                        return null;
                    }
                    try {
                        if (contents.getTransferData(flavors[0]) == null) {
                            return null;
                        }
                    }
                    catch (IOException ioe) {
                        Trace.ignoredException((Exception)ioe);
                    }
                    catch (UnsupportedFlavorException ufe) {
                        Trace.ignoredException((Exception)ufe);
                    }
                }
                ClipboardServiceImpl.this._sysClipboard.setContents(contents, null);
                return null;
            }
        }, ACC_CLIPBOARD_INSTANCE);
    }

    private synchronized boolean askUser(boolean isWrite) {
        if (!this.hasClipboard()) {
            return false;
        }
        if (CheckServicePermission.hasClipboardPermissions()) {
            return true;
        }
        String title = ResourceManager.getString((String)"api.clipboard.title");
        if (isWrite) {
            String msg = ResourceManager.getString((String)"api.clipboard.message.write");
            String always = ResourceManager.getString((String)"api.clipboard.write.always");
            return ClipboardServiceImpl.askUser(this._writeDialog, title, msg, always, "jnlp.api.always.ClipboardService.write");
        }
        String msg = ResourceManager.getString((String)"api.clipboard.message.read");
        String always = ResourceManager.getString((String)"api.clipboard.read.always");
        return ClipboardServiceImpl.askUser(this._readDialog, title, msg, always, "jnlp.api.always.ClipboardService.read");
    }

    private static boolean askUser(ApiDialog dlg, String title, String msg, String always, final String key) {
        String value;
        final LocalApplicationProperties lap = JNLPUtils.getLocalApplicationProperties();
        if (lap != null && (value = lap.get(key)) != null) {
            return true;
        }
        ApiDialog.DialogResult result = dlg.askUser(title, msg, always);
        if (result == ApiDialog.DialogResult.ALWAYS) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    lap.put(key, "skip");
                    try {
                        lap.store();
                    }
                    catch (Throwable e) {
                        Trace.ignored((Throwable)e);
                    }
                    return null;
                }
            }, ACC_FILE_INSTANCE);
        }
        return result == ApiDialog.DialogResult.OK || result == ApiDialog.DialogResult.ALWAYS;
    }

    private boolean hasClipboard() {
        return this._sysClipboard != null;
    }
}

