/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.deploy.config.Platform;
import com.sun.jnlp.ExtendedServiceImpl;
import com.sun.jnlp.FileContentsImpl;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import javax.jnlp.ExtendedService;
import javax.jnlp.FileContents;

public final class ExtendedServiceNSBImpl
implements ExtendedService {
    private final ExtendedServiceImpl service;
    private static final AccessControlContext ACC_FILE_INSTANCE = AccessController.doPrivileged(new PrivilegedAction<AccessControlContext>(){

        @Override
        public AccessControlContext run() {
            Permissions perms = new Permissions();
            FilePermission perm = new FilePermission("<<ALL FILES>>", "read,write");
            ((PermissionCollection)perms).add(perm);
            return new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, perms)});
        }
    });

    public ExtendedServiceNSBImpl(ExtendedServiceImpl service) {
        this.service = service;
    }

    public FileContents openFile(File f) throws IOException {
        if (f == null) {
            return null;
        }
        final File file = new File(f.getPath());
        if (!Platform.get().getNativeSandboxBroker().openFile(file.getAbsolutePath())) {
            return null;
        }
        Object ret = AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    return new FileContentsImpl(file, ExtendedServiceImpl.DEFAULT_FILESIZE);
                }
                catch (IOException ioe) {
                    return ioe;
                }
            }
        }, ACC_FILE_INSTANCE);
        if (ret instanceof IOException) {
            throw (IOException)ret;
        }
        return (FileContents)ret;
    }

    public FileContents[] openFiles(File[] f) throws IOException {
        if (f == null || f.length <= 0) {
            return null;
        }
        final File[] files = new File[f.length];
        for (int i = 0; i < f.length; ++i) {
            files[i] = new File(f[i].getPath());
        }
        String[] fileNames = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            fileNames[i] = files[i].getAbsolutePath();
        }
        if (!Platform.get().getNativeSandboxBroker().openFiles(fileNames)) {
            return null;
        }
        Object[] fcs = AccessController.doPrivileged(new PrivilegedAction<Object[]>(){

            @Override
            public Object[] run() {
                Object[] fcontents = new FileContents[files.length];
                try {
                    for (int i = 0; i < files.length; ++i) {
                        fcontents[i] = new FileContentsImpl(files[i], ExtendedServiceImpl.DEFAULT_FILESIZE);
                    }
                }
                catch (IOException ioe) {
                    fcontents[0] = ioe;
                }
                return fcontents;
            }
        }, ACC_FILE_INSTANCE);
        if (fcs[0] instanceof IOException) {
            throw (IOException)fcs[0];
        }
        return (FileContents[])fcs;
    }
}

