/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.association.utility;

import com.sun.deploy.association.utility.DesktopEntry;
import com.sun.deploy.association.utility.GnomeVfsWrapper;
import com.sun.deploy.config.Platform;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class DesktopEntryFile {
    private String uri = null;
    private ArrayList desktopEntries = null;

    public DesktopEntryFile(String uri) {
        if (null == uri) {
            throw new NullPointerException("uri is null!");
        }
        if (uri.indexOf("://") == 0) {
            throw new IllegalArgumentException("Invalid URI[" + uri + "]!");
        }
        this.uri = uri;
        this.desktopEntries = new ArrayList();
        Trace.println("new DesktopEntryFile uri = [" + uri + "]", TraceLevel.BASIC);
    }

    public DesktopEntryFile(File file) {
        this(file.toURI().toString());
    }

    public String getParent() {
        int prefixLength;
        String path = this.uri.toString();
        int index = path.lastIndexOf(File.separator);
        if (index < (prefixLength = path.indexOf("://") + 3)) {
            if (prefixLength > 0 && path.length() > prefixLength) {
                return path.substring(0, prefixLength);
            }
            return "/";
        }
        return path.substring(0, index);
    }

    private DesktopEntryFile getParentDesktopEntryFile() {
        String parent = this.getParent();
        return parent == null ? null : new DesktopEntryFile(parent);
    }

    public Collection readEntries() throws IOException {
        this.readEntryInternal();
        return this.desktopEntries;
    }

    public void writeEntry(DesktopEntry desktopEntry) throws IOException {
        ArrayList<DesktopEntry> l = new ArrayList<DesktopEntry>();
        l.add(desktopEntry);
        this.writeEntries(l);
    }

    public void writeEntries(Collection entries) throws IOException {
        this.desktopEntries = new ArrayList(entries);
        this.writeEntryInternal();
    }

    public boolean exists() {
        return GnomeVfsWrapper.gnome_vfs_file_exists(this.uri.toString());
    }

    public boolean delete() {
        return GnomeVfsWrapper.gnome_vfs_delete_file(this.uri.toString());
    }

    public boolean deleteToNonEmptyParent() {
        for (DesktopEntryFile path = this; null != path && path.exists() && !path.getURI().matches(".*://") && path.delete(); path = path.getParentDesktopEntryFile()) {
            Trace.println("file deleted " + path.toString(), TraceLevel.BASIC);
        }
        return true;
    }

    public boolean mkdir() throws IOException {
        return GnomeVfsWrapper.gnome_vfs_mkdir(this.uri.toString());
    }

    private void readEntryInternal() throws IOException {
        String fileContents = GnomeVfsWrapper.gnome_vfs_read_file(this.uri.toString());
        if (fileContents == null) {
            throw new IOException("Unable to load file entry.");
        }
        BufferedReader br = new BufferedReader(new StringReader(fileContents));
        String line = null;
        DesktopEntry entry = null;
        boolean len = false;
        while (null != (line = br.readLine())) {
            if (line.matches("^\\s*\\[.*\\]\\s*")) {
                if (null != entry) continue;
                entry = new DesktopEntry(DesktopEntryFile.trimBracket(line));
                this.desktopEntries.add(entry);
                continue;
            }
            if (null == entry) continue;
            entry.load(line);
        }
    }

    private static String trimBracket(String src) {
        if (null == src) {
            return "";
        }
        int len = src.length();
        if (len > 1) {
            return src.trim().substring(1, len - 1);
        }
        return "";
    }

    private void writeEntryInternal() throws IOException {
        DesktopEntryFile path;
        ArrayList<DesktopEntryFile> l = new ArrayList<DesktopEntryFile>();
        for (path = this.getParentDesktopEntryFile(); null != path && !path.exists(); path = path.getParentDesktopEntryFile()) {
            l.add(path);
        }
        for (int i = l.size() - 1; i >= 0; --i) {
            path = (DesktopEntryFile)l.get(i);
            Trace.println("writeEntryInternal mkdir " + path.toString(), TraceLevel.BASIC);
            path.mkdir();
        }
        StringBuffer sb = new StringBuffer();
        Iterator it = this.desktopEntries.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            sb.append("\n");
        }
        Trace.println("gnome_vfs_write_file [" + this.uri.toString() + "]", TraceLevel.BASIC);
        boolean b = GnomeVfsWrapper.gnome_vfs_write_file(this.uri.toString(), sb.toString());
    }

    public String getURI() {
        return this.uri;
    }

    public String toString() {
        return "DesktopEntryFile[" + this.uri + "]";
    }

    static {
        Platform.get().loadDeployNativeLib();
    }
}

