/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.association.utility;

import com.sun.deploy.association.Action;
import com.sun.deploy.association.Association;
import com.sun.deploy.association.RegisterFailedException;
import com.sun.deploy.association.utility.AppAssociationWriter;
import com.sun.deploy.association.utility.AppUtility;
import com.sun.deploy.association.utility.GnomeAssociationUtil;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.trace.Trace;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

final class GnomeAppAssociationWriter
implements AppAssociationWriter {
    static final String GNOMEDIR_VALUE = GnomeAssociationUtil.getEnv("GNOMEDIR");
    static final String GNOME_LINUX_SYSTEM_SHARE_DIR = GNOMEDIR_VALUE == null ? "/usr/share/" : GNOMEDIR_VALUE + "/share/";
    static final String GNOME_SOLARIS_SYSTEM_SHARE_DIR = "/usr/share/gnome/";
    static final String GNOME_LINUX_SYSTEM_MIME_INFO_DIR = GNOME_LINUX_SYSTEM_SHARE_DIR + "mime-info/";
    static final String GNOME_SOLARIS_SYSTEM_MIME_INFO_DIR = "/usr/share/gnome/mime-info/";
    static final String GNOME_LINUX_SYSTEM_APPLICATION_REGISTRY_DIR = GNOME_LINUX_SYSTEM_SHARE_DIR + "application-registry/";
    static final String GNOME_SOLARIS_SYSTEM_APPLICATION_REGISTRY_DIR = "/usr/share/gnome/application-registry/";
    static final String OSNAME = System.getProperty("os.name").toLowerCase();
    static final String GNOME_SYSTEM_MIME_INFO_DIR = OSNAME.equals("linux") ? GNOME_LINUX_SYSTEM_MIME_INFO_DIR : "/usr/share/gnome/mime-info/";
    static final String GNOME_SYSTEM_APPLICATION_REGISTRY_DIR = OSNAME.equals("linux") ? GNOME_LINUX_SYSTEM_APPLICATION_REGISTRY_DIR : "/usr/share/gnome/application-registry/";
    static final String GNOME_USER_MIME_INFO_DIR = System.getProperty("user.home") + "/.gnome/mime-info/";
    static final String GNOME_USER_APPLICATION_INFO_DIR = System.getProperty("user.home") + "/.gnome/application-info/";
    static final String MIME_SUFFIX = ".mime";
    static final String KEYS_SUFFIX = ".keys";
    static final String APPLICATIONS_SUFFIX = ".applications";
    private String defaultAppID = null;
    private String defaultAppCommand = null;

    public GnomeAppAssociationWriter(LocalApplicationProperties lap) {
    }

    private String fileExtListToString(List fileExtList) {
        String fileExtListString = "";
        Iterator fileExtIter = fileExtList.iterator();
        if (fileExtIter != null) {
            while (fileExtIter.hasNext()) {
                String temFileExt = (String)fileExtIter.next();
                if (temFileExt == null) continue;
                temFileExt = AppUtility.removeDotFromFileExtension(temFileExt);
                if (fileExtListString.length() == 0) {
                    fileExtListString = fileExtListString.concat(temFileExt);
                    continue;
                }
                fileExtListString = fileExtListString.concat(" " + temFileExt);
            }
        } else {
            fileExtListString = null;
        }
        return fileExtListString;
    }

    private String getSystemDotMimeFilePath(Association assoc) {
        return GNOME_SYSTEM_MIME_INFO_DIR + assoc.getName() + MIME_SUFFIX;
    }

    private String getSystemDotKeysFilePath(Association assoc) {
        return GNOME_SYSTEM_MIME_INFO_DIR + assoc.getName() + KEYS_SUFFIX;
    }

    private String getSystemDotApplicationsFilePath(Association assoc) {
        return GNOME_SYSTEM_APPLICATION_REGISTRY_DIR + assoc.getName() + APPLICATIONS_SUFFIX;
    }

    private String getUserDotMimeFilePath(Association assoc) {
        return GNOME_USER_MIME_INFO_DIR + assoc.getName() + MIME_SUFFIX;
    }

    private String getUserDotKeysFilePath(Association assoc) {
        return GNOME_USER_MIME_INFO_DIR + assoc.getName() + KEYS_SUFFIX;
    }

    private String getUserDotApplicationsFilePath(Association assoc) {
        return GNOME_USER_APPLICATION_INFO_DIR + assoc.getName() + APPLICATIONS_SUFFIX;
    }

    private void checkSystemMIMEDatabase() throws IOException {
        File tempFile = null;
        tempFile = new File(GNOME_SYSTEM_MIME_INFO_DIR);
        if (!tempFile.exists()) {
            throw new IOException("The system MIME info directory doesn't exist: " + GNOME_SYSTEM_MIME_INFO_DIR + ". Make sure Gnome 2.0+ is installed and env GNOMEDIR is set properly.");
        }
        tempFile = new File(GNOME_SYSTEM_APPLICATION_REGISTRY_DIR);
        if (!tempFile.exists()) {
            throw new IOException("The system MIME info directory doesn't exist: " + GNOME_SYSTEM_APPLICATION_REGISTRY_DIR + ". Make sure Gnome 2.0+ is installed and env GNOMEDIR is set properly.");
        }
        tempFile = new File(GNOME_SYSTEM_MIME_INFO_DIR);
        if (!tempFile.canWrite()) {
            throw new IOException("No write permission to the system MIME info directory: " + GNOME_SYSTEM_MIME_INFO_DIR);
        }
        tempFile = new File(GNOME_SYSTEM_APPLICATION_REGISTRY_DIR);
        if (!tempFile.canWrite()) {
            throw new IOException("No write permission to the system MIME info directory: " + GNOME_SYSTEM_APPLICATION_REGISTRY_DIR);
        }
    }

    private void checkUserMIMEDatabase() throws IOException {
        boolean mksucceed;
        File tempFile = null;
        tempFile = new File(GNOME_USER_MIME_INFO_DIR);
        if (!tempFile.exists() && !(mksucceed = tempFile.mkdirs())) {
            throw new IOException("The user MIME info directory doesn't exist, and fails to be created: " + GNOME_USER_MIME_INFO_DIR);
        }
        tempFile = new File(GNOME_USER_APPLICATION_INFO_DIR);
        if (!tempFile.exists() && !(mksucceed = tempFile.mkdirs())) {
            throw new IOException("The user MIME info directory doesn't exist, and fails to be created: " + GNOME_USER_APPLICATION_INFO_DIR);
        }
        tempFile = new File(GNOME_USER_MIME_INFO_DIR);
        if (!tempFile.canWrite()) {
            throw new IOException("No write permission to the user MIME info directory: " + GNOME_USER_MIME_INFO_DIR);
        }
        tempFile = new File(GNOME_USER_APPLICATION_INFO_DIR);
        if (!tempFile.canWrite()) {
            throw new IOException("No write permission to the user MIME info directory: " + GNOME_USER_MIME_INFO_DIR);
        }
    }

    private void createFile(String mimeFilePath) throws IOException {
        boolean createSucceed = false;
        File mimeFile = new File(mimeFilePath);
        if (!mimeFile.exists() && !(createSucceed = mimeFile.createNewFile())) {
            throw new IOException("Create MIME file: " + mimeFilePath + " failed.");
        }
    }

    private void parseOpenAction(Association assoc) {
        List<Action> actionList = assoc.getActionList();
        if (actionList == null) {
            return;
        }
        String verb = null;
        Iterator<Action> actionIter = actionList.iterator();
        while (actionIter.hasNext() && this.defaultAppCommand == null) {
            Action oneAction = actionIter.next();
            verb = oneAction.getVerb();
            if (!verb.equalsIgnoreCase("open")) continue;
            this.defaultAppCommand = oneAction.getCommand().trim();
        }
        if (this.defaultAppCommand != null) {
            int sepIndex = this.defaultAppCommand.lastIndexOf(File.separator);
            this.defaultAppID = sepIndex == -1 || sepIndex == this.defaultAppCommand.length() - 1 ? this.defaultAppCommand : this.defaultAppCommand.substring(sepIndex + 1, this.defaultAppCommand.length());
        }
    }

    private void writeDotMimeFile(Association assoc, String dotMimeFilePath) throws IOException {
        this.createFile(dotMimeFilePath);
        String mimeType = assoc.getMimeType();
        List<String> fileExtList = assoc.getFileExtList();
        BufferedWriter mBufferWriter = null;
        try {
            mBufferWriter = new BufferedWriter(new FileWriter(dotMimeFilePath, true));
            mBufferWriter.write(mimeType + "\n");
            String fileExtensionString = null;
            fileExtensionString = fileExtList == null ? "" : this.fileExtListToString(fileExtList);
            mBufferWriter.write("\text: " + fileExtensionString + "\n");
            mBufferWriter.write("\n");
        }
        catch (IOException e) {
            throw new IOException("Write mime info to " + dotMimeFilePath + " failed.");
        }
        finally {
            if (mBufferWriter != null) {
                try {
                    mBufferWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void writeDotKeysFile(Association assoc, String dotKeysFilePath) throws IOException {
        this.createFile(dotKeysFilePath);
        String mimeType = assoc.getMimeType();
        String description = assoc.getDescription();
        String iconFileName = assoc.getIconFileName();
        BufferedWriter kBufferWriter = null;
        try {
            kBufferWriter = new BufferedWriter(new FileWriter(dotKeysFilePath, true));
            kBufferWriter.write(mimeType + "\n");
            if (description != null) {
                kBufferWriter.write("\tdescription=" + description + "\n");
            }
            if (iconFileName != null) {
                kBufferWriter.write("\ticon_filename=" + iconFileName + "\n");
            }
            this.parseOpenAction(assoc);
            if (this.defaultAppID != null) {
                kBufferWriter.write("\tdefault_action_type=application\n");
                kBufferWriter.write("\tdefault_application_id=" + this.defaultAppID + "\n");
                kBufferWriter.write("\tshort_list_application_user_additions=" + this.defaultAppID + "\n");
            }
            kBufferWriter.write("\n");
        }
        catch (IOException e) {
            throw new IOException("Write mime info to " + dotKeysFilePath + " failed.");
        }
        finally {
            if (kBufferWriter != null) {
                try {
                    kBufferWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void writeDotApplicationsFile(Association assoc, String dotApplicationsFilePath) throws IOException {
        this.createFile(dotApplicationsFilePath);
        BufferedWriter mBufferWriter = null;
        try {
            this.parseOpenAction(assoc);
            if (this.defaultAppID != null && this.defaultAppCommand != null) {
                mBufferWriter = new BufferedWriter(new FileWriter(dotApplicationsFilePath, true));
                mBufferWriter.write(this.defaultAppID + "\n");
                mBufferWriter.write("\tcommand=" + this.defaultAppCommand + "\n");
                mBufferWriter.write("\tname=" + this.defaultAppID + "\n");
                mBufferWriter.write("\tcan_open_multiple_files=false\n");
                mBufferWriter.write("\trequires_terminal=false\n");
                String mimeType = assoc.getMimeType();
                mBufferWriter.write("\tmime_types=" + mimeType + "\n");
                mBufferWriter.write("\n");
            }
        }
        catch (IOException e) {
            throw new IOException("Write mime info to " + dotApplicationsFilePath + " failed.");
        }
        finally {
            if (mBufferWriter != null) {
                try {
                    mBufferWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private boolean dotMimeFileContains(File dotMimeFile, String mimeType, String fileExtString) {
        boolean mimeExists = false;
        boolean extensionExists = fileExtString == null;
        try {
            String oneLine;
            BufferedReader mBufferReader = new BufferedReader(new FileReader(dotMimeFile));
            while ((oneLine = mBufferReader.readLine()) != null) {
                if (mimeType.equals(oneLine)) {
                    mimeExists = true;
                    if (!extensionExists) continue;
                    break;
                }
                if (extensionExists || !oneLine.contains("ext:") || !oneLine.contains(fileExtString)) continue;
                extensionExists = true;
                if (!mimeExists) continue;
            }
            mBufferReader.close();
            return mimeExists && extensionExists;
        }
        catch (Throwable t) {
            Trace.ignored(t);
            return false;
        }
    }

    @Override
    public void checkAssociationValidForRegistration(Association assoc) throws IllegalArgumentException {
        if (assoc.getName() == null || assoc.getMimeType() == null) {
            throw new IllegalArgumentException("The given association is invalid. It should specify both the name and mimeType fields to perform this operation.");
        }
    }

    @Override
    public void checkAssociationValidForUnregistration(Association assoc) throws IllegalArgumentException {
        if (assoc.getName() == null) {
            throw new IllegalArgumentException("The given association is invalid. It should specify the name field to perform this operation.");
        }
    }

    @Override
    public boolean isAssociationExist(Association assoc, int level) {
        File dotMimeFile = null;
        dotMimeFile = level == 2 ? new File(this.getSystemDotMimeFilePath(assoc)) : new File(this.getUserDotMimeFilePath(assoc));
        List<String> fileExtList = assoc.getFileExtList();
        String fileExtensionString = null;
        if (fileExtList != null) {
            fileExtensionString = this.fileExtListToString(fileExtList);
        }
        if (dotMimeFile.exists()) {
            if (assoc.getMimeType() == null) {
                return true;
            }
            return this.dotMimeFileContains(dotMimeFile, assoc.getMimeType(), fileExtensionString);
        }
        return false;
    }

    @Override
    public void registerAssociation(Association assoc, int level) throws RegisterFailedException {
        String dotMimeFilePath = null;
        String dotKeysFilePath = null;
        String dotApplicationsFilePath = null;
        try {
            if (level == 2) {
                this.checkSystemMIMEDatabase();
                dotMimeFilePath = this.getSystemDotMimeFilePath(assoc);
                dotKeysFilePath = this.getSystemDotKeysFilePath(assoc);
                dotApplicationsFilePath = this.getSystemDotApplicationsFilePath(assoc);
            } else {
                this.checkUserMIMEDatabase();
                dotMimeFilePath = this.getUserDotMimeFilePath(assoc);
                dotKeysFilePath = this.getUserDotKeysFilePath(assoc);
                dotApplicationsFilePath = this.getUserDotApplicationsFilePath(assoc);
            }
            this.writeDotMimeFile(assoc, dotMimeFilePath);
            this.writeDotKeysFile(assoc, dotKeysFilePath);
            this.writeDotApplicationsFile(assoc, dotApplicationsFilePath);
        }
        catch (IOException e) {
            if (dotMimeFilePath != null) {
                new File(dotMimeFilePath).delete();
            }
            if (dotKeysFilePath != null) {
                new File(dotKeysFilePath).delete();
            }
            if (dotApplicationsFilePath != null) {
                new File(dotApplicationsFilePath).delete();
            }
            throw new RegisterFailedException(e.getMessage());
        }
    }

    @Override
    public void unregisterAssociation(Association assoc, int level) throws RegisterFailedException {
        String dotMimeFilePath = null;
        String dotKeysFilePath = null;
        String dotApplicationsFilePath = null;
        try {
            if (level == 2) {
                this.checkSystemMIMEDatabase();
                dotMimeFilePath = this.getSystemDotMimeFilePath(assoc);
                dotKeysFilePath = this.getSystemDotKeysFilePath(assoc);
                dotApplicationsFilePath = this.getSystemDotApplicationsFilePath(assoc);
            } else {
                this.checkUserMIMEDatabase();
                dotMimeFilePath = this.getUserDotMimeFilePath(assoc);
                dotKeysFilePath = this.getUserDotKeysFilePath(assoc);
                dotApplicationsFilePath = this.getUserDotApplicationsFilePath(assoc);
            }
            new File(dotMimeFilePath).delete();
            new File(dotKeysFilePath).delete();
            new File(dotApplicationsFilePath).delete();
        }
        catch (IOException e) {
            throw new RegisterFailedException(e.getMessage());
        }
    }
}

