/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.cache;

import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.CacheEntry;
import com.sun.deploy.cache.DeployCacheJarAccessImpl;
import com.sun.deploy.cache.MemoryCache;
import com.sun.deploy.model.DeployCacheJarAccess;
import com.sun.deploy.model.DownloadDelegate;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.model.Resource;
import com.sun.deploy.model.ResourceObject;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.net.FailedDownloadException;
import com.sun.deploy.net.HttpRequest;
import com.sun.deploy.net.HttpResponse;
import com.sun.deploy.net.HttpUtils;
import com.sun.deploy.net.UpdateTracker;
import com.sun.deploy.net.offline.DeployOfflineManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.SessionState;
import com.sun.deploy.util.URLUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ResourceProviderImpl
extends ResourceProvider {
    private SessionLoadedResourceStorage sessionLoadedResourceStorage = new SessionLoadedResourceStorage();

    @Override
    public void setBackgroundUpdateRequest(boolean background) {
        DownloadEngine._setBackgroundUpdateRequest(background);
    }

    @Override
    public boolean isBackgroundUpdateRequest() {
        return DownloadEngine.isBackgroundUpdateRequest();
    }

    @Override
    public int incrementInternalUse() {
        return DownloadEngine._incrementInternalUse();
    }

    @Override
    public void decrementInternalUse(int myLevel) {
        DownloadEngine._decrementInternalUse(myLevel);
    }

    @Override
    public boolean isUpdateAvailable(URL href, String version, int downloadTypes, Map<String, List<String>> requestHeaders) throws IOException {
        if (this.isUpdateDisabledPerPolicy()) {
            return false;
        }
        if (UpdateTracker.isUpdated(href.toString())) {
            return false;
        }
        URL urlNoQuery = HttpUtils.removeQueryStringFromURL(href);
        if (!DownloadEngine.isBackgroundUpdateRequest() && ResourceProviderImpl.isInBackgroundUpdateCheckList(href)) {
            return false;
        }
        CacheEntry ce = null;
        if (Cache.isCacheEnabled()) {
            ce = Cache.getCacheEntry(version == null ? href : urlNoQuery, version);
        }
        if (ce == null) {
            return true;
        }
        if (version != null) {
            return false;
        }
        if (!this.isValidationRequired(ce)) {
            return false;
        }
        if (ce.getLastModified() == 0L) {
            return true;
        }
        return this.checkUpdateAvailable(href, ce, downloadTypes, requestHeaders);
    }

    @Override
    public boolean checkUpdateAvailable(URL href, Resource ce, int downloadTypes, Map<String, List<String>> requestHeaders) throws IOException {
        String version = ce.getVersion();
        if (!DeployOfflineManager.promptUserGoOnline(href)) {
            throw new FailedDownloadException(href, null, null, true);
        }
        if (DeployOfflineManager.isGlobalOffline()) {
            throw new FailedDownloadException(href, null, null, true);
        }
        URL requestURL = DownloadEngine.getRequestURL(href, version, null, false, null);
        HttpRequest httpreq = DownloadEngine.getHttpRequestImpl();
        HttpResponse response = null;
        long cacheEntryLastModified = -1L;
        cacheEntryLastModified = ce.getLastModified();
        URL pack200RequestURL = null;
        if (DownloadEngine.isPackContentType(downloadTypes)) {
            pack200RequestURL = URLUtil.getPack200URL(requestURL, false);
        }
        String[] keys = null;
        String[] values = null;
        if (requestHeaders != null) {
            keys = requestHeaders.keySet().toArray(new String[0]);
            values = new String[keys.length];
            for (int i = 0; i < keys.length; ++i) {
                List<String> o = requestHeaders.get(keys[i]);
                if (o == null || !(o instanceof List)) continue;
                values[i] = o.get(0);
            }
        }
        try {
            response = httpreq.doGetRequestEX(pack200RequestURL != null ? pack200RequestURL : requestURL, keys, values, cacheEntryLastModified);
        }
        catch (FileNotFoundException fnfe) {
            if (pack200RequestURL == null) {
                throw fnfe;
            }
            response = httpreq.doGetRequestEX(requestURL, cacheEntryLastModified);
        }
        if (response == null) {
            return true;
        }
        int statusCode = response.getStatusCode();
        response.disconnect();
        boolean updateAvail = true;
        if (statusCode == 304) {
            updateAvail = false;
        } else if (statusCode == 200) {
            int length = response.getContentLength();
            long lastModified = response.getLastModified();
            if (lastModified == cacheEntryLastModified && length == ce.getContentLength()) {
                updateAvail = false;
            }
            Trace.println("CacheEntry[" + href + "]: updateAvailable=" + updateAvail + ",lastModified=" + new Date(cacheEntryLastModified) + ",length=" + ce.getContentLength(), TraceLevel.DEFAULT);
        }
        if (!updateAvail) {
            UpdateTracker.checkDone(href.toString());
            long expiration = HttpUtils.getEffectiveExpiration(response);
            if (expiration != 0L && ce instanceof CacheEntry) {
                ((CacheEntry)ce).updateExpirationInIndexFile(expiration);
            }
        }
        return updateAvail;
    }

    @Override
    public Resource getResource(URL location, String version, boolean download, int downloadTypes, DownloadDelegate dd) throws IOException {
        return this.getResource(location, version, download, downloadTypes, dd, false, null);
    }

    private Resource getFromMemory(URL url, String version) {
        Resource ce = null;
        Object o = MemoryCache.getLoadedResource(url.toString());
        if (o instanceof Resource) {
            ce = (Resource)o;
        }
        if (ce != null && CacheEntry.matchesVersionString(ce, version, true)) {
            return ce;
        }
        return null;
    }

    private Resource getResource(URL url, String version, boolean doDownload, int downloadTypes, DownloadDelegate dd, boolean isPlatformRequest, String platforms) throws IOException {
        boolean doUpdate;
        if (url == null) {
            return null;
        }
        Resource ce = null;
        if (this.sessionLoadedResourceStorage.isLoaded(url, version)) {
            ce = this.getFromMemory(url, version);
            if (ce == null && Cache.isCacheEnabled()) {
                ce = Cache.getCacheEntry(url, version, downloadTypes);
            }
            if (ce != null) {
                return ce;
            }
        }
        boolean bl = doUpdate = doDownload && this.isUpdateAvailable(url, version, downloadTypes, null);
        if (!doUpdate && (ce = this.getFromMemory(url, version)) != null) {
            return ce;
        }
        if (Cache.isCacheEnabled()) {
            ce = Cache.getCacheEntry(url, version, downloadTypes);
        } else {
            Object o = MemoryCache.getLoadedResource(url.toString());
            if (o instanceof Resource) {
                ce = (Resource)o;
            }
        }
        if (doDownload && (ce == null || this.isValidationRequired(ce))) {
            ce = DownloadEngine.downloadResource(ce, url, version, dd, isPlatformRequest, platforms, downloadTypes, true);
            this.sessionLoadedResourceStorage.addLoaded(url, version);
            if (ce != null) {
                Trace.println("Downloaded " + url + ": " + ce.getResourceFilename(), TraceLevel.NETWORK);
                MemoryCache.addLoadedResource(url.toString(), ce);
            }
            if (ce != null && Cache.isCacheEnabled()) {
                Cache.touch(new File(ce.getResourceFilename() + Cache.getIndexFileExtension()));
            }
        }
        return ce;
    }

    @Override
    public Resource downloadUpdate(URL location, String version, int downloadTypes, boolean markReady) throws IOException {
        return DownloadEngine.downloadResource(null, location, version, null, false, null, downloadTypes, markReady);
    }

    @Override
    public void markReady(Resource[] newDownloads) throws IOException {
        for (Resource newDownload : newDownloads) {
            if (!(newDownload instanceof CacheEntry)) continue;
            CacheEntry ce = (CacheEntry)newDownload;
            URL url = new URL(ce.getURL());
            CacheEntry old = Cache.getCacheEntry(url, ce.getVersion());
            Cache.processNewCacheEntry(url, true, ce, old);
        }
    }

    private boolean isValidationRequired(Resource resource) {
        if (!(resource instanceof CacheEntry)) {
            return true;
        }
        CacheEntry ce = (CacheEntry)resource;
        boolean revalidate = true;
        if (!ce.isExpired()) {
            Trace.println("Resource " + ce.getURL() + " has future expires: " + new Date(ce.getExpirationDate()) + " update check skipped.", TraceLevel.CACHE);
            revalidate = false;
        } else if (Trace.isEnabled(TraceLevel.CACHE)) {
            Trace.println("Resource " + ce.getURL() + " has expired.", TraceLevel.CACHE);
        }
        if (ce.isHttpNoCacheEnabled()) {
            revalidate = true;
            if (Trace.isEnabled(TraceLevel.CACHE)) {
                Trace.println("Resource " + ce.getURL() + " has cache control: no-cache.", TraceLevel.CACHE);
            }
        }
        return revalidate;
    }

    @Override
    public Resource getJreResource(URL location, String version, boolean download, boolean platformVersion, String knownPlatforms) throws IOException {
        return this.getResource(location, version, download, 1, null, platformVersion, knownPlatforms);
    }

    @Override
    public void markRetired(Resource resource, boolean immdediateCleanup) {
        if (!(resource instanceof CacheEntry)) {
            return;
        }
        CacheEntry ce = (CacheEntry)resource;
        if (immdediateCleanup) {
            Cache.removeCacheEntry(ce);
        } else {
            Cache.markResourceIncomplete(ce);
        }
    }

    @Override
    public File getShortcutImage(URL iconLocation, String version, boolean update) throws IOException {
        Resource ce = this.getResource(iconLocation, version, update, 1, null, false, null);
        if (ce instanceof CacheEntry) {
            ((CacheEntry)ce).generateShortcutImage();
            return ce.getDataFile();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getLibraryDirForJar(String libname, URL location, String version) throws IOException {
        int level = ResourceProvider.get().incrementInternalUse();
        try {
            File f;
            Resource r = this.getCachedResource(location, version);
            if (r == null) {
                r = this.getResource(location, version, true, 272, null);
            }
            File file = f = r != null ? r.getDataFile() : null;
            if (f != null) {
                String dir = f.getPath() + "-n";
                File ff = new File(dir, libname);
                Trace.println("Looking up native library in: " + ff, TraceLevel.CACHE);
                if (ff.exists()) {
                    String string = dir;
                    return string;
                }
            }
        }
        finally {
            ResourceProvider.get().decrementInternalUse(level);
        }
        return null;
    }

    @Override
    public Resource getSystemResource(URL location, String version) {
        return Cache.getSystemCacheEntry(location, version);
    }

    @Override
    public boolean isInternalUse() {
        return DownloadEngine.isInternalUse();
    }

    @Override
    public void decrementsInternalUse(int level) {
        DownloadEngine._decrementInternalUse(level);
    }

    @Override
    public LocalApplicationProperties getLocalApplicationProperties(URL location, String version, boolean isApplicationDesc) {
        return Cache.getLocalApplicationProperties(location, version, isApplicationDesc);
    }

    @Override
    public boolean canCache(URL resourceURL) {
        if (resourceURL == null) {
            return Cache.isCacheEnabled();
        }
        if (Cache.isCacheEnabled() && Cache.isSupportedProtocol(resourceURL)) {
            boolean inNoCacheList = HttpUtils.resourceNotCached(resourceURL.toString());
            return !inNoCacheList;
        }
        return false;
    }

    @Override
    public File getCacheDir() {
        return Cache.getCacheDir();
    }

    @Override
    public String getCurrentVersion(URL resourceURL) {
        return Cache.getCacheEntryVersion(resourceURL);
    }

    @Override
    public ResourceObject getResourceObject(String filePath) {
        String idxPath = filePath + ".idx";
        File idxFile = new File(idxPath);
        final CacheEntry ce = Cache.getCacheEntryFromFileIncludeTempJNLP(idxFile);
        if (ce == null) {
            return null;
        }
        if (!ce.isJNLPFile() && ce.getJarFile() instanceof ResourceObject) {
            return (ResourceObject)((Object)ce.getJarFile());
        }
        return new ResourceObject(){

            @Override
            public Object clone() throws CloneNotSupportedException {
                return super.clone();
            }

            @Override
            public URL getResourceURL() {
                try {
                    return new URL(ce.getURL());
                }
                catch (MalformedURLException e) {
                    Trace.ignored(e);
                    return null;
                }
            }

            @Override
            public String getResourceVersion() {
                return ce.getVersion();
            }

            @Override
            public void doClose() throws IOException {
                this.close();
            }

            @Override
            public void close() throws IOException {
            }
        };
    }

    @Override
    public DeployCacheJarAccess getJarAccess() {
        return DeployCacheJarAccessImpl.getJarAccess();
    }

    @Override
    public boolean hasEnhancedJarAccess() {
        return CacheEntry.hasEnhancedJarAccess();
    }

    @Override
    public String getCachedResourceFilePath(URL location, String version) throws IOException {
        return Cache.getCachedResourceFilePath(location, version);
    }

    private static class SessionLoadedResourceStorage
    implements SessionState.Client {
        private Set<Pair> storage = new HashSet<Pair>();
        private final String STORAGE_FILE_NAME = "sessionLoadedResourceStorage";

        public SessionLoadedResourceStorage() {
            SessionState.register(this);
        }

        @Override
        public synchronized void importState(File folder) {
            try {
                FileInputStream fis = new FileInputStream(new File(folder, "sessionLoadedResourceStorage"));
                ObjectInputStream ois = new ObjectInputStream(fis);
                this.storage = (Set)ois.readObject();
                ois.close();
                fis.close();
            }
            catch (Exception e) {
                Trace.ignored(e);
            }
        }

        @Override
        public synchronized void exportState(File folder) {
            try {
                FileOutputStream fos = new FileOutputStream(new File(folder, "sessionLoadedResourceStorage"));
                ObjectOutputStream oos = new ObjectOutputStream(fos);
                oos.writeObject(this.storage);
                oos.close();
                fos.close();
            }
            catch (IOException ioe) {
                Trace.ignored(ioe);
            }
        }

        public synchronized boolean isLoaded(URL jarLocation, String jarVersion) {
            return this.storage.contains(new Pair(jarLocation, jarVersion));
        }

        public synchronized void addLoaded(URL jarLocation, String jarVersion) {
            this.storage.add(new Pair(jarLocation, jarVersion));
        }

        private static class Pair
        implements Serializable {
            private static final long serialVersionUID = 3823723107031361215L;
            private String location;
            private String version;

            public String toString() {
                return "Pair{location=" + this.location + ", version=" + this.version + "}";
            }

            public Pair(URL jarLocation, String jarVersion) {
                this.location = jarLocation != null ? jarLocation.toString() : null;
                this.version = jarVersion;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Pair pair = (Pair)o;
                if (this.location != null ? !this.location.equals(pair.location) : pair.location != null) {
                    return false;
                }
                return !(this.version != null ? !this.version.equals(pair.version) : pair.version != null);
            }

            public int hashCode() {
                int result = this.location != null ? this.location.hashCode() : 0;
                result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
                return result;
            }
        }
    }
}

