/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net;

import com.sun.deploy.resources.ResourceManager;
import java.io.IOException;
import java.net.URL;

public class DownloadException
extends IOException {
    private static final long serialVersionUID = 4804531378919454640L;
    private URL _location;
    private String _version;
    private Exception _e;
    private String _message;

    public DownloadException(URL location, String version) {
        this(location, version, null);
    }

    protected DownloadException(URL location, String version, Exception e) {
        super(ResourceManager.getString("launch.error.category.download"));
        this._location = location;
        this._version = version;
        this._e = e;
    }

    public URL getLocation() {
        return this._location;
    }

    public String getVersion() {
        return this._version;
    }

    public String getResourceString() {
        String loc = this._location.toString();
        if (this._version == null) {
            return ResourceManager.getString("launch.error.resourceID", loc);
        }
        return ResourceManager.getString("launch.error.resourceID-version", loc, this._version);
    }

    public String getRealMessage() {
        return this._message;
    }

    @Override
    public String getMessage() {
        return this.getRealMessage();
    }

    public String getBriefMessage() {
        return null;
    }

    public Throwable getWrappedException() {
        return this._e;
    }

    @Override
    public void printStackTrace() {
        super.printStackTrace();
        if (this._e != null) {
            System.err.println("Caused by:");
            this._e.printStackTrace();
        }
    }
}

