/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net.proxy;

import com.sun.deploy.net.proxy.BrowserProxyConfig;
import com.sun.deploy.net.proxy.BrowserProxyInfo;
import com.sun.deploy.net.proxy.NSPreferences;
import com.sun.deploy.net.proxy.WebProxyAutoDetection;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.util.SystemPropertyUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public final class MFirefoxProxyConfig
implements BrowserProxyConfig {
    @Override
    public BrowserProxyInfo getBrowserProxyInfo() {
        String IS_RELATIVE = "isRelative=";
        String PATH = "Path=";
        Trace.msgNetPrintln("net.proxy.loading.ns");
        File preferences = null;
        BrowserProxyInfo info = new BrowserProxyInfo();
        info.setType(-1);
        try {
            String homeDir = System.getProperty("user.home");
            File profiles = new File(homeDir + "/.mozilla/firefox/profiles.ini");
            if (profiles.exists()) {
                String line;
                FileInputStream fis = new FileInputStream(profiles);
                InputStreamReader isr = new InputStreamReader((InputStream)fis, "ISO-8859-1");
                BufferedReader in = new BufferedReader(isr);
                boolean readingProfile0 = false;
                boolean isRelative = true;
                while ((line = in.readLine()) != null) {
                    if (line.trim().equals("[Profile0]")) {
                        readingProfile0 = true;
                        continue;
                    }
                    if (readingProfile0 && line.startsWith("isRelative=")) {
                        try {
                            int val = Integer.parseInt(line.substring("isRelative=".length()));
                            isRelative = val != 0;
                        }
                        catch (NumberFormatException e) {
                            isRelative = true;
                        }
                        continue;
                    }
                    if (!readingProfile0 || !line.startsWith("Path=")) continue;
                    preferences = isRelative ? new File(homeDir + "/.mozilla/firefox/" + line.substring("Path=".length()) + "/prefs.js") : new File(line.substring("Path=".length()) + "/prefs.js");
                    break;
                }
                in.close();
                if (preferences.exists()) {
                    NSPreferences.parseFile(preferences, info, 6.0f, false);
                    if (info.isAutoProxyDetectionEnabled()) {
                        info.setAutoConfigURL(WebProxyAutoDetection.getWPADURL());
                    }
                }
            }
        }
        catch (IOException e) {
            info.setType(-1);
        }
        catch (SecurityException e) {
            Trace.netPrintException(e);
            info.setType(-1);
        }
        if (SystemPropertyUtil.getProperty("javaplugin.version") != null) {
            info.setType(3);
        }
        Trace.msgNetPrintln("net.proxy.loading.done");
        return info;
    }

    @Override
    public void getSystemProxy(BrowserProxyInfo bpi) {
    }
}

