/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net.proxy;

import com.sun.deploy.Environment;
import com.sun.deploy.config.Platform;
import com.sun.deploy.net.proxy.BrowserProxyInfo;
import com.sun.deploy.net.proxy.ProxyConfigException;
import com.sun.deploy.net.proxy.ProxyHandler;
import com.sun.deploy.net.proxy.ProxyInfo;
import com.sun.deploy.net.proxy.ProxyUnavailableException;
import com.sun.deploy.trace.Trace;
import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import java.util.Properties;

public class MSystemProxyHandler
implements ProxyHandler {
    protected static boolean hasSystemProxies;

    @Override
    public final boolean isSupported(int proxyType) {
        return proxyType == 4;
    }

    @Override
    public final boolean isProxyCacheSupported() {
        return false;
    }

    @Override
    public final void init(BrowserProxyInfo info) throws ProxyConfigException {
        Trace.msgNetPrintln("net.proxy.loading.system");
        if (!this.isSupported(info.getType())) {
            throw new ProxyConfigException("Unable to support proxy type: " + info.getType());
        }
        Trace.msgNetPrintln("net.proxy.loading.done");
    }

    @Override
    public final ProxyInfo[] getProxyInfo(URL u) throws ProxyUnavailableException {
        ProxyInfo[] proxyInfoArray = new ProxyInfo[1];
        String proto = u.getProtocol();
        String host = u.getHost();
        String p = this.getSystemProxyFromEnv(proto);
        if (p == null) {
            p = this.getSystemProxyFromEtc(proto);
        }
        if (hasSystemProxies && p == null) {
            p = this.getSystemProxy(proto, host);
        }
        if (p == null) {
            return new ProxyInfo[]{new ProxyInfo(null)};
        }
        proxyInfoArray[0] = new ProxyInfo(p);
        return proxyInfoArray;
    }

    private String getSystemProxyFromEtc(String protocol) {
        String env_var = ProxyEnvVars.valueOf(protocol.toUpperCase(Locale.ENGLISH)).getEnvVar();
        final File file = new File("/etc/environment");
        Properties props = (Properties)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Properties props = new Properties();
                if (file.exists()) {
                    try {
                        props.load(new FileInputStream(file));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                return props;
            }
        });
        if (props.isEmpty()) {
            return null;
        }
        String proxy = (String)props.get(env_var);
        if (proxy == null) {
            proxy = (String)props.get(env_var.toUpperCase(Locale.ENGLISH));
        }
        return proxy != null ? proxy.replaceAll("^\"|\"$", "") : null;
    }

    private String getSystemProxyFromEnv(String protocol) {
        String env_var = ProxyEnvVars.valueOf(protocol.toUpperCase(Locale.ENGLISH)).getEnvVar();
        String proxy = Environment.getenv(env_var);
        if (proxy == null) {
            proxy = Environment.getenv(env_var.toUpperCase(Locale.ENGLISH));
        }
        return proxy;
    }

    protected static native boolean init();

    protected native String getSystemProxy(String var1, String var2);

    static {
        Platform.get().loadDeployNativeLib();
        hasSystemProxies = false;
        hasSystemProxies = MSystemProxyHandler.init();
    }

    private static enum ProxyEnvVars {
        HTTP("http_proxy"),
        HTTPS("https_proxy"),
        FTP("ftp_proxy"),
        GOPHER("gopher_proxy"),
        SOCKS("all_proxy");

        private final String env_var;

        private ProxyEnvVars(String env_var) {
            this.env_var = env_var;
        }

        String getEnvVar() {
            return this.env_var;
        }
    }
}

