/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net.proxy;

import com.sun.deploy.config.Platform;
import com.sun.deploy.trace.Trace;
import java.util.StringTokenizer;

public class WebProxyAutoDetection {
    private static final int MINIMUM_DOMAIN_LEVEL = 2;

    private static native String getFQHostName();

    private static int getDomainLevel(String domain) {
        int tokenCount = 0;
        if (domain != null) {
            StringTokenizer st = new StringTokenizer(domain, ".");
            tokenCount = st.countTokens();
        }
        return tokenCount;
    }

    public static String getWPADURL() {
        String url = null;
        String host = WebProxyAutoDetection.getFQHostName();
        Object domainName = "";
        if (host != null) {
            StringTokenizer st = new StringTokenizer(host, ".");
            st.nextToken();
            while (st.hasMoreTokens()) {
                domainName = (String)domainName + st.nextToken();
                if (!st.hasMoreTokens()) continue;
                domainName = (String)domainName + ".";
            }
            if (WebProxyAutoDetection.getDomainLevel((String)domainName) >= 2) {
                url = WebProxyAutoDetection.buildWPADURL((String)domainName);
            } else {
                Trace.msgNetPrintln("net.proxy.browser.pDetectionError", new Object[]{domainName});
            }
        }
        return url;
    }

    private static String buildWPADURL(String domain) {
        return "http://wpad." + domain + "/wpad.dat";
    }

    static {
        Platform.get().loadDeployNativeLib();
    }
}

