/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net.proxy.pac;

import com.sun.deploy.net.proxy.pac.PACFunctions;
import java.net.InetAddress;
import java.net.SocketPermission;
import java.net.UnknownHostException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.StringTokenizer;

public class PACFunctionsImpl
implements PACFunctions {
    private static final AccessControlContext ACC_SOCKET_INSTANCE;

    @Override
    public boolean dnsDomainIs(String host, String domain) {
        if (domain != null && domain.charAt(0) != '.') {
            return this.shExpMatch(host, domain);
        }
        return this.shExpMatch(host, "*" + domain);
    }

    @Override
    public boolean shExpMatch(String str, String shexp) {
        StringTokenizer tokenizer = new StringTokenizer(shexp, "*");
        int startIndex = 0;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            int temp = str.indexOf(token, startIndex);
            if (temp < 0) {
                return false;
            }
            startIndex = temp + token.length();
        }
        return startIndex >= str.length() || shexp.endsWith("*");
    }

    @Override
    public String myIpAddress() {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return PACFunctionsImpl.this.myIpAddressImpl();
            }
        });
    }

    private String myIpAddressImpl() {
        try {
            InetAddress address = InetAddress.getLocalHost();
            return address.getHostAddress();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return "127.0.0.1";
        }
    }

    @Override
    public String dnsResolve(final String host) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return PACFunctionsImpl.this.dnsResolveImpl(host);
            }
        }, ACC_SOCKET_INSTANCE);
    }

    private String dnsResolveImpl(String host) {
        String hostAddress = "";
        try {
            hostAddress = InetAddress.getByName(host).getHostAddress();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return hostAddress;
    }

    @Override
    public boolean isPlainHostName(String host) {
        return !host.contains(".");
    }

    @Override
    public boolean localHostOrDomainIs(String host, String domain) {
        return this.shExpMatch(domain, host + "*");
    }

    @Override
    public boolean isResolvable(String host) {
        return !"".equals(this.dnsResolve(host));
    }

    @Override
    public int dnsDomainLevels(String host) {
        int count = 0;
        for (int i = 0; i < host.length(); ++i) {
            if (host.charAt(i) != '.') continue;
            ++count;
        }
        return count;
    }

    static {
        Permissions perms = new Permissions();
        SocketPermission perm = new SocketPermission("*", "connect,resolve");
        ((PermissionCollection)perms).add(perm);
        ACC_SOCKET_INSTANCE = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, perms)});
    }
}

