/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.uitoolkit.ToolkitStore;
import java.security.CodeSource;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateRevokedException;

public class BlockedException
extends SecurityException {
    private static final long serialVersionUID = 3712667492700077030L;
    private final CodeSource codeSource;
    private AppInfo ai;
    private String message;
    private String masthead;
    private String mainText;
    private volatile boolean shown = false;

    public BlockedException(String message, Throwable cause) {
        this(null, null, message, cause, null, null);
    }

    public BlockedException(String message, Throwable cause, CodeSource codeSource, AppInfo ai) {
        this(null, null, message, cause, codeSource, ai);
    }

    public BlockedException(String message, Throwable cause, CodeSource codeSource, AppInfo ai, boolean preShown) {
        this(null, null, message, cause, codeSource, ai);
        this.shown = preShown;
    }

    public BlockedException(String masthead, String mainText, String message, Throwable cause, CodeSource codeSource, AppInfo ai) {
        super(message, cause);
        this.message = message;
        this.codeSource = codeSource;
        this.ai = ai != null ? new AppInfo(ai) : new AppInfo();
        this.masthead = masthead != null ? masthead : ResourceManager.getString("deployment.blocked.ruleset.masthead");
        this.mainText = mainText != null ? mainText : ResourceManager.getString("deployment.blocked.maintext");
    }

    public CodeSource getCodeSource() {
        return this.codeSource;
    }

    public AppInfo getAppInfo() {
        return this.ai;
    }

    public String getReason() {
        Throwable cause = this.getCause();
        String reason = null;
        if (cause instanceof CertificateRevokedException) {
            reason = this.getMessage("security.badcert.blocked.revoked.reason");
        } else if (cause instanceof CertificateExpiredException) {
            reason = this.getMessage("security.badcert.blocked.expired.reason");
        } else if (cause != null) {
            reason = cause.getLocalizedMessage();
        }
        if (reason == null || reason.isEmpty()) {
            reason = this.getLocalizedMessage();
        }
        return reason;
    }

    private String getMessage(String id) {
        return ResourceManager.getString(id);
    }

    public void showDialog() {
        if (!this.shown) {
            this.shown = true;
            String title = this.getMessage("deployment.blocked.title");
            String ok = this.getMessage("common.ok_btn");
            String detailButton = this.getMessage("common.detail.button");
            this.ai.setVendor(null);
            this.ai.setBlockedText(this.mainText);
            ToolkitStore.getUI().showBlockedDialog(null, this.ai, title, this.masthead, this.message, ok, detailButton, null);
        }
    }
}

