/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.cache.Cache;
import com.sun.deploy.config.Config;
import com.sun.deploy.model.DeployCacheJarAccess;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.DeployManifestChecker;
import com.sun.deploy.security.DeployURLClassLoader;
import com.sun.deploy.security.DeployURLClassPathCallback;
import com.sun.deploy.security.ruleset.DeploymentRuleSet;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.uitoolkit.ui.NativeMixedCodeDialog;
import com.sun.deploy.util.JarUtil;
import com.sun.deploy.util.SecurityBaseline;
import com.sun.deploy.util.URLUtil;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

public class CPCallbackHandler {
    public static final String ALLOWED_CODEBASES_KEY = "js.allowed.codebases";
    private Set<String> childURLs = Collections.synchronizedSet(new HashSet());
    private DeployURLClassPathCallback pcb;
    private DeployURLClassPathCallback ccb;
    private final HashMap<JarFile, CodeSource[]> assertJars = new HashMap();
    private final Map<String, CodeSource> resource2trust = new HashMap<String, CodeSource>();
    private final Map<String, CodeSource> package2trust = new HashMap<String, CodeSource>();
    private final Map<URL, CodeSource> defaultCS = new HashMap<URL, CodeSource>();
    private final Set<CodeSource> trustedCS = new HashSet<CodeSource>();
    private final Set<CodeSource> authenticatedCS = new HashSet<CodeSource>();
    private final Set<CodeSource> unauthenticatedCS = new HashSet<CodeSource>();
    private final Collection<String> js2JavaAllowedCodebasePatterns = new HashSet<String>();
    private final Map<Object, Integer> js2JavaCallerStates = new HashMap<Object, Integer>();
    private boolean callerAllowableCodebaseAttributeExists = false;
    static CodeSource untrustedCS = new CodeSource(null, (Certificate[])null);
    private static DeployCacheJarAccess jarAccess = ResourceProvider.get().getJarAccess();
    private DeployURLClassLoader parent;
    private DeployURLClassLoader child;

    public CPCallbackHandler(DeployURLClassLoader parent, DeployURLClassLoader child) {
        this.parent = parent;
        this.child = child;
        this.pcb = new ParentCallback();
        this.ccb = new ChildCallback();
    }

    public DeployURLClassPathCallback getParentCallback() {
        return this.pcb;
    }

    public DeployURLClassPathCallback getChildCallback() {
        return this.ccb;
    }

    public void checkUntrustedAccess(URL documentbase, DeploymentRuleSet drs) {
        if (this.pcb != null && this.pcb instanceof ParentCallback) {
            ((ParentCallback)this.pcb).checkJS2JavaAccess(documentbase, drs);
        }
    }

    private synchronized int getCallerState(URL resourceURL) {
        URL key = resourceURL;
        Integer cachedResult = this.js2JavaCallerStates.get(key);
        if (cachedResult != null) {
            return cachedResult;
        }
        int result = this.getCallerState(resourceURL, this.js2JavaAllowedCodebasePatterns, true);
        this.js2JavaCallerStates.put(key, result);
        return result;
    }

    private synchronized int getCallerState(URL resourceURL, Collection<String> patterns, boolean enforceHTTPS) {
        int result = 1;
        boolean hasStrictMatch = false;
        Iterator<String> it = patterns.iterator();
        while (it.hasNext() && (result = DeployManifestChecker.verifyCodebaseEx(resourceURL, it.next(), enforceHTTPS)) != 1) {
            if (result != 2) continue;
            hasStrictMatch = true;
        }
        if (result == 4 && hasStrictMatch) {
            result = 2;
        }
        return result;
    }

    public synchronized void addJS2JavaAllowedCodebasePattern(String codebasePatterns) {
        this.js2JavaAllowedCodebasePatterns.add(codebasePatterns);
        this.js2JavaCallerStates.clear();
    }

    public void setCallerAllowableCodebaseAttributeExists() {
        this.callerAllowableCodebaseAttributeExists = true;
    }

    public synchronized void addJS2JavaAllowedCodebase(URL url) {
        this.addJS2JavaAllowedCodebasePattern(this.getCodebasePatternFromURL(url));
    }

    protected String getCodebasePatternFromURL(URL url) {
        String codebase = url.getProtocol() + "://" + url.getHost();
        int port = url.getPort();
        if (port > -1) {
            codebase = codebase + ":" + port;
        }
        return codebase;
    }

    protected static synchronized boolean hasTrustedLibraryAssertion(JarFile jar) {
        try {
            Attributes attr;
            Manifest man = jar.getManifest();
            if (man != null && (attr = man.getMainAttributes()) != null) {
                String value = attr.getValue(new Attributes.Name("Trusted-Library"));
                boolean trusted = false;
                if (value != null) {
                    trusted = Boolean.valueOf(value.trim());
                }
                value = attr.getValue(new Attributes.Name("X-Trusted-Library"));
                boolean xtrusted = false;
                if (value != null) {
                    xtrusted = Boolean.valueOf(value.trim());
                }
                if (xtrusted) {
                    Trace.println("old X-Trusted-Library assertion in JAR", TraceLevel.SECURITY);
                }
                return trusted || xtrusted;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    protected static boolean hasTrustedOnlyAssertion(JarFile jar) {
        try {
            Attributes attr;
            Manifest man = jar.getManifest();
            if (man != null && (attr = man.getMainAttributes()) != null) {
                String value = attr.getValue(new Attributes.Name("Trusted-Only"));
                boolean trusted = false;
                if (value != null) {
                    trusted = Boolean.valueOf(value.trim());
                }
                value = attr.getValue(new Attributes.Name("X-Signed-Only"));
                boolean signed = false;
                if (value != null) {
                    signed = Boolean.valueOf(value.trim());
                }
                if (signed) {
                    Trace.println("old X-Signed-Only assertion in JAR", TraceLevel.SECURITY);
                }
                return trusted || signed;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private synchronized String assertTrust(JarFile jar, CodeSource[] trustedSources) {
        HashMap<String, CodeSource> packages = new HashMap<String, CodeSource>();
        HashMap<String, CodeSource> resources = new HashMap<String, CodeSource>();
        String ret = null;
        for (int j = 0; j < trustedSources.length; ++j) {
            Enumeration<String> trustedSigner = jarAccess.entryNames(jar, new CodeSource[]{trustedSources[j]});
            while (trustedSigner.hasMoreElements()) {
                String name = trustedSigner.nextElement();
                if (name.endsWith(".class")) {
                    name = name.replace('/', '.');
                    name = this.getPackage(name.substring(0, name.length() - 6));
                    packages.put(name, trustedSources[j]);
                    continue;
                }
                if (name.endsWith("/")) continue;
                resources.put(name, trustedSources[j]);
            }
        }
        Set p = packages.entrySet();
        Set r = resources.entrySet();
        Map.Entry[] pkgs = p.toArray(new Map.Entry[p.size()]);
        Map.Entry[] res = r.toArray(new Map.Entry[r.size()]);
        int i = this.setTrust(this.resource2trust, res);
        if (i != -1) {
            ret = "untrusted resource \"" + (String)res[i].getKey() + "\" in class path";
        }
        if ((i = this.setTrust(this.package2trust, pkgs)) != -1) {
            this.unwindTrust(this.resource2trust, res);
            ret = "untrusted class package \"" + (String)pkgs[i].getKey() + "\" in class path";
        }
        return ret;
    }

    private String getPackage(String name) {
        int i = name.lastIndexOf(46);
        return i == -1 ? "" : name.substring(0, i);
    }

    private int setTrust(Map<String, CodeSource> map, Map.Entry<String, CodeSource>[] entries) {
        int i;
        for (i = 0; i < entries.length; ++i) {
            CodeSource cs = this.setTrust(map, entries[i].getKey(), entries[i].getValue());
            if (cs == null) continue;
            CodeSource thatCS = entries[i].getValue();
            if (!this.compareCodeSources(cs, thatCS) && this.isTrusted(cs) != this.isTrusted(thatCS)) break;
            entries[i] = null;
        }
        if (i == entries.length) {
            return -1;
        }
        this.unwindTrust(map, entries, i);
        return i;
    }

    private CodeSource setTrust(Map<String, CodeSource> map, String name, CodeSource cs) {
        CodeSource thatCS = map.get(name);
        if (thatCS == null) {
            map.put(name, cs);
            return null;
        }
        return thatCS;
    }

    private void unwindTrust(Map<String, CodeSource> map, Map.Entry<String, CodeSource>[] entries, int i) {
        if (i == 0) {
            return;
        }
        --i;
        while (i >= 0) {
            if (entries[i] != null) {
                map.remove(entries[i].getKey());
            }
            --i;
        }
    }

    private void unwindTrust(Map<String, CodeSource> map, Map.Entry<String, CodeSource>[] entries) {
        this.unwindTrust(map, entries, entries.length);
    }

    private synchronized boolean checkPackage(String name, CodeSource cs, Boolean csTrusted) {
        CodeSource thatCS = this.setTrust(this.package2trust, name, cs);
        return thatCS == null || this.compareCodeSources(thatCS, cs) || this.isTrusted(thatCS) == csTrusted;
    }

    private synchronized boolean checkResource(String name, CodeSource cs, Boolean csTrusted) {
        CodeSource thatCS = this.setTrust(this.resource2trust, name, cs);
        return thatCS == null || this.compareCodeSources(thatCS, cs) || this.isTrusted(thatCS) == csTrusted;
    }

    private synchronized void mergeTrustedSources(CodeSource[] sources) {
        for (int i = 0; i < sources.length; ++i) {
            this.trustedCS.add(sources[i]);
        }
    }

    private synchronized Boolean isTrusted(CodeSource cs) {
        if (cs == untrustedCS) {
            return Boolean.FALSE;
        }
        return this.trustedCS.contains(cs);
    }

    private synchronized Boolean isAuthenticated(CodeSource cs) {
        if (cs == null || cs == untrustedCS) {
            return Boolean.FALSE;
        }
        boolean authenticated = this.authenticatedCS.contains(cs);
        if (authenticated) {
            return Boolean.TRUE;
        }
        if (!this.unauthenticatedCS.contains(cs)) {
            for (CodeSource source : this.trustedCS) {
                if (source == null) continue;
                CodeSource target = new CodeSource(cs.getLocation(), source.getCodeSigners());
                if (this.compareCodeSources(target, cs)) {
                    this.authenticatedCS.add(cs);
                    return Boolean.TRUE;
                }
                this.unauthenticatedCS.add(cs);
            }
        }
        return Boolean.FALSE;
    }

    private boolean compareCodeSources(CodeSource cs1, CodeSource cs2) {
        String locationStr2;
        if (cs1 == cs2) {
            return true;
        }
        URL location1 = cs1.getLocation();
        URL location2 = cs2.getLocation();
        String locationStr1 = location1 == null ? null : location1.toString();
        String string = locationStr2 = location2 == null ? null : location2.toString();
        if (locationStr1 == null ? locationStr2 != null : !locationStr1.equals(locationStr2)) {
            return false;
        }
        CodeSigner[] signers1 = cs1.getCodeSigners();
        CodeSigner[] signers2 = cs2.getCodeSigners();
        if (signers1 == null && signers2 == null) {
            return true;
        }
        if (signers1 == null) {
            signers1 = new CodeSigner[]{};
        }
        if (signers2 == null) {
            signers2 = new CodeSigner[]{};
        }
        if (signers1.length != signers2.length) {
            return false;
        }
        for (CodeSigner cS1 : signers1) {
            boolean match = false;
            for (CodeSigner cS2 : signers2) {
                if (!cS1.equals(cS2)) continue;
                match = true;
                break;
            }
            if (match) continue;
            return false;
        }
        return true;
    }

    private synchronized CodeSource getDefaultCodeSource(URL url) {
        if (!this.trustedCS.isEmpty()) {
            CodeSource cs = this.defaultCS.get(url);
            if (cs == null) {
                cs = new CodeSource(url, (Certificate[])null);
                this.defaultCS.put(url, cs);
            }
            return cs;
        }
        return untrustedCS;
    }

    private AppInfo getAppInfo() {
        AppInfo ai = this.parent.getAppInfo(null);
        return ai;
    }

    private CodeSource[] getAllPCodeSources(DeployURLClassLoader cl, CodeSource[] sources) {
        ArrayList<CodeSource> list = new ArrayList<CodeSource>();
        for (CodeSource cs : sources) {
            if (!cl.wantsAllPerms(cs)) continue;
            list.add(cs);
        }
        return list.toArray(new CodeSource[list.size()]);
    }

    private static int showDialog(boolean isJsDialog, AppInfo ai, boolean showAlways) {
        String showAlwaysText;
        String prefix;
        String appPublisherText = "";
        String appTitleText = Config.replaceTitleChars(ai.getTitle(), '-');
        if (isJsDialog) {
            appPublisherText = null;
            appTitleText = null;
            LocalApplicationProperties lap = ResourceProvider.get().getLocalApplicationProperties(ai.getLapURL(), null, true);
            if (lap != null) {
                appPublisherText = lap.getMainPublisher();
                appTitleText = Config.replaceTitleChars(lap.getMainTitle(), '-');
            } else if (Cache.isCacheEnabled()) {
                Trace.println("Unexpected error: LAP is null but cache is enabled", TraceLevel.LIVECONNECT);
            }
            if (appPublisherText == null) {
                appPublisherText = ResourceManager.getString("security.dialog.notverified.subject").toUpperCase();
            }
            if (appTitleText == null) {
                appTitleText = ResourceManager.getString("dialog.template.name.unknown").toUpperCase();
            }
        }
        if (NativeMixedCodeDialog.isSupported()) {
            prefix = "security.dialog.nativemixcode." + (isJsDialog ? "js." : "");
            String title = ResourceManager.getString(prefix + "title");
            String masthead = ResourceManager.getString(prefix + "masthead");
            String message = ResourceManager.getString(prefix + "message");
            String info = ResourceManager.getString(prefix + "info");
            String firstBtnStr = ResourceManager.getString(prefix + "firstBtnStr");
            String secondBlockBtnStr = ResourceManager.getString(prefix + "secondBtnStr");
            String helpBtnStr = ResourceManager.getString(prefix + "helpBtnStr");
            String closeBtnStr = ResourceManager.getString(prefix + "closeBtnStr");
            String helpTitle = ResourceManager.getString(prefix + "helpTitle");
            String helpMessage = ResourceManager.getString(prefix + "helpMessage");
            String appLabelStr = ResourceManager.getString(prefix + "appLabelStr");
            String appLabelWebsite = isJsDialog ? ResourceManager.getString(prefix + "appLabelWebsite") : "";
            String appLabelPublisher = isJsDialog ? ResourceManager.getString(prefix + "appLabelPublisher") : "";
            String appWebsiteText = isJsDialog ? ai.getDisplayFrom() : "";
            String showAlwaysText2 = isJsDialog && showAlways ? ResourceManager.getString(prefix + "showAlwaysText") : "";
            return NativeMixedCodeDialog.show(title, masthead, message, info, firstBtnStr, secondBlockBtnStr, helpBtnStr, closeBtnStr, helpTitle, helpMessage, appLabelStr, appTitleText, appLabelWebsite, appWebsiteText, appLabelPublisher, appPublisherText, showAlwaysText2);
        }
        prefix = "security.dialog.mixcode." + (isJsDialog ? "js." : "");
        String title = ResourceManager.getString(prefix + "title");
        String header = ResourceManager.getString(prefix + "header");
        String question = ResourceManager.getString(prefix + "question");
        String alert = ResourceManager.getString(prefix + "alert");
        String buttonYes = ResourceManager.getString(prefix + "buttonYes");
        String buttonNo = ResourceManager.getString(prefix + "buttonNo");
        String string = showAlwaysText = isJsDialog && showAlways ? ResourceManager.getString(prefix + "showAlwaysText") : null;
        if (isJsDialog) {
            ai.setVendor(appPublisherText);
            ai.setTitle(appTitleText);
        }
        return ToolkitStore.getUI().showMessageDialog(null, ai, 4, title, header, question, alert, buttonYes, buttonNo, null, showAlwaysText);
    }

    private class ChildElement
    extends DeployURLClassPathCallback.Element {
        boolean skip;
        Boolean trusted;
        Boolean authenticated;
        CodeSource cs;

        ChildElement(JarFile jar, URL url) {
            CodeSource[] sources;
            super(jar, url);
            this.cs = jar != null ? ((sources = jarAccess.getCodeSources(jar, url)) != null && sources.length > 0 ? sources[0] : null) : CPCallbackHandler.this.getDefaultCodeSource(url);
            this.trusted = CPCallbackHandler.this.isTrusted(this.cs);
            this.authenticated = this.trusted == false && this.cs.getCertificates() != null ? CPCallbackHandler.this.isAuthenticated(this.cs) : Boolean.FALSE;
        }

        @Override
        public void checkResource(String name) {
            Boolean checkTrusted;
            Boolean entryAuthenticated;
            Boolean entryTrusted;
            CodeSource entryCS;
            String pkg = null;
            if (name == null) {
                return;
            }
            if (this.jar != null) {
                ZipEntry ze = this.jar.getEntry(name);
                if (ze != null && JarUtil.isDirectory(ze)) {
                    return;
                }
                entryCS = jarAccess.getCodeSource(this.jar, this.url, name);
                entryTrusted = entryCS == this.cs ? this.trusted : CPCallbackHandler.this.isTrusted(entryCS);
                Boolean bl = entryAuthenticated = this.authenticated != false ? this.authenticated : CPCallbackHandler.this.isAuthenticated(entryCS);
                checkTrusted = !entryTrusted.booleanValue() && this.trusted.booleanValue() && JarUtil.isSigningRelated(name) ? Boolean.TRUE : entryTrusted;
            } else {
                if (name.endsWith("/")) {
                    return;
                }
                entryCS = this.cs;
                checkTrusted = entryTrusted = this.trusted;
                entryAuthenticated = this.authenticated;
            }
            ((ParentCallback)CPCallbackHandler.this.pcb).check(this.url, checkTrusted, entryAuthenticated);
            if (name.endsWith(".class")) {
                pkg = name.replace('/', '.');
                pkg = CPCallbackHandler.this.getPackage(pkg.substring(0, pkg.length() - 6));
            }
            if (pkg != null) {
                if (!CPCallbackHandler.this.checkPackage(pkg, entryCS, entryTrusted)) {
                    String clsName = name.replace('/', '.').substring(0, name.length() - 6);
                    String msg = "class \"" + clsName + "\" does not match trust level of other classes in the same package";
                    throw new SecurityException(msg);
                }
            } else if (!CPCallbackHandler.this.checkResource(name, entryCS, entryTrusted)) {
                String msg = "resource \"" + name + "\" does not match trust level of other resources of the same name";
                throw new SecurityException(msg);
            }
        }

        void skip(boolean skip) {
            this.skip = skip;
        }

        @Override
        public boolean skip() {
            return this.skip;
        }
    }

    private class ChildCallback
    extends DeployURLClassPathCallback {
        private ChildCallback() {
        }

        @Override
        public DeployURLClassPathCallback.Element openClassPathElement(JarFile jar, URL url) throws IOException {
            ChildElement ce = new ChildElement(jar, url);
            if (CPCallbackHandler.this.childURLs.contains(url.toString())) {
                if (jar != null) {
                    jarAccess.setEagerValidation(jar, true);
                }
                return ce;
            }
            ce.skip(true);
            return ce;
        }

        @Override
        public DeployURLClassPathCallback.Element openClassPathElement(URL url) throws IOException {
            return this.openClassPathElement(null, url);
        }
    }

    private class ParentElement
    extends DeployURLClassPathCallback.Element {
        String pendingException;
        boolean defer;

        ParentElement(JarFile jar, URL url) {
            super(jar, url);
        }

        @Override
        public void checkResource(String name) {
            if (this.pendingException != null) {
                throw new SecurityException(this.pendingException);
            }
            if (this.jar == null) {
                throw new SecurityException("invalid class path element " + this.url + " on Trusted-Library loader");
            }
        }

        void setPendingException(String msg) {
            this.pendingException = msg;
        }

        void defer(boolean defer) {
            this.defer = defer;
        }

        @Override
        public boolean defer() {
            return this.defer;
        }

        public String toString() {
            return "defer: " + this.defer + ", pending: " + this.pendingException;
        }
    }

    private class ParentCallback
    extends DeployURLClassPathCallback {
        private static final String LAP_CODEBASE_SEPARATOR = "\t";
        private boolean trustedChild;
        private boolean authenticatedChild;
        private boolean untrustedChild;
        private boolean trustedOnly;
        private boolean allowMixedTrust;
        private boolean checkMixedTrust;
        private boolean allowMixedTrustForJS;

        private ParentCallback() {
            if (Config.getMixcodeValue() == 0) {
                this.checkMixedTrust = true;
            }
            if (!(this.checkMixedTrust || Config.getMixcodeValue() != 1 && Config.getMixcodeValue() != 3)) {
                this.allowMixedTrust = true;
            }
        }

        private void checkJS2JavaAccess(URL callerURL, final DeploymentRuleSet drs) {
            if (this.allowMixedTrustForJS) {
                return;
            }
            int codebaseCheckStatus = CPCallbackHandler.this.getCallerState(callerURL);
            switch (codebaseCheckStatus) {
                case 2: {
                    break;
                }
                case 4: {
                    if (this.checkJSAllowed(callerURL, true)) break;
                    this.throwJSSecurityException(callerURL);
                    break;
                }
                case 1: {
                    if (!CPCallbackHandler.this.callerAllowableCodebaseAttributeExists) {
                        if (drs.isLiveConnectAllowedUnchecked()) {
                            return;
                        }
                        Boolean securityCheck = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                            @Override
                            public Boolean run() {
                                return drs.isRunUntrustedNever() || SecurityBaseline.isExpired() && drs.isSSVModeNever();
                            }
                        });
                        if (securityCheck.booleanValue()) {
                            String msg = "LiveConnect (JavaScript) blocked due to security settings.";
                            this.throwJSSecurityException(callerURL, msg);
                        }
                        if (this.checkJSAllowed(callerURL, false)) break;
                        this.throwJSSecurityException(callerURL);
                        break;
                    }
                    this.throwJSSecurityException(callerURL);
                    break;
                }
                default: {
                    this.throwJSSecurityException(callerURL);
                }
            }
        }

        private void throwJSSecurityException(URL url) {
            String msg = "JavaScript from " + url + " attempted to access a resource it has no rights to.";
            this.throwJSSecurityException(url, msg);
        }

        private void throwJSSecurityException(URL url, String msg) {
            Trace.println("Security Exception: " + msg, TraceLevel.LIVECONNECT);
            throw new SecurityException(msg);
        }

        @Override
        public synchronized DeployURLClassPathCallback.Element openClassPathElement(JarFile jar, URL url) throws IOException {
            jarAccess.setEagerValidation(jar, true);
            return this.strategy(jar, url, jarAccess.getCodeSources(jar, url));
        }

        @Override
        public synchronized DeployURLClassPathCallback.Element openClassPathElement(URL url) throws IOException {
            return this.strategy(null, url, new CodeSource[]{new CodeSource(url, (Certificate[])null)});
        }

        private DeployURLClassPathCallback.Element strategy(JarFile jar, URL url, CodeSource[] sources) {
            String msg;
            CodeSource[] trustedSources;
            boolean hasTrustedContent = false;
            boolean hasOnlyTrustedContent = false;
            boolean maybeTrustedOnly = this.trustedOnly;
            boolean maybeTrustedChild = this.trustedChild;
            boolean assertsTrustedLibrary = false;
            boolean assertsTrustedOnly = false;
            ParentElement pe = new ParentElement(jar, url);
            if (jar != null) {
                assertsTrustedLibrary = CPCallbackHandler.hasTrustedLibraryAssertion(jar);
                assertsTrustedOnly = CPCallbackHandler.hasTrustedOnlyAssertion(jar);
            }
            if (assertsTrustedOnly) {
                Trace.println(url + " is asserting Trusted-Only", TraceLevel.SECURITY);
                if (this.authenticatedChild || this.untrustedChild) {
                    pe.setPendingException("attempted to open Trusted-Only jar " + url + " on sandboxed loader");
                    return pe;
                }
            }
            if ((trustedSources = CPCallbackHandler.this.getAllPCodeSources(CPCallbackHandler.this.parent, sources)) != null && trustedSources.length > 0) {
                hasTrustedContent = true;
                if (trustedSources.length == sources.length) {
                    hasOnlyTrustedContent = true;
                } else {
                    boolean nonMetaUnsigned = false;
                    for (int i = sources.length - 1; i >= 0; --i) {
                        if (sources[i].getCertificates() != null) continue;
                        CodeSource[] unsigned = new CodeSource[]{sources[i]};
                        if (!jarAccess.entryNames(jar, unsigned).hasMoreElements()) continue;
                        nonMetaUnsigned = true;
                        break;
                    }
                    hasOnlyTrustedContent = !nonMetaUnsigned;
                }
                CPCallbackHandler.this.mergeTrustedSources(trustedSources);
            }
            if (hasOnlyTrustedContent) {
                if (assertsTrustedLibrary) {
                    if (this.authenticatedChild || this.untrustedChild) {
                        pe.setPendingException(CPCallbackHandler.this.assertTrust(jar, trustedSources));
                        return pe;
                    }
                    CPCallbackHandler.this.assertJars.put(jar, trustedSources);
                    return pe;
                }
                if (assertsTrustedOnly && !this.trustedOnly) {
                    Trace.println(url + " is newly asserting Trusted-Only", TraceLevel.SECURITY);
                    maybeTrustedOnly = true;
                }
            } else {
                if (assertsTrustedOnly) {
                    pe.setPendingException("attempted to open sandboxed jar " + url + " as Trusted-Only");
                    return pe;
                }
                if (assertsTrustedLibrary) {
                    pe.setPendingException("attempted to open sandboxed jar " + url + " as a Trusted-Library");
                    return pe;
                }
            }
            if (hasTrustedContent && jar != null) {
                maybeTrustedChild = true;
            }
            if (maybeTrustedChild && this.untrustedChild && (msg = this.checkAllowed(url, maybeTrustedChild && this.trustedChild)) != null) {
                pe.setPendingException(msg);
                return pe;
            }
            if (this.authenticatedChild || this.untrustedChild) {
                if (!CPCallbackHandler.this.assertJars.isEmpty()) {
                    for (Map.Entry entry : CPCallbackHandler.this.assertJars.entrySet()) {
                        CPCallbackHandler.this.assertTrust((JarFile)entry.getKey(), (CodeSource[])entry.getValue());
                    }
                    CPCallbackHandler.this.assertJars.clear();
                }
                if (jar != null && hasTrustedContent && (msg = CPCallbackHandler.this.assertTrust(jar, trustedSources)) != null) {
                    pe.setPendingException(msg);
                    return pe;
                }
            } else if (jar != null && hasTrustedContent) {
                CPCallbackHandler.this.assertJars.put(jar, trustedSources);
            }
            CPCallbackHandler.this.childURLs.add(url.toString());
            this.trustedOnly = maybeTrustedOnly;
            this.trustedChild = maybeTrustedChild;
            pe.defer(true);
            return pe;
        }

        private synchronized void check(URL url, boolean trusted, boolean authenticated) {
            String msg;
            boolean maybeTrustedChild = this.trustedChild;
            boolean maybeUntrustedChild = this.untrustedChild;
            boolean maybeAuthenticatedChild = this.authenticatedChild;
            if (!trusted && this.trustedOnly) {
                throw new SecurityException("Trusted-Only loader attempted to load sandboxed resource from " + url);
            }
            if (trusted) {
                maybeTrustedChild = true;
            } else if (authenticated) {
                maybeAuthenticatedChild = true;
            } else {
                maybeUntrustedChild = true;
            }
            if (maybeTrustedChild && maybeUntrustedChild && (msg = this.checkAllowed(url, maybeTrustedChild && this.trustedChild)) != null) {
                throw new SecurityException(msg);
            }
            if ((maybeAuthenticatedChild || maybeUntrustedChild) && !CPCallbackHandler.this.assertJars.isEmpty()) {
                for (Map.Entry entry : CPCallbackHandler.this.assertJars.entrySet()) {
                    CPCallbackHandler.this.assertTrust((JarFile)entry.getKey(), (CodeSource[])entry.getValue());
                }
                CPCallbackHandler.this.assertJars.clear();
            }
            this.trustedChild = maybeTrustedChild;
            this.authenticatedChild = maybeAuthenticatedChild;
            this.untrustedChild = maybeUntrustedChild;
        }

        private String checkAllowed(URL url, boolean wasTrusted) {
            if (url != null && CPCallbackHandler.this.parent.getDeploymentRuleSet(url).isRuleRun()) {
                this.allowMixedTrust = true;
            } else if (this.checkMixedTrust) {
                int result = CPCallbackHandler.showDialog(false, CPCallbackHandler.this.getAppInfo(), false);
                if (result == 1) {
                    this.allowMixedTrust = true;
                }
                this.checkMixedTrust = false;
            }
            if (!this.allowMixedTrust) {
                if (wasTrusted) {
                    return "trusted loader attempted to load sandboxed resource" + (String)(url != null ? " from " + url : "");
                }
                return "sandboxed loader attempted to load trusted resource" + (String)(url != null ? " from " + url : "");
            }
            return null;
        }

        private boolean checkJSAllowed(URL url, boolean isMatchedByWildcard) {
            if (url != null && CPCallbackHandler.this.parent.getDeploymentRuleSet(url).isRuleRun()) {
                this.allowMixedTrustForJS = true;
            } else {
                String allowedCodebases;
                AppInfo ai = CPCallbackHandler.this.getAppInfo();
                String location = URLUtil.urlToLocation(url);
                LocalApplicationProperties lap = ResourceProvider.get().getLocalApplicationProperties(ai.getLapURL(), null, true);
                if (isMatchedByWildcard && lap != null && location != null && (allowedCodebases = lap.get(CPCallbackHandler.ALLOWED_CODEBASES_KEY)) != null) {
                    String[] allowedCodebase;
                    for (String allowedCodebase1 : allowedCodebase = allowedCodebases.split(LAP_CODEBASE_SEPARATOR)) {
                        if (!location.equals(allowedCodebase1)) continue;
                        this.allowMixedTrustForJS = true;
                        break;
                    }
                }
                if (!this.allowMixedTrustForJS) {
                    int result;
                    if (url != null) {
                        ai.setFrom(url);
                    }
                    if ((result = CPCallbackHandler.showDialog(true, ai, isMatchedByWildcard)) == 0 || result == 2) {
                        this.allowMixedTrustForJS = true;
                        if (result == 2 && isMatchedByWildcard && lap != null && location != null) {
                            Object allowedCodebases2 = lap.get(CPCallbackHandler.ALLOWED_CODEBASES_KEY);
                            allowedCodebases2 = allowedCodebases2 == null ? location : (String)allowedCodebases2 + LAP_CODEBASE_SEPARATOR + location;
                            lap.put(CPCallbackHandler.ALLOWED_CODEBASES_KEY, (String)allowedCodebases2);
                            try {
                                lap.store();
                            }
                            catch (IOException e) {
                                Trace.ignored(e);
                            }
                        }
                    }
                }
            }
            return this.allowMixedTrustForJS;
        }
    }
}

