/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.security.CertStore;
import com.sun.deploy.security.CertUtils;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

final class LazyRootStore {
    private CertStore browserRootStore = null;
    private CertStore jreRootStore = null;
    private boolean isBrowserRootStoreLoaded = false;
    private boolean isJRERootStoreLoaded = false;
    private X509Certificate ocspCertCA = null;
    private Set<X509Certificate> allRootCerts = new LinkedHashSet<X509Certificate>();
    private Set<X509Certificate> jreRootCerts = new LinkedHashSet<X509Certificate>();
    private Map<X500Principal, List<X509Certificate>> allTrustedSubjects = new HashMap<X500Principal, List<X509Certificate>>();
    private Map<X500Principal, List<PublicKey>> allTrustedSubjectKeys = new HashMap<X500Principal, List<PublicKey>>();

    LazyRootStore(CertStore browserRootStore, CertStore jreRootStore) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        this.browserRootStore = browserRootStore;
        this.jreRootStore = jreRootStore;
    }

    private void loadBrowserStore() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        if (this.browserRootStore != null && !this.isBrowserRootStoreLoaded) {
            this.browserRootStore.load();
            this.isBrowserRootStoreLoaded = true;
            this.allRootCerts.addAll(this.browserRootStore.getCertificates());
        }
        this.createAllTrustedSubjects(this.allRootCerts);
    }

    private void loadJREStores() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        if (this.isJRERootStoreLoaded) {
            return;
        }
        this.jreRootStore.load();
        this.jreRootCerts.addAll(this.jreRootStore.getCertificates());
        this.allRootCerts.addAll(this.jreRootStore.getCertificates());
        this.createAllTrustedSubjects(this.jreRootCerts);
        this.isJRERootStoreLoaded = true;
    }

    TrustedRootResult getTrustAnchors(X509Certificate cert) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        TrustedRootResult result;
        if (!this.isBrowserRootStoreLoaded) {
            this.loadBrowserStore();
        }
        if ((result = this.getMatchedResult(cert)) == null && !this.isJRERootStoreLoaded) {
            this.loadJREStores();
            result = this.getMatchedResult(cert);
        }
        return result;
    }

    private TrustedRootResult getMatchedResult(X509Certificate cert) {
        X500Principal issuer = cert.getIssuerX500Principal();
        X500Principal dn = cert.getSubjectX500Principal();
        boolean isAlreadyTrusted = false;
        List<X509Certificate> matchedCAList = null;
        if (this.allRootCerts.contains(cert) || this.allTrustedSubjectKeys.containsKey(dn) && this.allTrustedSubjectKeys.get(dn).contains(cert.getPublicKey())) {
            matchedCAList = new LinkedList<X509Certificate>();
            matchedCAList.add(cert);
            isAlreadyTrusted = true;
        } else if (this.allTrustedSubjects.containsKey(issuer)) {
            matchedCAList = this.verifySignature(this.allTrustedSubjects.get(issuer), cert);
        }
        return matchedCAList == null || matchedCAList.isEmpty() ? null : new TrustedRootResult(matchedCAList, isAlreadyTrusted);
    }

    private void createAllTrustedSubjects(Set<X509Certificate> allRootCerts) {
        for (X509Certificate cert : allRootCerts) {
            List<Object> publicKeys;
            List<Object> certArrList;
            X500Principal certSubject = cert.getSubjectX500Principal();
            if (this.allTrustedSubjects.containsKey(certSubject)) {
                certArrList = this.allTrustedSubjects.get(certSubject);
            } else {
                certArrList = new LinkedList();
                this.allTrustedSubjects.put(certSubject, certArrList);
            }
            certArrList.add(cert);
            if (this.allTrustedSubjectKeys.containsKey(certSubject)) {
                publicKeys = this.allTrustedSubjectKeys.get(certSubject);
            } else {
                publicKeys = new LinkedList();
                this.allTrustedSubjectKeys.put(certSubject, publicKeys);
            }
            publicKeys.add(cert.getPublicKey());
        }
    }

    boolean containSubject(String ocspSigner) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        String ocspCertName;
        if (!this.isBrowserRootStoreLoaded) {
            this.loadBrowserStore();
        }
        for (X509Certificate cert : this.allRootCerts) {
            ocspCertName = CertUtils.extractSubjectAliasName(cert);
            if (!ocspSigner.equals(ocspCertName)) continue;
            this.ocspCertCA = cert;
            return true;
        }
        if (!this.isJRERootStoreLoaded) {
            this.loadJREStores();
            for (X509Certificate cert : this.jreRootCerts) {
                ocspCertName = CertUtils.extractSubjectAliasName(cert);
                if (!ocspSigner.equals(ocspCertName)) continue;
                this.ocspCertCA = cert;
                return true;
            }
        }
        this.ocspCertCA = null;
        return false;
    }

    X509Certificate getOCSPCert() {
        return this.ocspCertCA;
    }

    private List<X509Certificate> verifySignature(List<X509Certificate> certs, X509Certificate sub) {
        LinkedList<X509Certificate> matchedKeys = new LinkedList<X509Certificate>();
        for (X509Certificate cert : certs) {
            try {
                PublicKey key = cert.getPublicKey();
                sub.verify(key);
                matchedKeys.add(cert);
            }
            catch (Exception exception) {}
        }
        return matchedKeys;
    }

    static class TrustedRootResult {
        private List<X509Certificate> matchedCAList;
        private boolean isAlreadyTrusted;

        TrustedRootResult(List<X509Certificate> matchedCAList, boolean isAlreadyTrusted) {
            this.matchedCAList = matchedCAList;
            this.isAlreadyTrusted = isAlreadyTrusted;
        }

        List<X509Certificate> getMatchedCAList() {
            return this.matchedCAList;
        }

        boolean isAlreadyTrusted() {
            return this.isAlreadyTrusted;
        }
    }
}

