/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.security.MozillaJSSDSAPrivateKey;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public abstract class MozillaJSSDSASignature
extends SignatureSpi {
    private MozillaJSSDSAPrivateKey privateKey = null;

    protected abstract void update(byte[] var1, int var2, int var3);

    protected abstract byte[] getDigest() throws SignatureException;

    protected abstract void resetDigest();

    private Object getJSSSignature(Object cryptoToken) throws ClassNotFoundException, NoSuchMethodException, NoSuchFieldException, IllegalAccessException, InvocationTargetException {
        Class<?> jssCryptoToken = Class.forName("org.mozilla.jss.crypto.CryptoToken", true, ClassLoader.getSystemClassLoader());
        Class<?> jssSigAlgo = Class.forName("org.mozilla.jss.crypto.SignatureAlgorithm", true, ClassLoader.getSystemClassLoader());
        Class[] paramTypes = new Class[]{jssSigAlgo};
        Method getSigContextMethod = jssCryptoToken.getMethod("getSignatureContext", paramTypes);
        Field dsaSigField = jssSigAlgo.getField("DSASignature");
        Object[] arglist = new Object[]{dsaSigField.get(null)};
        return getSigContextMethod.invoke(cryptoToken, arglist);
    }

    @Override
    protected void engineInitVerify(PublicKey key) throws InvalidKeyException {
        throw new InvalidKeyException("Key not supported");
    }

    @Override
    protected void engineInitSign(PrivateKey key) throws InvalidKeyException {
        if (!(key instanceof MozillaJSSDSAPrivateKey)) {
            throw new InvalidKeyException("Key not supported");
        }
        this.privateKey = (MozillaJSSDSAPrivateKey)key;
    }

    @Override
    protected void engineUpdate(byte b) throws SignatureException {
        byte[] buf = new byte[]{b};
        this.update(buf, 0, 1);
    }

    @Override
    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        this.update(b, off, len);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        try {
            byte[] hash = this.getDigest();
            Object pk = this.privateKey.getJSSPrivateKey();
            Class<?> jssprivkey = Class.forName("org.mozilla.jss.crypto.PrivateKey", true, ClassLoader.getSystemClassLoader());
            Method getOwnTokenMeth = jssprivkey.getMethod("getOwningToken", new Class[0]);
            Object token = getOwnTokenMeth.invoke(pk, (Object[])null);
            Object sig = this.getJSSSignature(token);
            Class<?> jssSignature = Class.forName("org.mozilla.jss.crypto.Signature", true, ClassLoader.getSystemClassLoader());
            Class[] partypes2 = new Class[]{jssprivkey};
            Method initSignMeth = jssSignature.getMethod("initSign", partypes2);
            Object[] arglist2 = new Object[]{pk};
            Object siginit = initSignMeth.invoke(sig, arglist2);
            Class[] partypes3 = new Class[]{byte[].class};
            Method updateMeth = jssSignature.getMethod("update", partypes3);
            Object[] arglist3 = new Object[]{hash};
            Object sigupdate = updateMeth.invoke(sig, arglist3);
            Method signMeth = jssSignature.getMethod("sign", new Class[0]);
            byte[] dssSignature = (byte[])signMeth.invoke(sig, (Object[])null);
            byte[] rByteArray = new byte[20];
            byte[] sByteArray = new byte[20];
            System.arraycopy(dssSignature, 0, rByteArray, 0, 20);
            System.arraycopy(dssSignature, 20, sByteArray, 0, 20);
            BigInteger r = new BigInteger(rByteArray);
            BigInteger s = new BigInteger(sByteArray);
            DerOutputStream outseq = new DerOutputStream(100);
            outseq.putInteger(r);
            outseq.putInteger(s);
            DerValue result = new DerValue(48, outseq.toByteArray());
            byte[] byArray = result.toByteArray();
            return byArray;
        }
        catch (SignatureException se) {
            throw se;
        }
        catch (Throwable e) {
            SignatureException se = new SignatureException("Error generating signature.");
            se.initCause(e);
            throw se;
        }
        finally {
            this.resetDigest();
        }
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        throw new SignatureException("Signature verification not supported");
    }

    @Override
    @Deprecated
    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
        throw new InvalidParameterException("Parameter not supported");
    }

    @Override
    @Deprecated
    protected Object engineGetParameter(String param) throws InvalidParameterException {
        throw new InvalidParameterException("Parameter not supported");
    }

    public static class NONEwithDSA
    extends MozillaJSSDSASignature {
        private static final int SHA1_LEN = 20;
        private final byte[] digestBuffer = new byte[20];
        private int offset;

        @Override
        protected void update(byte[] data, int off, int len) {
            if (len == 0 || data == null) {
                return;
            }
            if (this.offset + len > 20) {
                this.offset = 21;
                return;
            }
            System.arraycopy(data, off, this.digestBuffer, this.offset, len);
            this.offset += len;
        }

        @Override
        protected byte[] getDigest() throws SignatureException {
            if (this.offset != 20) {
                throw new SignatureException("Data for RawDSA must be exactly 20 bytes long");
            }
            this.offset = 0;
            return this.digestBuffer;
        }

        @Override
        protected void resetDigest() {
            this.offset = 0;
        }
    }

    public static class SHA1withDSA
    extends MozillaJSSDSASignature {
        private final MessageDigest dataSHA = MessageDigest.getInstance("SHA-1");

        public SHA1withDSA() throws NoSuchAlgorithmException {
            this.dataSHA.reset();
        }

        @Override
        protected void update(byte[] data, int off, int len) {
            if (len == 0 || data == null) {
                return;
            }
            this.dataSHA.update(data, off, len);
        }

        @Override
        protected byte[] getDigest() {
            return this.dataSHA.digest();
        }

        @Override
        protected void resetDigest() {
            this.dataSHA.reset();
        }
    }
}

