/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.security.BasicPermissionCollection;
import java.net.URI;
import java.net.URL;
import java.security.BasicPermission;
import java.security.PermissionCollection;

public final class SecureCookiePermission
extends BasicPermission {
    private static final long serialVersionUID = 1769533200015971019L;
    static String ORIGIN_PREFIX = "origin.";

    public SecureCookiePermission(String name) {
        super(name);
    }

    public SecureCookiePermission(URI uri) {
        super(SecureCookiePermission.getURIOriginString(uri));
    }

    public SecureCookiePermission(String name, String actions) {
        super(name, actions);
    }

    public static String getURIOriginString(URI uri) {
        if (uri == null) {
            return null;
        }
        StringBuffer netPerm = new StringBuffer(ORIGIN_PREFIX);
        netPerm.append(uri.getScheme());
        netPerm.append("://");
        netPerm.append(uri.getHost());
        netPerm.append(":");
        int port = uri.getPort();
        if (port == -1) {
            try {
                port = uri.toURL().getDefaultPort();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        netPerm.append(port);
        return netPerm.toString();
    }

    public static String getURLOriginString(URL url) {
        if (url == null) {
            return null;
        }
        StringBuffer netPerm = new StringBuffer(ORIGIN_PREFIX);
        netPerm.append(url.getProtocol());
        netPerm.append("://");
        netPerm.append(url.getHost());
        netPerm.append(":");
        int port = url.getPort();
        if (port == -1) {
            port = url.getDefaultPort();
        }
        netPerm.append(port);
        return netPerm.toString();
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new BasicPermissionCollection();
    }
}

