/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.config.Platform;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.CertUtils;
import com.sun.deploy.security.DeployManifestChecker;
import com.sun.deploy.security.URLClassPathControl;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.uitoolkit.ToolkitStore;
import java.net.URL;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;

class TrustDeciderDialog {
    private static final String RISK_MESSAGE = TrustDeciderDialog.getString("security.dialog.unverified.signed.sub.new");
    private static final String MORE_CANCEL_MESSAGE = TrustDeciderDialog.getString("sandbox.security.info.cancel");
    private static final String MORE_RUN_MESSAGE = TrustDeciderDialog.getString("security.dialog.signed.moreinfo.generic");
    private static final String MORE_TRUSTED_MESSAGE = TrustDeciderDialog.getString("sandbox.security.info.trusted");

    TrustDeciderDialog() {
    }

    public static int showDialog(Certificate[] certs, URL url, int start, int end, boolean rootCANotValid, int validityState, Date timeStampDate, AppInfo ainfo, boolean httpsDialog) throws CertificateException {
        return TrustDeciderDialog.showDialog(certs, url, start, end, rootCANotValid, validityState, timeStampDate, ainfo, httpsDialog, null, false);
    }

    public static int showDialog(Certificate[] certs, URL url, int start, int end, boolean rootCANotValid, int validityState, Date timeStampDate, AppInfo ainfo, boolean httpsDialog, String hostname) throws CertificateException {
        return TrustDeciderDialog.showDialog(certs, url, start, end, rootCANotValid, validityState, timeStampDate, ainfo, httpsDialog, hostname, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int showDialog(Certificate[] certs, URL url, int start, int end, boolean rootCANotValid, int validityState, Date timeStampDate, AppInfo ainfo, boolean httpsDialog, String hostname, boolean revStatusUnknown) throws CertificateException {
        try {
            URLClassPathControl.disable();
            if (certs[start] instanceof X509Certificate && certs[end - 1] instanceof X509Certificate) {
                X509Certificate cert = (X509Certificate)certs[start];
                X509Certificate cert2 = (X509Certificate)certs[end - 1];
                ArrayList<String> subjectNameList = CertUtils.getServername(cert);
                boolean mismatch = hostname != null && !CertUtils.checkWildcardDomainList(hostname, subjectNameList);
                Principal prinSubject = cert.getSubjectDN();
                Principal prinIssuer = cert2.getIssuerDN();
                String subjectDNName = prinSubject.getName();
                String subjectName = TrustDeciderDialog.extractSubjectName(subjectDNName);
                String issuerName = TrustDeciderDialog.extractIssuerName(prinIssuer.getName());
                boolean isSelfSigned = cert2.getIssuerX500Principal().equals(cert2.getSubjectX500Principal());
                int n = TrustDeciderDialog.doShowDialog(certs, url, start, end, rootCANotValid, validityState, timeStampDate, ainfo, httpsDialog, hostname, issuerName, subjectName, mismatch, revStatusUnknown, isSelfSigned);
                return n;
            }
            int n = -1;
            return n;
        }
        finally {
            URLClassPathControl.enable();
        }
    }

    private static String extractSubjectName(String subjectDNName) {
        String name = TrustDeciderDialog.extractField(subjectDNName, "CN=");
        if (name == null) {
            String subOName = TrustDeciderDialog.extractField(subjectDNName, "O=");
            String subOUName = TrustDeciderDialog.extractField(subjectDNName, "OU=");
            if (subOName != null || subOUName != null) {
                name = ResourceManager.getString("security.dialog.certShowOOUName", subOName == null ? "" : subOName, subOUName == null ? "" : subOUName);
            }
        }
        if (name == null) {
            name = TrustDeciderDialog.getString("security.dialog.unknown.subject");
        }
        return name;
    }

    private static String extractIssuerName(String issuerDNName) {
        String name = TrustDeciderDialog.extractField(issuerDNName, "O=");
        if (name == null) {
            name = TrustDeciderDialog.getString("security.dialog.unknown.issuer");
        }
        return name;
    }

    static String extractField(String name, String key) {
        String result = null;
        int i = name.indexOf(key);
        if (i >= 0) {
            int j = 0;
            try {
                j = name.charAt(i += key.length()) == '\"' ? name.indexOf(34, ++i) : name.indexOf(44, i);
                result = j < 0 ? name.substring(i) : name.substring(i, j);
            }
            catch (IndexOutOfBoundsException e) {
                Trace.ignored(e);
            }
        }
        return result;
    }

    protected static int doShowDialog(Certificate[] certs, URL url, int start, int end, boolean rootCANotValid, int validityState, Date timeStampDate, AppInfo ainfo, boolean httpsDialog, String hostname, String issuerName, String subjectName, boolean mismatch, boolean revStatusUnknown, boolean isSelfSigned) throws CertificateException {
        int n;
        int ret = -1;
        ArrayList<String> securityAlerts = new ArrayList<String>();
        ArrayList<String> securityInfo = new ArrayList<String>();
        boolean majorWarning = false;
        String alertCaption = null;
        String infoCaption = null;
        boolean isGenericHttpsAlertAdded = false;
        String continueButtonKey = httpsDialog ? "security.dialog.https.buttonContinue" : "security.dialog.signed.buttonContinue";
        String cancelButtonStr = httpsDialog ? TrustDeciderDialog.getString("security.dialog.https.buttonCancel") : TrustDeciderDialog.getString("security.dialog.signed.buttonCancel");
        boolean showAlwaysTrustCheckBox = false;
        boolean needWrapAppInfoToSingleHost = false;
        if (url != null) {
            ainfo.setFrom(url);
        }
        if (!(rootCANotValid || mismatch || validityState != 0 || revStatusUnknown)) {
            String string = infoCaption = httpsDialog ? TrustDeciderDialog.getString("security.dialog.verified.valid.https.caption") : TrustDeciderDialog.getString("security.dialog.signed.caption");
            if (httpsDialog) {
                securityInfo.add(TrustDeciderDialog.getString("security.dialog.verified.valid.https.sub"));
            }
            if (ainfo.isMultiHost()) {
                if (DeployManifestChecker.verifyApplicationLibraryAllowableCodebase(url, ainfo)) {
                    showAlwaysTrustCheckBox = true;
                    needWrapAppInfoToSingleHost = true;
                } else if (ainfo.isJNLPSourceUnknown()) {
                    showAlwaysTrustCheckBox = true;
                }
            } else {
                showAlwaysTrustCheckBox = true;
            }
            if (!httpsDialog) {
                securityInfo.add(TrustDeciderDialog.getString("sandbox.security.info.trusted.state"));
            }
        } else {
            if (rootCANotValid) {
                majorWarning = true;
                if (httpsDialog) {
                    alertCaption = TrustDeciderDialog.getString("security.dialog.unverified.https.caption");
                    securityAlerts.add(TrustDeciderDialog.getString("security.dialog.unverified.https.generic"));
                    isGenericHttpsAlertAdded = true;
                    if (isSelfSigned) {
                        securityAlerts.add(TrustDeciderDialog.getString("security.dialog.selfsigned.https.sub"));
                    } else {
                        securityAlerts.add(TrustDeciderDialog.getString("security.dialog.unverified.https.sub"));
                    }
                } else {
                    alertCaption = TrustDeciderDialog.getString("security.dialog.signed.caption");
                    securityAlerts.add(RISK_MESSAGE);
                    String unknown = TrustDeciderDialog.getString("security.dialog.notverified.subject");
                    securityAlerts.add(TrustDeciderDialog.getString("security.info.publisher.unknown").replaceAll(unknown, unknown.toUpperCase()));
                    securityAlerts.add(TrustDeciderDialog.getString("security.dialog.unverified.signed.publisher"));
                }
            } else if (!mismatch) {
                if (httpsDialog) {
                    alertCaption = TrustDeciderDialog.getString("security.dialog.unverified.https.caption");
                } else {
                    alertCaption = TrustDeciderDialog.getString("security.dialog.signed.caption");
                    securityInfo.add(TrustDeciderDialog.getString("security.dialog.verified.signed.publisher"));
                }
            }
            switch (validityState) {
                case -1: {
                    if (httpsDialog) {
                        if (!isGenericHttpsAlertAdded) {
                            securityAlerts.add(TrustDeciderDialog.getString("security.dialog.unverified.https.generic"));
                            isGenericHttpsAlertAdded = true;
                        }
                        securityAlerts.add(TrustDeciderDialog.getString("security.dialog.expired.https.time"));
                        break;
                    }
                    if (securityAlerts.isEmpty()) {
                        majorWarning = true;
                        securityAlerts.add(TrustDeciderDialog.combineMessage(RISK_MESSAGE, TrustDeciderDialog.getString("sandbox.security.dialog.expired.signed.label")));
                        securityInfo.clear();
                        if (!revStatusUnknown) {
                            if (ainfo.isMultiHost()) {
                                if (DeployManifestChecker.verifyApplicationLibraryAllowableCodebase(url, ainfo)) {
                                    showAlwaysTrustCheckBox = true;
                                    needWrapAppInfoToSingleHost = true;
                                }
                            } else {
                                showAlwaysTrustCheckBox = true;
                            }
                        }
                    }
                    if (rootCANotValid) {
                        securityAlerts.add(TrustDeciderDialog.getString("sandbox.security.dialog.expired.signed.label"));
                        break;
                    }
                    securityAlerts.add(TrustDeciderDialog.getString("sandbox.security.info.expired.state"));
                    break;
                }
                case 1: {
                    if (httpsDialog) {
                        if (!isGenericHttpsAlertAdded) {
                            securityAlerts.add(TrustDeciderDialog.getString("security.dialog.unverified.https.generic"));
                            isGenericHttpsAlertAdded = true;
                        }
                        securityAlerts.add(TrustDeciderDialog.getString("security.dialog.notyetvalid.https.time"));
                        break;
                    }
                    if (securityAlerts.isEmpty() && !rootCANotValid) {
                        majorWarning = true;
                        securityAlerts.add(TrustDeciderDialog.combineMessage(RISK_MESSAGE, TrustDeciderDialog.getString("security.dialog.notyet.signed.sub")));
                        securityInfo.clear();
                    }
                    securityAlerts.add(TrustDeciderDialog.getString("security.dialog.notyetvalid.signed.time"));
                    break;
                }
                default: {
                    if (httpsDialog || rootCANotValid) break;
                    securityInfo.add(TrustDeciderDialog.getString("sandbox.security.info.trusted.state"));
                }
            }
            if (revStatusUnknown) {
                majorWarning = true;
                if (!httpsDialog && securityAlerts.isEmpty()) {
                    securityAlerts.add(TrustDeciderDialog.combineMessage(RISK_MESSAGE, TrustDeciderDialog.getString("sandbox.security.info.selfsigned.revocation.unknown")));
                }
                securityAlerts.add(TrustDeciderDialog.getString("sandbox.security.info.revocation.unsure.state"));
                securityInfo.clear();
            }
        }
        if (mismatch) {
            if (alertCaption == null) {
                alertCaption = ResourceManager.getString("security.dialog.unverified.https.caption");
            }
            if (securityAlerts.isEmpty()) {
                securityAlerts.add(TrustDeciderDialog.getString("security.dialog.unverified.https.generic"));
            }
            securityAlerts.add(ResourceManager.getString("security.dialog.hostname.mismatch.moreinfo", hostname, subjectName));
        }
        if (!httpsDialog) {
            ArrayList<String> addToMe = securityInfo;
            int index = 0;
            if (!securityAlerts.isEmpty()) {
                index = 1;
                addToMe = securityAlerts;
            }
            addToMe.add(index++, MORE_RUN_MESSAGE);
            addToMe.add(index++, MORE_CANCEL_MESSAGE);
            if (!rootCANotValid) {
                addToMe.add(index++, MORE_TRUSTED_MESSAGE);
            }
        } else if (hostname != null) {
            ainfo.setTitle(hostname);
        } else {
            ainfo.setTitle(subjectName);
        }
        String caption = alertCaption != null ? alertCaption : infoCaption;
        String[] alertStrs = null;
        String[] infoStrs = null;
        String titleStr = null;
        if (!securityAlerts.isEmpty()) {
            alertStrs = new String[securityAlerts.size()];
            for (n = 0; n < securityAlerts.size(); ++n) {
                alertStrs[n] = ((String)securityAlerts.get(n)).toString();
            }
        }
        if (!securityInfo.isEmpty()) {
            infoStrs = new String[securityInfo.size()];
            for (n = 0; n < securityInfo.size(); ++n) {
                infoStrs[n] = ((String)securityInfo.get(n)).toString();
            }
        }
        if (securityAlerts.isEmpty() && securityInfo.isEmpty()) {
            throw new CertificateException(TrustDeciderDialog.getString("security.dialog.exception.message"));
        }
        if (Platform.get().isNativeSandbox()) {
            showAlwaysTrustCheckBox = false;
        }
        if (!Trace.isAutomationEnabled()) {
            if (rootCANotValid) {
                subjectName = TrustDeciderDialog.getString("security.dialog.notverified.subject").toUpperCase();
            }
            titleStr = alertStrs == null ? TrustDeciderDialog.getString("security.dialog.valid.caption") : TrustDeciderDialog.getString("security.dialog.caption");
            DeployManifestChecker.printWarningsIfRequired(url, ainfo);
            ret = ToolkitStore.getUI().showSecurityDialog(needWrapAppInfoToSingleHost ? AppInfo.createSingleHostAppInfo(ainfo) : ainfo, titleStr, caption, subjectName, url, showAlwaysTrustCheckBox, false, continueButtonKey, cancelButtonStr, alertStrs, infoStrs, true, certs, start, end, majorWarning, httpsDialog, rootCANotValid);
        } else {
            Trace.msgSecurityPrintln("trustdecider.automation.trustcert");
            ret = 0;
        }
        return ret;
    }

    private static String combineMessage(String m1, String m2) {
        StringBuilder sb = new StringBuilder();
        sb.append(m1);
        sb.append("\n\n");
        sb.append(m2);
        return sb.toString();
    }

    private static String getString(String key) {
        return ResourceManager.getString(key);
    }
}

