/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.trace;

import com.sun.deploy.config.Config;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.trace.TraceListener;
import java.io.File;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class LoggerTraceListener
implements TraceListener {
    private static LoggerTraceListener sharedInstance;
    private final Logger logger;

    public static synchronized LoggerTraceListener getOrCreateSharedInstance(String logName, File logFile, File defaultDir, String prefix, String suffix, boolean replace) {
        if ((sharedInstance == null || replace) && (logFile = LoggerTraceListener.ensureLogFileAvailable(logFile, defaultDir, prefix, suffix)) != null) {
            sharedInstance = new LoggerTraceListener(logName, logFile.getPath());
        }
        return sharedInstance;
    }

    public LoggerTraceListener(String loggerName, String filename) {
        FileHandler handler = null;
        this.logger = Logger.getLogger(loggerName);
        this.logger.setUseParentHandlers(false);
        try {
            handler = new FileHandler(filename, Config.getIntProperty("deployment.max.output.file.size") * 0x100000, 1);
            this.logger.addHandler(handler);
            this.logger.setLevel(Level.OFF);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public void print(String msg) {
        this.logger.log(Level.FINE, msg);
    }

    @Override
    public void flush() {
    }

    static File ensureLogFileAvailable(File file, File defaultLogDir, String prefix, String suffix) {
        if (!LoggerTraceListener.ensureExists(file)) {
            file = Trace.createTempFile(prefix, suffix, defaultLogDir);
        }
        return file;
    }

    private static boolean ensureExists(File file) {
        if (file == null) {
            return false;
        }
        try {
            if (!file.exists()) {
                File parentDir = file.getParentFile();
                if (!parentDir.exists()) {
                    parentDir.mkdirs();
                }
                file.createNewFile();
            }
            return true;
        }
        catch (IOException ioe) {
            Trace.println("Cannot write to file: " + file, TraceLevel.BASIC);
            return false;
        }
    }
}

