/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.ui;

import com.sun.deploy.config.Config;
import com.sun.deploy.config.Platform;
import com.sun.deploy.net.DownloadException;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.BlockedException;
import com.sun.deploy.security.CertificateDialog;
import com.sun.deploy.security.URLClassPathControl;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.ui.FancyButton;
import com.sun.deploy.ui.ImageLoader;
import com.sun.deploy.ui.ImageLoaderCallback;
import com.sun.deploy.ui.JSmartTextArea;
import com.sun.deploy.ui.MoreInfoDialog;
import com.sun.deploy.ui.PromptEditorKit;
import com.sun.deploy.ui.SSV3DialogContent;
import com.sun.deploy.ui.UIFactory;
import com.sun.deploy.ui.UITextArea;
import com.sun.deploy.util.DialogListener;
import com.sun.deploy.util.SafeThreadFactory;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.net.URL;
import java.security.cert.Certificate;
import java.security.cert.CertificateRevokedException;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.JTextComponent;

public class DialogTemplate
implements ActionListener,
ImageLoaderCallback {
    private boolean isDeprecationDialog;
    private final Color LINK_COLOR = new Color(33, 79, 131);
    private final Color LINK_HIGHLIGHT_COLOR = new Color(192, 63, 63);
    private static Font ssvFont;
    private static Font ssvBold;
    private static Font ssvBigFont;
    private static Font ssvBigBoldFont;
    private static Font ssvSmallFont;
    private static Font ssvSmallBoldFont;
    private final AppInfo ainfo;
    private String topText;
    private final String appTitle;
    private String appPublisher = null;
    private URL appURL = null;
    private int defaultButton = 0;
    private Frame dummyFrame = null;
    private boolean useErrorIcon = false;
    private boolean useWarningIcon = false;
    private boolean useInfoIcon = false;
    private boolean useMixcodeIcon = false;
    private boolean useBlockedIcon = false;
    private boolean isBlockedDialog = false;
    private boolean requestFocusOkBtn = false;
    private boolean requestFocusCancelBtn = false;
    private int addedSpace;
    private JLabel progressStatusLabel = null;
    private JPanel topPanel;
    private JPanel centerPanel;
    private JPanel bottomPanel;
    private JLabel topIcon;
    private JLabel securityIcon;
    private JLabel nameInfo;
    private JLabel publisherInfo;
    private JLabel urlInfo;
    private JLabel originInfo;
    private JLabel appletLocationInfo;
    private JButton okBtn;
    private JButton cancelBtn;
    private JCheckBox always;
    private JLabel mixedCodeLabel;
    private JTextComponent masthead = null;
    private static final int ICON_SIZE = 48;
    private int userAnswer = -1;
    private final int DIALOG_WIDTH = 510;
    private final int SMALL_DIALOG_WIDTH = 260;
    private int dialogWidth = 510;
    private final int MAX_LARGE_SCROLL_WIDTH = 600;
    private final Color BG = Color.white;
    private final String SECURITY_ALERT_HIGH = "security_high.png";
    private final String SECURITY_ALERT_LOW = "security_low.png";
    private static int MAIN_TEXT_WIDTH;
    private final String OK_ACTION = "OK";
    private int start;
    private int end;
    private Certificate[] certs;
    private String[] alertStrs;
    private String[] infoStrs;
    private int securityInfoCount;
    private String acceptTitle = null;
    private String acceptText = null;
    protected JProgressBar progressBar = null;
    private boolean stayAliveOnOk = false;
    private String contentString = null;
    private String reason = null;
    private String cacheUpgradeContentString = null;
    private String contentLabel = null;
    private String alwaysString = null;
    private String mixedCodeString = null;
    private boolean contentScroll = false;
    private boolean includeMasthead = true;
    private boolean includeAppInfo = true;
    private boolean largeScroll = false;
    private Throwable throwable = null;
    private String detailString = null;
    private char[] pwd = new char[0];
    private String userName;
    private String domain;
    private JTextField pwdName;
    private JTextField pwdDomain;
    private JPasswordField password;
    private JList<String> scrollList;
    private boolean showDetails = false;
    TreeMap<String, X509Certificate[]> clientAuthCertsMap;
    private final JDialog dialog;
    static int minFontSize;
    private boolean majorWarning = false;
    private boolean sandboxApp = false;
    protected boolean hideTitleAndPublisher = false;
    private boolean mixedJsToJava = false;
    private Runnable toFrontRunner = null;

    DialogTemplate(AppInfo ainfo, Component owner, String title, String topText) {
        this(ainfo, owner, title, topText, true);
    }

    DialogTemplate(AppInfo ainfo, Component owner, String title, String topText, boolean modalOnTop) {
        this(ainfo, owner, title, topText, modalOnTop, 0);
    }

    DialogTemplate(AppInfo ainfo, Component owner, String title, String topText, boolean modalOnTop, int defaultButton) {
        this.dialog = owner == null || owner instanceof Frame ? new JDialog((Frame)owner, title, modalOnTop) : new JDialog((Dialog)owner, title, modalOnTop);
        if (modalOnTop) {
            this.setModalOnTop();
            this.toFrontRunner = new Runnable(){

                @Override
                public void run() {
                    try {
                        DialogTemplate.this.dialog.toFront();
                    }
                    catch (Exception e) {
                        Trace.ignoredException(e);
                    }
                }
            };
            this.dialog.addWindowListener(new WindowListenerImpl());
        }
        if (ainfo == null) {
            ainfo = new AppInfo();
        }
        this.ainfo = ainfo;
        this.topText = topText;
        this.appTitle = ainfo.getDisplayTitle();
        this.appPublisher = ainfo.getDisplayVendor();
        this.appURL = ainfo.getFrom();
        this.defaultButton = defaultButton;
        this.throwable = ainfo.getThrowable();
    }

    void setSecurityContent(boolean showAlways, boolean checkAlways, String okBtnStr, String cancelBtnStr, String[] alerts, String[] info, int securityInfoCount, boolean showMoreInfo, Certificate[] certs, int start, int end, boolean majorWarning) {
        this.certs = certs;
        this.start = start;
        this.end = end;
        this.alertStrs = alerts;
        this.infoStrs = info;
        this.securityInfoCount = securityInfoCount;
        this.majorWarning = majorWarning;
        if (alerts != null && alerts.length > 0) {
            this.useWarningIcon = true;
        }
        try {
            Container top = this.dialog.getContentPane();
            top.setLayout(new BorderLayout());
            top.add((Component)this.createTopPanel(false), "North");
            this.setModalOnTop();
            if (showAlways) {
                this.alwaysString = this.getMessage(this.ainfo.isMultiHost() ? "security.dialog.multi.always" : "security.dialog.always");
            }
            top.add((Component)this.createCenterPanel(checkAlways, okBtnStr, cancelBtnStr, -1, true), "Center");
            top.add((Component)this.createBottomPanel(showMoreInfo), "South");
            this.dialog.setResizable(false);
        }
        catch (Throwable t) {
            Trace.ignored(t);
        }
    }

    private void setModalOnTop() {
        this.dialog.setModalityType(Dialog.ModalityType.TOOLKIT_MODAL);
        this.dialog.setAlwaysOnTop(true);
    }

    void setNewSecurityContent(boolean showAlways, boolean checkAlways, String okBtnStr, String cancelBtnStr, String[] alerts, String[] info, int securityInfoCount, boolean showMoreInfo, Certificate[] certs, int start, int end, boolean majorWarning, String acceptTitle, String acceptText, boolean isHttpsDialog, boolean sandboxApp, boolean selfSigned) {
        this.certs = certs;
        this.start = start;
        this.end = end;
        this.alertStrs = alerts;
        this.infoStrs = info;
        this.securityInfoCount = securityInfoCount;
        this.majorWarning = majorWarning;
        this.acceptTitle = acceptTitle;
        this.acceptText = acceptText;
        this.sandboxApp = sandboxApp;
        try {
            String riskMsg;
            this.alwaysString = showAlways ? this.getMessage(this.ainfo.isMultiHost() ? "security.dialog.multi.always" : "security.dialog.always") : null;
            this.ssvSetFonts();
            JPanel content = new JPanel();
            if (this.alertStrs == null || this.alertStrs.length == 0) {
                content = DialogTemplate.createShadedContentBorderPanel(true);
                this.dialog.setUndecorated(true);
                final Point point = new Point();
                this.dialog.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent e) {
                        point.x = e.getX();
                        point.y = e.getY();
                    }
                });
                this.dialog.addMouseMotionListener(new MouseMotionAdapter(){

                    @Override
                    public void mouseDragged(MouseEvent e) {
                        Point p = DialogTemplate.this.dialog.getLocationOnScreen();
                        DialogTemplate.this.dialog.setLocation(p.x + e.getX() - point.x, p.y + e.getY() - point.y);
                    }
                });
            } else {
                content = this.createShadedContentPanel();
            }
            this.dialog.setContentPane(content);
            content.setLayout(new BorderLayout());
            content.setOpaque(false);
            this.setModalOnTop();
            JPanel TopPanel = this.createSecurityTopPanel(isHttpsDialog);
            content.add((Component)TopPanel, "North");
            JPanel riskPanel = new JPanel();
            JPanel acceptPanel = new JPanel();
            acceptPanel.setOpaque(false);
            if (isHttpsDialog) {
                riskMsg = this.alertStrs == null || this.alertStrs.length == 0 ? this.getMessage("security.dialog.https.valid.risk") : this.getMessage("security.dialog.https.mismatch.risk");
                riskPanel = this.createSecurityRiskPanel(riskMsg, false, true);
                acceptPanel = this.createButtonsPanel(okBtnStr, cancelBtnStr);
                acceptPanel.setOpaque(false);
                acceptPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 16));
            } else if (!majorWarning) {
                riskMsg = sandboxApp ? this.getMessage("sandbox.security.dialog.valid.signed.risk") : (this.ainfo.isMultiHost() ? this.getMessage("security.dialog.valid.signed.risk.multihost") : this.getMessage("security.dialog.valid.signed.risk"));
                riskPanel = this.createTrustSecurityRiskPanel(riskMsg);
                if (this.alwaysString != null) {
                    acceptPanel = this.createTrustSecurityAlwaysPanel(checkAlways);
                }
            } else {
                riskPanel = this.createSecurityRiskPanel(alerts[0], selfSigned, false);
                this.consumeAlertString0();
                acceptPanel = this.createSecurityAcceptPanel(okBtnStr, cancelBtnStr, checkAlways);
            }
            JPanel centerPanel = new JPanel(new BorderLayout());
            centerPanel.add((Component)riskPanel, "North");
            centerPanel.add((Component)acceptPanel, "South");
            centerPanel.setOpaque(false);
            content.add((Component)centerPanel, "Center");
            JPanel bottomPanel = new JPanel();
            bottomPanel.setOpaque(false);
            if (!isHttpsDialog && !majorWarning) {
                boolean includeNativeSandboxWarning = !sandboxApp && Platform.get().isNativeSandbox();
                bottomPanel = this.createTrustSecurityBottomPanel(okBtnStr, cancelBtnStr, includeNativeSandboxWarning);
            } else if (this.alwaysString != null) {
                bottomPanel = this.createSecurityBottomPanel(isHttpsDialog);
            }
            if (selfSigned) {
                JPanel dummyPanel = new JPanel(new BorderLayout());
                dummyPanel.setOpaque(false);
                dummyPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 16, 0));
                content.add((Component)dummyPanel, "South");
            } else {
                content.add((Component)bottomPanel, "South");
            }
            if (this.alertStrs == null || this.alertStrs.length == 0) {
                this.dialog.getRootPane().setDefaultButton(this.okBtn);
                this.requestFocusOkBtn = true;
                this.okBtn.requestFocusInWindow();
            } else {
                this.dialog.getRootPane().setDefaultButton(this.cancelBtn);
                this.requestFocusCancelBtn = true;
                this.cancelBtn.requestFocusInWindow();
            }
            this.dialog.setResizable(false);
        }
        catch (Throwable t) {
            Trace.ignored(t);
        }
    }

    void setSSVContent(String message, String moreInfoText, URL moreInfoURL, String choiceText, String choice1Label, String choice2Label, String btnOneLabel, String btnTwoLabel) {
        try {
            this.ssvSetFonts();
            JPanel content = this.createShadedContentPanel();
            this.dialog.setContentPane(content);
            content.setLayout(new BorderLayout());
            content.setOpaque(false);
            this.setModalOnTop();
            content.add((Component)this.createSSVTopPanel(this.topText, this.appTitle, this.ainfo.getDisplayFrom()), "North");
            JPanel riskPanel = this.createSSVRiskPanel(message, moreInfoText, moreInfoURL);
            final SSVChoicePanel choicePanel = new SSVChoicePanel(choiceText, choice1Label, choice2Label);
            JPanel centerPanel = new JPanel(new BorderLayout());
            centerPanel.add((Component)riskPanel, "North");
            centerPanel.add((Component)choicePanel, "South");
            centerPanel.setOpaque(false);
            content.add((Component)centerPanel, "Center");
            JPanel bottom = new JPanel(new FlowLayout(4, 0, 0));
            bottom.setOpaque(false);
            bottom.setBorder(BorderFactory.createEmptyBorder(8, 16, 8, 16));
            this.okBtn = new JButton(btnOneLabel);
            this.okBtn.setFont(ssvFont);
            this.okBtn.setOpaque(false);
            this.okBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (choicePanel.getSelection() == 0) {
                        DialogTemplate.this.setUserAnswer(2);
                    } else {
                        DialogTemplate.this.setUserAnswer(0);
                    }
                    DialogTemplate.this.setVisible(false);
                }
            });
            bottom.add(this.okBtn);
            this.cancelBtn = new JButton(btnTwoLabel);
            this.cancelBtn.setFont(ssvFont);
            this.cancelBtn.setOpaque(false);
            this.cancelBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    DialogTemplate.this.cancelAction();
                }
            });
            this.setCancelAction();
            bottom.add(Box.createHorizontalStrut(10));
            bottom.add(this.cancelBtn);
            this.dialog.getRootPane().setDefaultButton(this.okBtn);
            content.add((Component)bottom, "South");
            this.dialog.setResizable(false);
        }
        catch (Throwable t) {
            Trace.ignored(t);
        }
    }

    void setSSV3Content(SSV3DialogContent content) {
        try {
            JPanel shadedContent = DialogTemplate.createShadedContentBorderPanel(false);
            shadedContent.setLayout(new BorderLayout());
            shadedContent.setOpaque(false);
            shadedContent.add((Component)content.getContent(), "Center");
            this.dialog.setContentPane(shadedContent);
            this.setModalOnTop();
            this.dialog.setResizable(false);
        }
        catch (Throwable t) {
            Trace.ignored(t);
        }
    }

    void setCannotDownloadContent(String okBtnStr, String cancelBtnStr, URL moreURL, String moreText) {
        Container contentPane = this.dialog.getContentPane();
        if (contentPane instanceof JComponent) {
            ((JComponent)contentPane).setOpaque(false);
        }
        try {
            contentPane.setLayout(new BorderLayout());
            contentPane.add((Component)this.createLinkPanel(this.topText, moreURL, moreText), "North");
            contentPane.add((Component)this.createCenterPanel(false, okBtnStr, cancelBtnStr, -1, false), "Center");
            this.dialog.setResizable(false);
        }
        catch (Throwable t) {
            Trace.ignored(t);
        }
    }

    void setSimpleContent(String contentString, boolean contentScroll, String infoString, String okBtnStr, String cancelBtnStr, boolean includeTop, boolean useWarningIcon) {
        Container contentPane;
        this.contentString = contentString;
        this.contentScroll = contentScroll;
        this.includeMasthead = includeTop;
        this.includeAppInfo = includeTop;
        this.largeScroll = !includeTop;
        this.useWarningIcon = useWarningIcon;
        if (infoString != null) {
            String[] strs = new String[]{infoString};
            if (useWarningIcon) {
                this.alertStrs = strs;
            } else {
                this.infoStrs = strs;
            }
        }
        if ((contentPane = this.dialog.getContentPane()) instanceof JComponent) {
            ((JComponent)contentPane).setOpaque(false);
        }
        try {
            contentPane.setLayout(new BorderLayout());
            if (this.ainfo != null && this.ainfo.getTitle() != null && this.ainfo.getTitle().length() == 0) {
                this.hideTitleAndPublisher = true;
            }
            contentPane.add((Component)this.createTopPanel(false), "North");
            contentPane.add((Component)this.createCenterPanel(false, okBtnStr, cancelBtnStr, -1, false), "Center");
            contentPane.add((Component)this.createBottomPanel(false), "South");
            boolean isResizable = contentScroll;
            this.dialog.setResizable(isResizable);
        }
        catch (Throwable t) {
            Trace.ignored(t);
        }
    }

    void setMixedCodeContent(String contentString, boolean contentScroll, String infoString, String bottomString, String okBtnStr, String cancelBtnStr, boolean includeTop, boolean useWarningIcon, boolean jsToJava, String showAlways) {
        this.mixedJsToJava = jsToJava;
        this.contentString = contentString;
        this.contentScroll = contentScroll;
        this.includeMasthead = includeTop;
        this.includeAppInfo = includeTop;
        this.largeScroll = !includeTop;
        this.useMixcodeIcon = true;
        this.alwaysString = showAlways;
        this.alertStrs = new String[1];
        String[] botStr = new String[]{bottomString};
        this.alertStrs = botStr;
        this.infoStrs = new String[3];
        String prefix = "security.dialog.mixcode." + (this.mixedJsToJava ? "js." : "");
        String aStr = this.getMessage(prefix + "info1");
        String bStr = this.getMessage(prefix + "info2");
        String cStr = this.getMessage(prefix + "info3");
        String[] strs = new String[]{aStr, bStr, cStr};
        this.infoStrs = strs;
        try {
            Container contentPane = this.dialog.getContentPane();
            contentPane.setLayout(new BorderLayout());
            contentPane.add((Component)this.createTopPanel(false), "North");
            this.mixedCodeString = infoString;
            contentPane.add((Component)this.createCenterPanel(false, okBtnStr, cancelBtnStr, -1, true), "Center");
            contentPane.add((Component)this.createBottomPanel(false), "South");
            this.setModalOnTop();
            this.okBtn.requestFocusInWindow();
            boolean isResizable = contentScroll;
            this.dialog.setResizable(isResizable);
        }
        catch (Throwable t) {
            Trace.ignored(t);
        }
    }

    void setListContent(String label, JList<String> scrollList, boolean showDetails, String okBtnStr, String cancelBtnStr, TreeMap<String, X509Certificate[]> clientAuthCertsMap) {
        this.useWarningIcon = true;
        this.includeAppInfo = false;
        this.clientAuthCertsMap = clientAuthCertsMap;
        this.contentLabel = label;
        this.contentScroll = true;
        this.scrollList = scrollList;
        this.showDetails = showDetails;
        try {
            Container contentPane = this.dialog.getContentPane();
            contentPane.setLayout(new BorderLayout());
            contentPane.add((Component)this.createTopPanel(false), "North");
            contentPane.add((Component)this.createCenterPanel(false, okBtnStr, cancelBtnStr, -1, true), "Center");
            contentPane.add((Component)this.createBottomPanel(false), "South");
        }
        catch (Throwable t) {
            Trace.ignored(t);
        }
    }

    void setApiContent(String contentString, String contentLabel, String alwaysString, boolean alwaysChecked, String okBtnStr, String cancelBtnStr) {
        this.contentString = contentString;
        this.contentLabel = contentLabel;
        this.contentScroll = contentString != null;
        this.alwaysString = alwaysString;
        if (contentLabel == null && contentString != null) {
            this.infoStrs = new String[1];
            this.infoStrs[0] = contentString;
            this.contentString = null;
        }
        this.includeMasthead = true;
        this.includeAppInfo = this.contentString == null;
        this.largeScroll = false;
        try {
            Container contentPane = this.dialog.getContentPane();
            contentPane.setLayout(new BorderLayout());
            contentPane.add((Component)this.createTopPanel(false), "North");
            contentPane.add((Component)this.createCenterPanel(false, okBtnStr, cancelBtnStr, -1, false), "Center");
            contentPane.add((Component)this.createBottomPanel(false), "South");
            this.setModalOnTop();
            boolean isResizable = this.contentScroll;
            this.dialog.setResizable(isResizable);
        }
        catch (Throwable t) {
            Trace.ignored(t);
        }
    }

    void setPublisherInfo(String contentString, String okBtnStr, String cancelBtnStr, String detailString, boolean hideLabel) {
        this.contentString = contentString;
        this.detailString = detailString;
        this.useInfoIcon = true;
        if (detailString == null) {
            cancelBtnStr = null;
        }
        if (hideLabel) {
            this.includeAppInfo = false;
        }
        try {
            Container contentPane = this.dialog.getContentPane();
            contentPane.setLayout(new BorderLayout());
            contentPane.add((Component)this.createTopPanel(false), "North");
            contentPane.add((Component)this.createCenterPanel(false, okBtnStr, cancelBtnStr, -1, true), "Center");
            this.dialog.setResizable(false);
        }
        catch (Throwable t) {
            Trace.ignored(t);
        }
    }

    void setBlockedDialogInfo(String reasonString, String contentString, String okBtnStr, String cancelBtnStr, String detailString, boolean hideLabel) {
        this.contentString = contentString;
        this.reason = reasonString;
        this.detailString = detailString;
        this.useBlockedIcon = true;
        this.isBlockedDialog = true;
        if (detailString == null) {
            cancelBtnStr = null;
        }
        if (hideLabel) {
            this.includeAppInfo = false;
        }
        try {
            Container contentPane = this.dialog.getContentPane();
            contentPane.setLayout(new BorderLayout());
            contentPane.add((Component)this.createTopPanel(false), "North");
            contentPane.add((Component)this.createCenterPanel(false, okBtnStr, cancelBtnStr, -1, true), "Center");
            this.dialog.setResizable(false);
        }
        catch (Throwable t) {
            Trace.ignored(t);
        }
    }

    void setErrorContent(String contentString, String okBtnStr, String cancelBtnStr, Throwable throwable, String detailString, Certificate[] certs, boolean hideLabel) {
        BlockedException e;
        boolean showPublisher = true;
        this.contentString = contentString;
        this.throwable = throwable;
        this.detailString = detailString;
        this.certs = certs;
        if (hideLabel) {
            this.includeAppInfo = false;
        }
        if (throwable instanceof BlockedException) {
            this.useBlockedIcon = true;
        } else {
            this.useErrorIcon = true;
        }
        if (throwable instanceof BlockedException && (e = (BlockedException)throwable).getCause() instanceof CertificateRevokedException) {
            showPublisher = false;
        }
        try {
            Container contentPane = this.dialog.getContentPane();
            contentPane.setLayout(new BorderLayout());
            contentPane.add((Component)this.createTopPanel(false), "North");
            contentPane.add((Component)this.createCenterPanel(false, okBtnStr, cancelBtnStr, -1, showPublisher), "Center");
            contentPane.add((Component)this.createBottomPanel(false), "South");
            this.dialog.setResizable(false);
        }
        catch (Throwable t) {
            Trace.ignored(t);
        }
    }

    void setMultiButtonErrorContent(String message, String btnOneKey, String btnTwoKey, String btnThreeKey) {
        this.useErrorIcon = true;
        try {
            Container contentPane = this.dialog.getContentPane();
            contentPane.setLayout(new BorderLayout());
            contentPane.add((Component)this.createTopPanel(false), "North");
            JPanel centerPanel = null;
            if (this.throwable != null) {
                centerPanel = this.createLabelsPanel(false);
                centerPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 12));
            } else {
                centerPanel = this.createInfoPanel(message);
            }
            contentPane.add((Component)centerPanel, "Center");
            contentPane.add((Component)this.createThreeButtonsPanel(btnOneKey, btnTwoKey, btnThreeKey, false), "South");
            this.dialog.setResizable(false);
        }
        catch (Throwable t) {
            Trace.ignored(t);
        }
    }

    void setInfoContent(String contentString, String okBtnStr) {
        this.useInfoIcon = false;
        this.contentString = contentString;
        try {
            Container contentPane = this.dialog.getContentPane();
            contentPane.setLayout(new BorderLayout());
            contentPane.add((Component)this.createTopPanel(false), "North");
            contentPane.add((Component)this.createCenterPanel(false, okBtnStr, null, -1, true), "Center");
            this.dialog.setResizable(false);
        }
        catch (Throwable t) {
            Trace.ignored(t);
        }
    }

    void setDeprecationWarningContent(String contentString, String okBtnStr, String alwaysStr) {
        this.useInfoIcon = false;
        this.contentString = contentString;
        this.alwaysString = alwaysStr;
        this.useWarningIcon = true;
        this.includeAppInfo = true;
        this.isDeprecationDialog = true;
        try {
            Container contentPane = this.dialog.getContentPane();
            contentPane.setLayout(new BorderLayout());
            contentPane.add((Component)this.createTopPanel(false), "North");
            contentPane.add((Component)this.createCenterPanel(true, okBtnStr, null, -1, true), "Center");
            this.dialog.setResizable(false);
        }
        catch (Throwable t) {
            Trace.ignored(t);
        }
    }

    void setPasswordContent(String details, boolean showUserName, boolean showDomain, String userName, String domain, boolean save, char[] password, String scheme, String warning) {
        try {
            Container contentPane = this.dialog.getContentPane();
            contentPane.setLayout(new BorderLayout());
            contentPane.add((Component)this.createPasswordPanel(details, showUserName, showDomain, userName, domain, save, password, scheme, warning), "Center");
            this.setModalOnTop();
            this.dialog.setResizable(false);
        }
        catch (Throwable t) {
            Trace.ignored(t);
        }
    }

    void setUpdateCheckContent(String infoStr, String yesBtnKey, String noBtnKey, String askLaterBtnKey) {
        try {
            Container contentPane = this.dialog.getContentPane();
            contentPane.setLayout(new BorderLayout());
            contentPane.add((Component)this.createTopPanel(false), "North");
            contentPane.add((Component)this.createInfoPanel(infoStr), "Center");
            contentPane.add((Component)this.createThreeButtonsPanel(yesBtnKey, noBtnKey, askLaterBtnKey, true), "South");
            this.dialog.setResizable(false);
        }
        catch (Throwable t) {
            Trace.ignored(t);
        }
    }

    void setProgressContent(String okBtnStr, String detailBtnStr, String contentStr, boolean showOkBtn, int percent) {
        try {
            this.cacheUpgradeContentString = contentStr;
            Container contentPane = this.dialog.getContentPane();
            contentPane.setLayout(new BorderLayout());
            contentPane.add((Component)this.createTopPanel(false), "North");
            contentPane.add((Component)this.createCenterPanel(false, okBtnStr, detailBtnStr, percent, true), "Center");
            if (this.cacheUpgradeContentString == null) {
                contentPane.add((Component)this.createBottomPanel(false), "South");
            }
            this.dialog.setResizable(false);
        }
        catch (Throwable t) {
            Trace.ignored(t);
        }
    }

    public void setTitle(String title) {
        this.dialog.setTitle(title);
    }

    private JPanel createInfoPanel(String infoStr) {
        JPanel infoPanel = new JPanel();
        infoPanel.setLayout(new FlowLayout(3, 0, 0));
        infoPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 12));
        UITextArea infoText = new UITextArea(ResourceManager.getUIFont().getSize(), 478, false);
        infoText.setText(infoStr);
        infoText.setSize(infoText.getPreferredSize());
        infoPanel.add(infoText);
        return infoPanel;
    }

    private JPanel createThreeButtonsPanel(String btnOneKey, String btnTwoKey, String btnThreeKey, boolean isUpdateSpecific) {
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new FlowLayout(4, 6, 0));
        buttonsPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        JButton oneBtn = new JButton(this.getMessage(btnOneKey));
        oneBtn.setMnemonic(ResourceManager.getMnemonic(btnOneKey));
        oneBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTemplate.this.setUserAnswer(0);
                DialogTemplate.this.setVisible(false);
            }
        });
        buttonsPanel.add(oneBtn);
        JButton twoBtn = new JButton(this.getMessage(btnTwoKey));
        twoBtn.setMnemonic(ResourceManager.getMnemonic(btnTwoKey));
        twoBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTemplate.this.setUserAnswer(1);
                DialogTemplate.this.setVisible(false);
            }
        });
        buttonsPanel.add(twoBtn);
        JButton threeBtn = null;
        if (btnThreeKey != null) {
            threeBtn = new JButton(this.getMessage(btnThreeKey));
            threeBtn.setMnemonic(ResourceManager.getMnemonic(btnThreeKey));
            threeBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    DialogTemplate.this.setUserAnswer(3);
                    DialogTemplate.this.setVisible(false);
                }
            });
            buttonsPanel.add(threeBtn);
        }
        if (isUpdateSpecific) {
            threeBtn.setToolTipText(this.getMessage("autoupdatecheck.masthead"));
        }
        if (threeBtn != null) {
            JButton[] btns = new JButton[]{oneBtn, twoBtn, threeBtn};
            DialogTemplate.resizeButtons(btns);
        } else {
            JButton[] btns = new JButton[]{oneBtn, twoBtn};
            DialogTemplate.resizeButtons(btns);
        }
        return buttonsPanel;
    }

    private JPanel createTopPanel(boolean useMastheadImage) {
        ImageIcon icon;
        this.topPanel = new JPanel();
        this.topPanel.setBackground(this.BG);
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.topPanel.setLayout(gb);
        Font f = ResourceManager.getUIFont();
        int fontSize = this.isBlockedDialog ? f.getSize() + 2 : f.getSize() + 4;
        this.masthead = new UITextArea(fontSize, MAIN_TEXT_WIDTH, true);
        this.masthead.setText(this.topText);
        Dimension pref = this.masthead.getPreferredSize();
        this.masthead.setSize(pref.width, pref.height);
        this.masthead.setBorder(BorderFactory.createEmptyBorder(6, 12, 6, 6));
        if (useMastheadImage) {
            if (this.includeMasthead) {
                c.fill = 2;
                c.gridwidth = -1;
                c.anchor = 17;
                gb.setConstraints(this.masthead, c);
                this.topPanel.add(this.masthead);
                icon = ResourceManager.getIcon("progress.background.image");
                if (this.masthead instanceof UITextArea) {
                    ((UITextArea)this.masthead).setBackgroundImage(icon.getImage());
                }
            }
        } else if (this.includeMasthead) {
            this.topPanel.setBackground(Color.white);
            this.topPanel.setForeground(Color.white);
            this.topPanel.setOpaque(true);
            this.topIcon = new JLabel();
            this.topIcon.setHorizontalAlignment(0);
            this.topIcon.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 12));
            icon = ResourceManager.getIcon("java48.image");
            if (this.useErrorIcon) {
                icon = ResourceManager.getIcon("error48.image");
            }
            if (this.useInfoIcon) {
                icon = ResourceManager.getIcon("info48.image");
            }
            if (this.useMixcodeIcon) {
                icon = ResourceManager.getIcon("mixcode.image");
            }
            if (this.useBlockedIcon) {
                icon = ResourceManager.getIcon("cert_error48.image");
            }
            this.topIcon.setIcon(icon);
            if (this.useWarningIcon) {
                icon = ResourceManager.getIcon("warning48.image");
                this.topIcon.setIcon(icon);
            } else if (this.ainfo.getIconRef() != null && !this.useBlockedIcon) {
                ImageLoader.getInstance().loadImage(this.ainfo.getIconRef(), this.ainfo.getIconVersion(), this);
            }
            c.fill = 2;
            c.gridwidth = -1;
            c.anchor = 13;
            gb.setConstraints(this.masthead, c);
            this.topPanel.add(this.masthead);
            c.fill = 0;
            c.gridwidth = 0;
            c.anchor = 17;
            gb.setConstraints(this.topIcon, c);
            this.topPanel.add(this.topIcon);
        }
        JSeparator sep = new JSeparator();
        sep.setPreferredSize(new Dimension(510, 1));
        c.gridy = 1;
        c.gridwidth = 0;
        gb.setConstraints(sep, c);
        this.topPanel.add(sep);
        return this.topPanel;
    }

    private JPanel createLinkPanel(String content, URL moreURL, String moreText) {
        this.dialogWidth = this.appTitle != null || this.appPublisher != null ? 510 : 260;
        JPanel topPanel = new JPanel(new BorderLayout());
        this.ssvSetFonts();
        LinkText lt = new LinkText(content, moreText, moreURL);
        lt.setFont(ssvFont);
        lt.setBorder(BorderFactory.createEmptyBorder(6, 6, 0, 6));
        this.topIcon = new JLabel();
        this.topIcon.setHorizontalAlignment(0);
        this.topIcon.setBorder(BorderFactory.createEmptyBorder(6, 20, 6, 6));
        this.topIcon.setIcon(ResourceManager.getIconResource("security_high.png"));
        topPanel.add((Component)this.topIcon, "West");
        topPanel.add((Component)lt, "Center");
        JSeparator sep = new JSeparator();
        sep.setPreferredSize(new Dimension(this.dialogWidth, 0));
        topPanel.add((Component)sep, "South");
        return topPanel;
    }

    private JPanel createLabelsPanel(boolean showPublisher) {
        BlockedException be;
        String errorComponent;
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel labelsPanel = new JPanel();
        labelsPanel.setLayout(gb);
        labelsPanel.setBorder(BorderFactory.createEmptyBorder());
        String nameMessage = this.mixedJsToJava ? this.getMessage("security.dialog.nativemixcode.js.appLabelStr") : this.getMessage("dialog.template.name");
        JLabel nameLbl = new JLabel(nameMessage);
        Font bold = nameLbl.getFont().deriveFont(1);
        Font plain = nameLbl.getFont().deriveFont(0);
        nameLbl.setFont(bold);
        JLabel publisherLbl = new JLabel(this.getMessage("dialog.template.publisher"));
        publisherLbl.setFont(bold);
        String fromMessage = this.mixedJsToJava ? this.getMessage("security.dialog.mixcode.js.appLabelWebsite") : this.getMessage("deployment.ssv.location");
        JLabel fromLbl = new JLabel(fromMessage);
        fromLbl.setFont(bold);
        JLabel reasonLbl = new JLabel(this.getMessage("deployment.ssv.reason"));
        reasonLbl.setFont(bold);
        JLabel componentnLbl = new JLabel(this.getMessage("deployment.ssv.component"));
        componentnLbl.setFont(bold);
        this.nameInfo = new JLabel();
        this.publisherInfo = new JLabel();
        this.urlInfo = new JLabel();
        this.nameInfo.setFont(plain);
        this.publisherInfo.setFont(plain);
        this.urlInfo.setFont(plain);
        this.nameInfo.putClientProperty("html.disable", Boolean.TRUE);
        this.publisherInfo.putClientProperty("html.disable", Boolean.TRUE);
        this.urlInfo.putClientProperty("html.disable", Boolean.TRUE);
        if (!this.hideTitleAndPublisher && this.appTitle != null) {
            c.fill = 2;
            c.gridwidth = 1;
            c.anchor = 17;
            c.insets = new Insets(this.mixedJsToJava ? 12 : 0, 0, 0, 12);
            c.weightx = 0.0;
            gb.setConstraints(nameLbl, c);
            labelsPanel.add(nameLbl);
            c.insets = new Insets(this.mixedJsToJava ? 12 : 0, 0, 0, 12);
            c.gridx = -1;
            c.gridwidth = 0;
            c.weightx = 1.0;
            gb.setConstraints(this.nameInfo, c);
            labelsPanel.add(this.nameInfo);
        }
        if (!this.hideTitleAndPublisher && showPublisher && this.appPublisher != null) {
            c.fill = 2;
            c.insets = new Insets(this.mixedJsToJava ? 0 : 12, 0, 0, 12);
            c.gridwidth = 1;
            c.weightx = 0.0;
            c.anchor = 17;
            gb.setConstraints(publisherLbl, c);
            labelsPanel.add(publisherLbl);
            c.insets = new Insets(this.mixedJsToJava ? 0 : 12, 0, 0, 12);
            c.gridwidth = 0;
            c.weightx = 1.0;
            gb.setConstraints(this.publisherInfo, c);
            labelsPanel.add(this.publisherInfo);
        }
        if (this.appTitle != null && this.appURL != null) {
            c.fill = 2;
            c.weightx = 0.0;
            c.gridwidth = 1;
            c.anchor = 17;
            c.insets = new Insets(this.mixedJsToJava ? 0 : 12, 0, 0, 12);
            gb.setConstraints(fromLbl, c);
            if (this.mixedJsToJava) {
                labelsPanel.add((Component)fromLbl, 0);
            } else {
                labelsPanel.add(fromLbl);
            }
            c.insets = new Insets(this.mixedJsToJava ? 0 : 12, 0, 0, 12);
            c.gridwidth = 0;
            c.weightx = 1.0;
            gb.setConstraints(this.urlInfo, c);
            if (this.mixedJsToJava) {
                labelsPanel.add((Component)this.urlInfo, 1);
            } else {
                labelsPanel.add(this.urlInfo);
            }
        }
        if ((errorComponent = this.getErrorComponent()) != null) {
            JLabel componentInfo = new JLabel();
            componentInfo.setFont(plain);
            componentInfo.putClientProperty("html.disable", Boolean.TRUE);
            c.fill = 2;
            c.weightx = 0.0;
            c.gridwidth = 1;
            c.anchor = 18;
            c.insets = new Insets(12, 0, 0, 12);
            gb.setConstraints(componentnLbl, c);
            labelsPanel.add(componentnLbl);
            c.insets = new Insets(12, 0, 0, 12);
            c.gridwidth = 0;
            c.weightx = 1.0;
            c.weighty = 1.0;
            gb.setConstraints(componentInfo, c);
            componentInfo.setText(errorComponent);
            labelsPanel.add(componentInfo);
        }
        int reasonWidth = 462 - reasonLbl.getWidth();
        JSmartTextArea reasonInfo = new JSmartTextArea(plain.getSize(), reasonWidth, false);
        FontMetrics fm = reasonInfo.getFontMetrics(plain);
        String reasonString = this.getReasonString();
        if (reasonString != null) {
            c.fill = 2;
            c.insets = new Insets(this.mixedJsToJava ? 0 : 12, 0, 0, 12);
            c.gridwidth = 1;
            c.weightx = 0.0;
            c.anchor = 17;
            gb.setConstraints(reasonLbl, c);
            labelsPanel.add(reasonLbl);
            c.insets = new Insets(this.mixedJsToJava ? 0 : 12, 0, 0, 12);
            c.gridwidth = 0;
            c.weightx = 1.0;
            c.weighty = 1.0;
            ((JTextComponent)reasonInfo).setText(reasonString);
            reasonInfo.setSize(((JTextArea)reasonInfo).getPreferredSize());
            gb.setConstraints(reasonInfo, c);
            labelsPanel.add(reasonInfo);
        }
        if (this.throwable instanceof BlockedException && (be = (BlockedException)this.throwable).getCause() instanceof CertificateRevokedException) {
            JLabel dummyLbl = new JLabel("");
            dummyLbl.setFont(bold);
            c.fill = 2;
            c.weightx = 0.0;
            c.gridwidth = 1;
            c.anchor = 18;
            c.insets = new Insets(12, 0, 0, 12);
            gb.setConstraints(dummyLbl, c);
            labelsPanel.add(dummyLbl);
            JPanel moreInfoPanel = new JPanel();
            moreInfoPanel.setLayout(new BorderLayout());
            FancyButton moreInfoButton = null;
            String key = "dialog.template.more.info2";
            moreInfoButton = new FancyButton(this.getMessage(key), ResourceManager.getMnemonic(key));
            moreInfoButton.setFont(plain);
            moreInfoButton.setOpaque(false);
            moreInfoButton.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent me) {
                    if (me.getComponent() instanceof FancyButton) {
                        DialogTemplate.this.showMoreInfo();
                    }
                }

                @Override
                public void mousePressed(MouseEvent me) {
                }

                @Override
                public void mouseReleased(MouseEvent me) {
                }

                @Override
                public void mouseEntered(MouseEvent me) {
                }

                @Override
                public void mouseExited(MouseEvent me) {
                }
            });
            moreInfoButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    DialogTemplate.this.showMoreInfo();
                }
            });
            c.insets = new Insets(12, 0, 0, 12);
            c.gridwidth = 0;
            c.weightx = 1.0;
            c.weighty = 1.0;
            gb.setConstraints(moreInfoPanel, c);
            moreInfoPanel.setOpaque(false);
            moreInfoPanel.add((Component)moreInfoButton, "West");
            labelsPanel.add(moreInfoPanel);
        }
        this.addedSpace = fm.getHeight() * (fm.stringWidth(reasonInfo.getText()) / reasonWidth);
        this.setInfo(this.ainfo);
        return labelsPanel;
    }

    private JPanel createCenterPanel(boolean checkAlways, String okBtnStr, String cancelBtnStr, int progress, boolean showPublisher) {
        boolean showProgress;
        Font f = ResourceManager.getUIFont();
        int newFontSize = DialogTemplate.getSubpanelFontSize();
        Font smallerFont = f.deriveFont(f.getStyle(), newFontSize);
        this.centerPanel = new JPanel();
        this.centerPanel.setLayout(new BoxLayout(this.centerPanel, 1));
        this.centerPanel.setBorder(BorderFactory.createEmptyBorder(24, 24, 12, 12));
        JPanel labelsPanel = this.createLabelsPanel(showPublisher);
        JPanel checkboxPanel = new JPanel();
        checkboxPanel.setLayout(new FlowLayout(3, 0, 0));
        JPanel mixedcodePanel = new JPanel();
        mixedcodePanel.setLayout(new BoxLayout(mixedcodePanel, 1));
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BorderLayout());
        JLabel label = new JLabel();
        final Font bold = label.getFont().deriveFont(1);
        final Font plain = label.getFont().deriveFont(0);
        if (this.alwaysString != null) {
            this.always = new JCheckBox(this.alwaysString);
            this.always.setMnemonic(ResourceManager.getMnemonic("security.dialog.always"));
            this.always.setSelected(checkAlways);
            this.always.setFont(plain);
            int left = this.always.getBorder().getBorderInsets((Component)this.always).left;
            labelsPanel.setBorder(BorderFactory.createEmptyBorder(0, left, 0, 0));
            checkboxPanel.add(this.always);
            checkboxPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 12, 0));
        }
        if (this.mixedCodeString != null) {
            JPanel mixedCodeLabelPanel = new JPanel();
            mixedCodeLabelPanel.setLayout(new FlowLayout());
            this.mixedCodeLabel = new JLabel(this.mixedCodeString);
            this.mixedCodeLabel.setFont(plain);
            mixedCodeLabelPanel.add(this.mixedCodeLabel);
            JPanel moreinfoPanel = new JPanel();
            moreinfoPanel.setLayout(new BorderLayout());
            FancyButton moreInfoButton = null;
            String key = "dialog.template.more.info";
            moreInfoButton = new FancyButton(this.getMessage(key), ResourceManager.getMnemonic(key));
            Font newFont = f.deriveFont((float)newFontSize);
            moreInfoButton.setFont(newFont);
            moreInfoButton.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent me) {
                    if (me.getComponent() instanceof FancyButton) {
                        DialogTemplate.this.showMixedcodeMoreInfo();
                    }
                }

                @Override
                public void mousePressed(MouseEvent me) {
                }

                @Override
                public void mouseReleased(MouseEvent me) {
                }

                @Override
                public void mouseEntered(MouseEvent me) {
                }

                @Override
                public void mouseExited(MouseEvent me) {
                }
            });
            moreInfoButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    DialogTemplate.this.showMixedcodeMoreInfo();
                }
            });
            moreinfoPanel.add((Component)moreInfoButton, "West");
            mixedcodePanel.add(mixedCodeLabelPanel);
            if (this.alwaysString != null) {
                mixedcodePanel.add(Box.createVerticalStrut(12));
                mixedcodePanel.add(checkboxPanel);
                mixedcodePanel.add(Box.createVerticalStrut(12));
            }
            mixedcodePanel.add(moreinfoPanel);
        }
        boolean bl = showProgress = progress >= 0;
        if (showProgress) {
            this.progressBar = new JProgressBar(0, 100);
            this.progressBar.setVisible(progress <= 100);
        }
        if (this.isBlockedDialog) {
            int preferredWidth = 474;
            UITextArea text = new UITextArea(plain.getSize(), 474, false);
            text.setFont(plain);
            text.setText(this.contentString);
            text.setSize(text.getPreferredSize());
            JEditorPane link = new JEditorPane(){

                @Override
                public Dimension getPreferredSize() {
                    JEditorPane dummyEditorPane = new JEditorPane();
                    dummyEditorPane.setEditorKit(new PromptEditorKit(plain, bold, false));
                    dummyEditorPane.setSize(474, Short.MAX_VALUE);
                    dummyEditorPane.setText(this.getText());
                    int height = dummyEditorPane.getPreferredSize().height;
                    return new Dimension(474, height);
                }
            };
            link.setOpaque(false);
            link.setFont(plain);
            link.setEditable(false);
            link.setEditorKit(new PromptEditorKit(plain, bold, false));
            link.setContentType("text/html");
            String hyperlinkText = this.getMessage("deployment.blocked.moreinfo.hyperlink.text");
            String url = this.getMessage("deployment.blocked.moreinfo.hyperlink.url");
            link.setText("<A HREF=\"" + url + "\">" + hyperlinkText + "</A>");
            link.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        Platform.get().showDocument(e.getURL().toString());
                    }
                }
            });
            contentPanel.add((Component)text, "North");
            contentPanel.add((Component)link, "South");
        } else if (this.isDeprecationDialog) {
            int preferredWidth = 474;
            JEditorPane link = new JEditorPane(){

                @Override
                public Dimension getPreferredSize() {
                    JEditorPane dummyEditorPane = new JEditorPane();
                    dummyEditorPane.setEditorKit(new PromptEditorKit(plain, bold, false));
                    dummyEditorPane.setSize(474, Short.MAX_VALUE);
                    dummyEditorPane.setText(this.getText());
                    int height = dummyEditorPane.getPreferredSize().height;
                    return new Dimension(474, height);
                }
            };
            String hyperlinkText = this.getMessage("deprecated.plugin.dialog.moreinfo.text");
            String url = this.getMessage("deprecated.plugin.dialog.moreinfo.url");
            link.setOpaque(false);
            link.setFont(plain);
            link.setEditable(false);
            link.setEditorKit(new PromptEditorKit(plain, bold, false));
            link.setContentType("text/html");
            link.setText(this.contentString + " <A HREF=\"" + url + "\">" + hyperlinkText + "</A>");
            link.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        Platform.get().showDocument(e.getURL().toString());
                    }
                }
            });
            contentPanel.add((Component)link, "North");
        } else if (this.contentString != null && this.throwable == null) {
            if (this.contentLabel != null) {
                JPanel top = new JPanel(new BorderLayout());
                top.add((Component)new JLabel(this.contentLabel), "West");
                contentPanel.add((Component)top, "North");
            }
            if (this.contentScroll) {
                final boolean limitWidth = this.largeScroll;
                JTextArea text = this.largeScroll ? new JTextArea(this.contentString, 20, 80) : new JTextArea(this.contentString, 4, 40);
                text.setEditable(false);
                JScrollPane sp = new JScrollPane(text, 20, 30){

                    @Override
                    public Dimension getPreferredSize() {
                        Dimension ret = super.getPreferredSize();
                        if (limitWidth) {
                            ret.width = Math.min(ret.width, 600);
                        }
                        return ret;
                    }
                };
                contentPanel.add((Component)sp, "Center");
            } else {
                UITextArea ta = new UITextArea(this.contentString);
                ta.setSize(ta.getPreferredSize());
                contentPanel.add((Component)ta, "Center");
            }
            contentPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 12, 0));
        }
        if (this.scrollList != null) {
            if (this.contentLabel != null) {
                JPanel top = new JPanel(new BorderLayout());
                top.add((Component)new JLabel(this.contentLabel), "West");
                contentPanel.add((Component)top, "North");
            }
            if (this.contentScroll) {
                JScrollPane sp = new JScrollPane(this.scrollList, 20, 30);
                contentPanel.add((Component)sp, "Center");
            }
            if (this.showDetails) {
                String key = "security.more.info.details";
                FancyButton certDetails = new FancyButton(this.getMessage(key), ResourceManager.getMnemonic(key));
                certDetails.setFont(smallerFont);
                certDetails.addMouseListener(new MouseListener(){

                    @Override
                    public void mouseClicked(MouseEvent me) {
                        if (me.getComponent() instanceof FancyButton) {
                            DialogTemplate.this.showCertificateDetails();
                        }
                    }

                    @Override
                    public void mousePressed(MouseEvent me) {
                    }

                    @Override
                    public void mouseReleased(MouseEvent me) {
                    }

                    @Override
                    public void mouseEntered(MouseEvent me) {
                    }

                    @Override
                    public void mouseExited(MouseEvent me) {
                    }
                });
                JPanel certDetailsPanel = new JPanel();
                certDetailsPanel.setBorder(BorderFactory.createEmptyBorder(12, 0, 12, 0));
                certDetailsPanel.setLayout(new FlowLayout(4, 0, 0));
                certDetailsPanel.add(certDetails);
                certDetailsPanel.add(Box.createGlue());
                contentPanel.add((Component)certDetailsPanel, "South");
            }
        }
        JPanel buttonsPanel = this.createButtonsPanel(okBtnStr, cancelBtnStr);
        if (this.cacheUpgradeContentString != null) {
            UITextArea cacheUpgradeContentTa = new UITextArea(this.cacheUpgradeContentString);
            cacheUpgradeContentTa.setBorder(null);
            contentPanel.add((Component)cacheUpgradeContentTa, "North");
            this.centerPanel.add(contentPanel);
            this.centerPanel.add(Box.createVerticalStrut(12));
        } else if (this.isBlockedDialog) {
            if (this.contentString != null || this.scrollList != null) {
                this.centerPanel.add(contentPanel);
                this.centerPanel.add(Box.createVerticalStrut(24));
            }
            if (this.includeAppInfo) {
                this.centerPanel.add(labelsPanel);
                this.centerPanel.add(Box.createVerticalStrut(12));
            }
            if (this.alwaysString != null) {
                this.centerPanel.add(checkboxPanel);
            }
            if (this.mixedCodeString != null) {
                this.centerPanel.add(mixedcodePanel);
            }
        } else {
            if (this.includeAppInfo) {
                this.centerPanel.add(labelsPanel);
                this.centerPanel.add(Box.createVerticalStrut(12));
            }
            if (this.contentString != null || this.scrollList != null) {
                this.centerPanel.add(contentPanel);
                this.centerPanel.add(Box.createVerticalStrut(24));
            }
            if (this.mixedCodeString != null) {
                this.centerPanel.add(mixedcodePanel);
            } else if (this.alwaysString != null) {
                this.centerPanel.add(checkboxPanel);
            }
        }
        JPanel progressStatusPanel = new JPanel(new BorderLayout());
        this.centerPanel.add(progressStatusPanel);
        JPanel bottomPanel = new JPanel(new BorderLayout());
        if (showProgress) {
            this.progressStatusLabel = new JLabel(" ");
            this.progressStatusLabel.setFont(smallerFont);
            progressStatusPanel.add((Component)this.progressStatusLabel, "West");
            this.progressBar.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
            bottomPanel.add((Component)this.progressBar, "Center");
        }
        bottomPanel.add((Component)buttonsPanel, "East");
        this.centerPanel.add(bottomPanel);
        if (this.isBlockedDialog) {
            this.centerPanel.add(Box.createVerticalStrut(this.addedSpace));
        }
        this.setCancelAction();
        return this.centerPanel;
    }

    private JPanel createBottomPanel(boolean showMoreInfo) {
        this.bottomPanel = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        this.bottomPanel.setLayout(gb);
        if (this.alertStrs != null || this.infoStrs != null) {
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            c.gridwidth = 0;
            JSeparator sep = new JSeparator();
            sep.setPreferredSize(new Dimension(510, 1));
            gb.setConstraints(sep, c);
            this.bottomPanel.add(sep);
            this.securityIcon = new JLabel();
            String imageFile = "security_high.png";
            if (this.alertStrs == null || this.alertStrs.length == 0) {
                imageFile = "security_low.png";
                if (this.always != null) {
                    this.always.setSelected(true);
                }
            } else if (this.mixedCodeString == null) {
                this.dialog.getRootPane().setDefaultButton(this.cancelBtn);
            }
            this.securityIcon.setIcon(ResourceManager.getIconResource(imageFile));
            c.insets = new Insets(12, 12, 12, 20);
            c.gridy = 1;
            c.gridwidth = 1;
            gb.setConstraints(this.securityIcon, c);
            this.bottomPanel.add(this.securityIcon);
            Font f = ResourceManager.getUIFont();
            int newFontSize = DialogTemplate.getSubpanelFontSize();
            int moreInfoLength = 0;
            FancyButton moreInfoLbl = null;
            if (showMoreInfo) {
                String key = "dialog.template.more.info";
                moreInfoLbl = new FancyButton(this.getMessage(key), ResourceManager.getMnemonic(key));
                Font newFont = f.deriveFont((float)newFontSize);
                moreInfoLbl.setFont(newFont);
                moreInfoLbl.addMouseListener(new MouseListener(){

                    @Override
                    public void mouseClicked(MouseEvent me) {
                        if (me.getComponent() instanceof FancyButton) {
                            DialogTemplate.this.showMoreInfo();
                        }
                    }

                    @Override
                    public void mousePressed(MouseEvent me) {
                    }

                    @Override
                    public void mouseReleased(MouseEvent me) {
                    }

                    @Override
                    public void mouseEntered(MouseEvent me) {
                    }

                    @Override
                    public void mouseExited(MouseEvent me) {
                    }
                });
                moreInfoLbl.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        if (DialogTemplate.this.mixedCodeString != null) {
                            DialogTemplate.this.showMixedcodeMoreInfo();
                        } else {
                            DialogTemplate.this.showMoreInfo();
                        }
                    }
                });
                moreInfoLength = moreInfoLbl.getPreferredSize().width + moreInfoLbl.getInsets().left + moreInfoLbl.getInsets().right;
            }
            int textAreaWidth = 486 - this.securityIcon.getPreferredSize().width - 20 - 6 - moreInfoLength - 8;
            UITextArea bulletText = new UITextArea(newFontSize, textAreaWidth, false);
            Font plain = bulletText.getFont().deriveFont(0);
            bulletText.setFont(plain);
            if ((this.alertStrs == null || this.alertStrs.length == 0) && this.infoStrs != null && this.infoStrs.length != 0) {
                bulletText.setText(this.infoStrs[0] != null ? this.infoStrs[0] : " ");
                bulletText.setSize(bulletText.getPreferredSize());
                if (this.infoStrs.length > 1) {
                    String[] newInfoStrs = new String[this.infoStrs.length - 1];
                    for (int i = 0; i < newInfoStrs.length; ++i) {
                        newInfoStrs[i] = this.infoStrs[i + 1];
                    }
                    this.infoStrs = newInfoStrs;
                } else {
                    this.infoStrs = null;
                }
            } else if (this.alertStrs != null && this.alertStrs.length != 0) {
                bulletText.setText(this.alertStrs[0] != null ? this.alertStrs[0] : " ");
                bulletText.setSize(bulletText.getPreferredSize());
                this.consumeAlertString0();
            }
            c.gridwidth = -1;
            c.insets = new Insets(12, 0, 12, 6);
            c.weightx = 0.0;
            gb.setConstraints(bulletText, c);
            this.bottomPanel.add(bulletText);
            c.insets = new Insets(12, 0, 12, 12);
            c.gridwidth = 0;
            if (moreInfoLbl != null) {
                c.gridx = 22;
                gb.setConstraints(moreInfoLbl, c);
                this.bottomPanel.add(moreInfoLbl);
            }
        } else {
            this.bottomPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 2, 0));
        }
        return this.bottomPanel;
    }

    JPanel createButtonsPanel(String okBtnStr, String cancelBtnStr) {
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new FlowLayout(4, 0, 0));
        this.okBtn = new JButton(okBtnStr == null ? "" : this.getMessage(okBtnStr));
        this.okBtn.setMnemonic(ResourceManager.getMnemonic(okBtnStr));
        this.okBtn.addActionListener(this);
        this.okBtn.setActionCommand("OK");
        buttonsPanel.add(this.okBtn);
        this.okBtn.setVisible(okBtnStr != null);
        this.cancelBtn = new JButton(cancelBtnStr == null ? "" : this.getMessage(cancelBtnStr));
        this.cancelBtn.addActionListener(this);
        buttonsPanel.add(Box.createHorizontalStrut(6));
        buttonsPanel.add(this.cancelBtn);
        this.cancelBtn.setVisible(cancelBtnStr != null);
        if (this.defaultButton == 0) {
            this.dialog.getRootPane().setDefaultButton(this.okBtn);
            this.okBtn.requestFocusInWindow();
        } else if (this.cancelBtn.isVisible()) {
            this.dialog.getRootPane().setDefaultButton(this.cancelBtn);
            this.cancelBtn.requestFocusInWindow();
        }
        this.setCancelAction();
        JButton[] buttons = new JButton[]{this.okBtn, this.cancelBtn};
        DialogTemplate.resizeButtons(buttons);
        return buttonsPanel;
    }

    private void setCancelAction() {
        this.setCancelAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTemplate.this.cancelAction();
            }
        });
    }

    public void setCancelAction(AbstractAction cancelAction) {
        if (this.dialog != null) {
            this.dialog.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "cancel");
            this.dialog.getRootPane().getActionMap().put("cancel", cancelAction);
        }
    }

    private void ssvSetFonts() {
        if (ssvFont == null) {
            int size;
            JLabel label = new JLabel();
            int small = size = ResourceManager.getUIFont().getSize();
            int medium = size + 2;
            int big = size + 4;
            ssvSmallFont = label.getFont().deriveFont(0, small);
            ssvSmallBoldFont = label.getFont().deriveFont(1, small);
            ssvFont = label.getFont().deriveFont(0, medium);
            ssvBold = label.getFont().deriveFont(1, medium);
            ssvBigFont = label.getFont().deriveFont(0, big);
            ssvBigBoldFont = label.getFont().deriveFont(1, big);
        }
    }

    static JPanel createShadedContentBorderPanel(final boolean roundedBorders) {
        JPanel contentPanel = new JPanel(){

            @Override
            protected void paintComponent(Graphics grphcs) {
                Color backGradColorStart = new Color(240, 240, 240);
                Color backGradColorEnd = new Color(200, 200, 200);
                Graphics2D g2d = (Graphics2D)grphcs;
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                GradientPaint gp = new GradientPaint(0.0f, 0.0f, backGradColorStart, 0.0f, 4 * this.getHeight() / 7, backGradColorEnd, false);
                g2d.setPaint(gp);
                Insets in = this.getInsets();
                g2d.fillRect(in.left, in.top, this.getWidth() - in.left - in.right, this.getHeight() - in.top - in.bottom);
                super.paintComponent(grphcs);
            }

            @Override
            protected void paintBorder(Graphics grphcs) {
                if (roundedBorders) {
                    Graphics2D g2d = (Graphics2D)grphcs;
                    g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g2d.setColor(new Color(116, 116, 116));
                    g2d.drawRoundRect(0, 0, this.getWidth() - 2, this.getHeight() - 2, 20, 20);
                }
                super.paintBorder(grphcs);
            }
        };
        return contentPanel;
    }

    private JPanel createShadedContentPanel() {
        JPanel contentPanel = new JPanel(){

            @Override
            protected void paintComponent(Graphics grphcs) {
                Color backGradColorStart = new Color(240, 240, 240);
                Color backGradColorEnd = new Color(200, 200, 200);
                Graphics2D g2d = (Graphics2D)grphcs;
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                GradientPaint gp = new GradientPaint(0.0f, 0.0f, backGradColorStart, 0.0f, 4 * this.getHeight() / 7, backGradColorEnd, false);
                g2d.setPaint(gp);
                Insets in = this.getInsets();
                g2d.fillRect(in.left, in.top, this.getWidth() - in.left - in.right, this.getHeight() - in.top - in.bottom);
                super.paintComponent(grphcs);
            }
        };
        return contentPanel;
    }

    private JPanel createMessageClosePanel(JLabel messageLabel) {
        JPanel messageClosePanel = new JPanel(new BorderLayout());
        messageClosePanel.setOpaque(false);
        messageClosePanel.setBorder(BorderFactory.createEmptyBorder());
        ImageIcon closeIcon = ResourceManager.getIcon("close_box_normal.image");
        JButton closeBox = new JButton(closeIcon);
        closeBox.setOpaque(false);
        closeBox.setEnabled(true);
        closeBox.setContentAreaFilled(false);
        closeBox.setBorderPainted(false);
        closeBox.setPreferredSize(new Dimension(10, 10));
        closeBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTemplate.this.cancelAction();
            }
        });
        JPanel closePanel = new JPanel(new BorderLayout());
        closePanel.setOpaque(false);
        closePanel.add((Component)closeBox, "East");
        JPanel labelPanel = new JPanel(new BorderLayout());
        labelPanel.setOpaque(false);
        labelPanel.setPreferredSize(new Dimension(300, 20));
        labelPanel.add((Component)messageLabel, "West");
        messageClosePanel.add((Component)closePanel, "North");
        messageClosePanel.add((Component)labelPanel, "Center");
        return messageClosePanel;
    }

    private JPanel createSecurityTopPanel(boolean https) {
        JPanel messagePanel;
        JPanel top = new JPanel(new BorderLayout());
        top.setOpaque(false);
        JLabel messageLabel = new JLabel(this.topText);
        messageLabel.setOpaque(false);
        if (https) {
            messagePanel = new JPanel(new BorderLayout());
            messagePanel.setOpaque(false);
            JLabel continueLabel = new JLabel(this.getMessage("dialog.template.continue"));
            continueLabel.setOpaque(false);
            continueLabel.setFont(ssvBigBoldFont);
            messageLabel.setFont(ssvFont);
            messagePanel.add((Component)continueLabel, "North");
            messagePanel.add((Component)messageLabel, "South");
            top.setBorder(BorderFactory.createEmptyBorder(16, 16, 0, 16));
            top.add((Component)messagePanel, "North");
        } else {
            messageLabel.setFont(ssvBigBoldFont);
            if (this.alertStrs == null) {
                top.setBorder(BorderFactory.createEmptyBorder(8, 16, 0, 8));
                messagePanel = this.createMessageClosePanel(messageLabel);
                top.add((Component)messagePanel, "North");
            } else {
                top.setBorder(BorderFactory.createEmptyBorder(16, 16, 0, 16));
                top.add((Component)messageLabel, "North");
            }
        }
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel labelsPanel = new JPanel();
        labelsPanel.setOpaque(false);
        labelsPanel.setLayout(gb);
        labelsPanel.setBorder(BorderFactory.createEmptyBorder());
        JLabel nameLbl = new JLabel(this.getMessage("dialog.template.name"));
        nameLbl.setFont(ssvSmallBoldFont);
        nameLbl.setOpaque(false);
        JLabel publisherLbl = new JLabel(this.getMessage("dialog.template.publisher"));
        publisherLbl.setFont(ssvSmallBoldFont);
        publisherLbl.setOpaque(false);
        String msg = https ? this.getMessage(this.ainfo.isMultiHost() ? "dialog.template.website.multihost" : "dialog.template.website") : this.getMessage(this.ainfo.isMultiHost() ? "deployment.ssv.location.multihost" : "deployment.ssv.location");
        JLabel fromLbl = new JLabel(msg);
        fromLbl.setFont(ssvSmallBoldFont);
        fromLbl.setOpaque(false);
        this.nameInfo = new JLabel();
        this.publisherInfo = new JLabel();
        this.urlInfo = new JLabel();
        this.nameInfo.setFont(ssvBigBoldFont);
        this.publisherInfo.setFont(ssvSmallFont);
        this.urlInfo.setFont(ssvSmallFont);
        this.nameInfo.putClientProperty("html.disable", Boolean.TRUE);
        this.publisherInfo.putClientProperty("html.disable", Boolean.TRUE);
        this.urlInfo.putClientProperty("html.disable", Boolean.TRUE);
        if (this.ainfo.shouldDisplayMainJNLP()) {
            this.originInfo = new JLabel();
            this.originInfo.setFont(ssvSmallFont);
            this.originInfo.putClientProperty("html.disable", Boolean.TRUE);
        }
        if (this.ainfo.shouldDisplayDocumentBase()) {
            this.appletLocationInfo = new JLabel();
            this.appletLocationInfo.setFont(ssvSmallFont);
            this.appletLocationInfo.putClientProperty("html.disable", Boolean.TRUE);
        }
        c.fill = 2;
        c.gridwidth = 1;
        c.anchor = 17;
        c.insets = new Insets(0, 32, 0, 12);
        c.weightx = 0.0;
        if (this.appTitle != null && this.appTitle.length() > 0 && !https) {
            gb.setConstraints(nameLbl, c);
            labelsPanel.add(nameLbl);
            c.insets = new Insets(0, 0, 0, 12);
            c.gridx = -1;
            c.gridwidth = 0;
            c.weightx = 1.0;
            gb.setConstraints(this.nameInfo, c);
            labelsPanel.add(this.nameInfo);
        }
        if (this.appPublisher != null && !https) {
            c.fill = 2;
            c.insets = new Insets(12, 32, 0, 12);
            c.gridwidth = 1;
            c.weightx = 0.0;
            c.anchor = 17;
            gb.setConstraints(publisherLbl, c);
            labelsPanel.add(publisherLbl);
            c.insets = new Insets(12, 0, 0, 12);
            c.gridwidth = 0;
            c.weightx = 1.0;
            gb.setConstraints(this.publisherInfo, c);
            labelsPanel.add(this.publisherInfo);
        }
        if (this.appURL != null) {
            Component glue;
            c.fill = 2;
            c.weightx = 0.0;
            c.gridwidth = 1;
            c.anchor = 17;
            c.insets = new Insets(12, 32, 0, 12);
            gb.setConstraints(fromLbl, c);
            labelsPanel.add(fromLbl);
            c.insets = new Insets(12, 0, 0, 12);
            c.gridwidth = 0;
            c.weightx = 1.0;
            gb.setConstraints(this.urlInfo, c);
            labelsPanel.add(this.urlInfo);
            if (this.originInfo != null) {
                c.fill = 2;
                c.weightx = 0.0;
                c.gridwidth = 1;
                c.anchor = 17;
                c.insets = new Insets(6, 32, 0, 12);
                glue = Box.createGlue();
                gb.setConstraints(glue, c);
                labelsPanel.add(glue);
                c.insets = new Insets(6, 0, 0, 12);
                c.gridwidth = 0;
                c.weightx = 1.0;
                gb.setConstraints(this.originInfo, c);
                labelsPanel.add(this.originInfo);
            }
            if (this.appletLocationInfo != null) {
                c.fill = 2;
                c.weightx = 0.0;
                c.gridwidth = 1;
                c.anchor = 17;
                c.insets = new Insets(6, 32, 0, 12);
                glue = Box.createGlue();
                gb.setConstraints(glue, c);
                labelsPanel.add(glue);
                c.insets = new Insets(6, 0, 0, 12);
                c.gridwidth = 0;
                c.weightx = 1.0;
                gb.setConstraints(this.appletLocationInfo, c);
                labelsPanel.add(this.appletLocationInfo);
            }
        }
        this.setInfo(this.ainfo);
        JLabel warningIcon = new JLabel();
        warningIcon.setOpaque(false);
        if (this.alertStrs != null) {
            warningIcon.setIcon(ResourceManager.getIcon("warning48s.image"));
        } else {
            warningIcon.setIcon(ResourceManager.getIcon("java48s.image"));
        }
        warningIcon.setBorder(BorderFactory.createEmptyBorder(0, 32, 0, 0));
        JPanel iconTextPanel = new JPanel(new BorderLayout());
        iconTextPanel.setOpaque(false);
        iconTextPanel.add((Component)warningIcon, "West");
        iconTextPanel.add((Component)labelsPanel, "Center");
        iconTextPanel.setBorder(BorderFactory.createEmptyBorder(16, 0, 16, 0));
        top.add((Component)iconTextPanel, "South");
        return top;
    }

    private JPanel createSSVTopPanel(String message, String name, String url) {
        JPanel top = new JPanel(new BorderLayout());
        top.setOpaque(false);
        top.setBorder(BorderFactory.createEmptyBorder(16, 16, 0, 16));
        JLabel messageLabel = new JLabel(message);
        messageLabel.setOpaque(false);
        messageLabel.setFont(ssvBigBoldFont);
        messageLabel.setEnabled(true);
        top.add((Component)messageLabel, "North");
        JLabel nameLabel = new JLabel(this.getMessage("dialog.template.name"));
        nameLabel.setFont(ssvSmallBoldFont);
        nameLabel.setOpaque(false);
        nameLabel.setBorder(BorderFactory.createEmptyBorder(0, 16, 0, 16));
        JLabel fromLabel = new JLabel(this.getMessage("deployment.ssv.location"));
        fromLabel.setFont(ssvSmallBoldFont);
        fromLabel.setOpaque(false);
        fromLabel.setBorder(BorderFactory.createEmptyBorder(0, 16, 0, 16));
        this.nameInfo = new JLabel(name);
        this.nameInfo.setFont(ssvBigBoldFont);
        this.nameInfo.setOpaque(false);
        JLabel fromInfo = new JLabel(url);
        fromInfo.setFont(ssvSmallFont);
        fromInfo.setOpaque(false);
        JPanel[] parts = new JPanel[4];
        for (int i = 0; i < 4; ++i) {
            parts[i] = new JPanel(new BorderLayout());
            parts[i].setOpaque(false);
        }
        JLabel warningIcon = new JLabel();
        warningIcon.setOpaque(false);
        warningIcon.setIcon(ResourceManager.getIcon("warning48.image"));
        warningIcon.setBorder(BorderFactory.createEmptyBorder(0, 32, 0, 0));
        parts[2].add((Component)nameLabel, "North");
        parts[2].add((Component)fromLabel, "South");
        parts[2].setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        parts[3].add((Component)this.nameInfo, "North");
        parts[3].add((Component)fromInfo, "South");
        parts[1].add((Component)parts[2], "West");
        parts[1].add((Component)parts[3], "Center");
        parts[1].setBorder(BorderFactory.createEmptyBorder(12, 0, 12, 0));
        parts[0].add((Component)warningIcon, "West");
        parts[0].add((Component)parts[1], "Center");
        parts[0].setBorder(BorderFactory.createEmptyBorder(8, 0, 0, 0));
        top.add((Component)parts[0], "South");
        return top;
    }

    private JPanel createTrustSecurityRiskPanel(String message) {
        JPanel risk = new JPanel(new BorderLayout());
        risk.setOpaque(false);
        risk.setBorder(BorderFactory.createEmptyBorder(0, 16, 16, 16));
        JSmartTextArea ta = new JSmartTextArea(message);
        ta.setFont(ssvSmallFont);
        ta.setLineWrap(true);
        ta.setWrapStyleWord(true);
        ta.setOpaque(false);
        ta.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        risk.add((Component)ta, "North");
        return risk;
    }

    private JPanel createSecurityRiskPanel(String message, boolean selfSigned, boolean https) {
        JPanel risk = new JPanel(new BorderLayout());
        risk.setOpaque(false);
        risk.setBorder(BorderFactory.createEmptyBorder(0, 8, 8, 12));
        int index = message.indexOf(" ");
        if (index < message.length() - 2) {
            String riskLabelText = message.substring(0, index);
            String riskText = message.substring(index + 1);
            JPanel left = new JPanel(new BorderLayout());
            left.setOpaque(false);
            JLabel riskLabel = new JLabel(riskLabelText);
            riskLabel.setFont(ssvSmallBoldFont);
            riskLabel.setOpaque(false);
            left.add((Component)riskLabel, "North");
            left.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 8));
            JPanel right = new JPanel(new BorderLayout());
            right.setOpaque(false);
            JSmartTextArea ta = new JSmartTextArea(riskText);
            ta.setFont(ssvSmallFont);
            ta.setLineWrap(true);
            ta.setWrapStyleWord(true);
            ta.setOpaque(false);
            ta.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            right.add((Component)ta, "North");
            String key = "dialog.template.more.info2";
            FancyButton moreInfoLbl = new FancyButton(this.getMessage(key), ResourceManager.getMnemonic(key));
            moreInfoLbl.setOpaque(false);
            moreInfoLbl.setFont(ssvSmallFont);
            moreInfoLbl.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent me) {
                    if (me.getComponent() instanceof FancyButton) {
                        DialogTemplate.this.showMoreInfo();
                    }
                }

                @Override
                public void mousePressed(MouseEvent me) {
                }

                @Override
                public void mouseReleased(MouseEvent me) {
                }

                @Override
                public void mouseEntered(MouseEvent me) {
                }

                @Override
                public void mouseExited(MouseEvent me) {
                }
            });
            moreInfoLbl.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    DialogTemplate.this.showMoreInfo();
                }
            });
            JPanel moreInfoPanel = new JPanel(new BorderLayout());
            moreInfoPanel.setOpaque(false);
            moreInfoPanel.add((Component)moreInfoLbl, "West");
            right.add((Component)moreInfoPanel, "Center");
            if (!https) {
                String riskMessage = this.getMessage("dialog.security.risk.warning");
                String unknown = this.getMessage("security.dialog.notverified.subject");
                JSmartTextArea topWarning = new JSmartTextArea(riskMessage.replaceAll(unknown, unknown.toUpperCase()));
                topWarning.setFont(ssvBold);
                topWarning.setForeground(new Color(204, 0, 0));
                topWarning.setLineWrap(true);
                topWarning.setWrapStyleWord(true);
                topWarning.setOpaque(false);
                topWarning.setSize(480, Short.MAX_VALUE);
                Box innerBox = Box.createVerticalBox();
                innerBox.add(topWarning);
                innerBox.add(Box.createVerticalStrut(10));
                Box outerBox = Box.createHorizontalBox();
                outerBox.add(Box.createHorizontalStrut(8));
                outerBox.add(innerBox);
                risk.add((Component)outerBox, "North");
            }
            risk.add((Component)left, "West");
            risk.add((Component)right, "Center");
        }
        return risk;
    }

    private JPanel createSSVRiskPanel(String message, String moreInfoText, URL moreInfoURL) {
        JPanel risk = new JPanel(new BorderLayout());
        risk.setOpaque(false);
        risk.setBorder(BorderFactory.createEmptyBorder(8, 8, 0, 8));
        int index = message.indexOf(" ");
        if (index < message.length() - 2) {
            String riskLabelText = message.substring(0, index);
            String riskText = message.substring(index + 1);
            JPanel left = new JPanel(new BorderLayout());
            left.setOpaque(false);
            JLabel riskLabel = new JLabel(riskLabelText);
            riskLabel.setFont(ssvSmallBoldFont);
            riskLabel.setOpaque(false);
            left.add((Component)riskLabel, "North");
            left.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 8));
            JPanel right = new JPanel(new BorderLayout());
            right.setOpaque(false);
            LinkText link = new LinkText(riskText, moreInfoText, moreInfoURL);
            link.setFont(ssvSmallFont);
            link.setOpaque(false);
            right.add((Component)link, "Center");
            risk.add((Component)left, "West");
            risk.add((Component)right, "Center");
        }
        return risk;
    }

    private JPanel createTrustSecurityAlwaysPanel(boolean checkAlways) {
        JPanel alwaysPanel = new JPanel(new BorderLayout());
        alwaysPanel.setOpaque(false);
        alwaysPanel.setBorder(BorderFactory.createEmptyBorder(0, 16, 0, 16));
        this.always = new JCheckBox(this.alwaysString);
        this.always.setMnemonic(ResourceManager.getMnemonic("security.dialog.always"));
        this.always.setFont(ssvSmallFont);
        this.always.setOpaque(false);
        this.always.setSelected(checkAlways);
        alwaysPanel.add((Component)this.always, "North");
        return alwaysPanel;
    }

    private JPanel createSecurityAcceptPanel(String okBtnStr, String cancelBtnStr, boolean checkAlways) {
        JPanel acceptPanel = new JPanel(new BorderLayout());
        acceptPanel.setOpaque(false);
        acceptPanel.setBorder(BorderFactory.createEmptyBorder(0, 16, 0, 16));
        JPanel top = new JPanel(new BorderLayout());
        JPanel bot = new JPanel(new BorderLayout());
        top.setOpaque(false);
        bot.setOpaque(false);
        JLabel textLabel = new JLabel(this.acceptTitle);
        textLabel.setOpaque(false);
        textLabel.setFont(ssvSmallBoldFont);
        top.add((Component)textLabel, "Center");
        JCheckBox acceptCheckBox = new JCheckBox(this.acceptText);
        acceptCheckBox.setFont(ssvSmallFont);
        acceptCheckBox.setOpaque(false);
        acceptCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2) {
                    DialogTemplate.this.okBtn.setEnabled(false);
                    DialogTemplate.this.dialog.getRootPane().setDefaultButton(DialogTemplate.this.cancelBtn);
                    if (DialogTemplate.this.always != null) {
                        DialogTemplate.this.always.setSelected(false);
                        DialogTemplate.this.always.setEnabled(false);
                    }
                }
                if (e.getStateChange() == 1) {
                    DialogTemplate.this.okBtn.setEnabled(true);
                    DialogTemplate.this.dialog.getRootPane().setDefaultButton(DialogTemplate.this.okBtn);
                    if (DialogTemplate.this.always != null) {
                        DialogTemplate.this.always.setEnabled(true);
                    }
                }
            }
        });
        String key = "security.dialog.accept.text";
        acceptCheckBox.setMnemonic(ResourceManager.getMnemonic(key));
        acceptCheckBox.setSelected(checkAlways);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(4, 0, 0));
        buttonPanel.setOpaque(false);
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(8, 32, 8, 0));
        this.okBtn = new JButton(this.getMessage(okBtnStr));
        this.okBtn.setMnemonic(ResourceManager.getMnemonic(okBtnStr));
        this.okBtn.addActionListener(this);
        this.okBtn.setActionCommand("OK");
        this.okBtn.setOpaque(false);
        this.okBtn.setEnabled(false);
        buttonPanel.add(this.okBtn);
        this.cancelBtn = new JButton(cancelBtnStr);
        this.cancelBtn.addActionListener(this);
        this.cancelBtn.setOpaque(false);
        buttonPanel.add(Box.createHorizontalStrut(10));
        buttonPanel.add(this.cancelBtn);
        this.dialog.getRootPane().setDefaultButton(this.cancelBtn);
        acceptCheckBox.requestFocusInWindow();
        JButton[] buttons = new JButton[]{this.okBtn, this.cancelBtn};
        DialogTemplate.resizeButtons(buttons);
        bot.add((Component)acceptCheckBox, "West");
        bot.add((Component)buttonPanel, "East");
        bot.setBorder(BorderFactory.createEmptyBorder(0, 16, 0, 16));
        acceptPanel.add((Component)top, "North");
        acceptPanel.add((Component)bot, "South");
        this.setCancelAction();
        return acceptPanel;
    }

    private JPanel createTrustSecurityBottomPanel(String okBtnStr, String cancelBtnStr, boolean includeNativeSandboxWarning) {
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.setOpaque(false);
        bottomPanel.setBorder(BorderFactory.createEmptyBorder(16, 16, 16, 16));
        String key = "dialog.template.more.info2";
        FancyButton moreInfoLbl = new FancyButton(this.getMessage(key), ResourceManager.getMnemonic(key));
        moreInfoLbl.setOpaque(false);
        moreInfoLbl.setFont(ssvSmallFont);
        moreInfoLbl.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getComponent() instanceof FancyButton) {
                    DialogTemplate.this.showMoreInfo();
                }
            }

            @Override
            public void mousePressed(MouseEvent me) {
            }

            @Override
            public void mouseReleased(MouseEvent me) {
            }

            @Override
            public void mouseEntered(MouseEvent me) {
            }

            @Override
            public void mouseExited(MouseEvent me) {
            }
        });
        moreInfoLbl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                DialogTemplate.this.showMoreInfo();
            }
        });
        JPanel moreInfoPanel = new JPanel(new BorderLayout());
        moreInfoPanel.setOpaque(false);
        moreInfoPanel.add((Component)moreInfoLbl, "West");
        moreInfoPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        JLabel warningIcon = new JLabel();
        warningIcon.setOpaque(false);
        if (this.alertStrs != null) {
            warningIcon.setIcon(ResourceManager.getIcon("yellowShield.image"));
        } else {
            warningIcon.setIcon(ResourceManager.getIcon("blueShield.image"));
        }
        JPanel iconInfoPanel = new JPanel(new BorderLayout());
        iconInfoPanel.setOpaque(false);
        iconInfoPanel.add((Component)warningIcon, "West");
        iconInfoPanel.add((Component)moreInfoPanel, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(4, 0, 0));
        buttonPanel.setOpaque(false);
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(8, 0, 8, 0));
        this.okBtn = new JButton(this.getMessage(okBtnStr));
        this.okBtn.setMnemonic(ResourceManager.getMnemonic(okBtnStr));
        this.okBtn.addActionListener(this);
        this.okBtn.setActionCommand("OK");
        this.okBtn.setOpaque(false);
        buttonPanel.add(this.okBtn);
        this.cancelBtn = new JButton(cancelBtnStr);
        this.cancelBtn.addActionListener(this);
        this.cancelBtn.setOpaque(false);
        buttonPanel.add(Box.createHorizontalStrut(10));
        buttonPanel.add(this.cancelBtn);
        JButton[] buttons = new JButton[]{this.okBtn, this.cancelBtn};
        DialogTemplate.resizeButtons(buttons);
        if (includeNativeSandboxWarning) {
            HyperlinkListener hyperlinkListener = new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        MoreInfoDialog info = new MoreInfoDialog(DialogTemplate.this.dialog, DialogTemplate.this.alertStrs, DialogTemplate.this.infoStrs, DialogTemplate.this.securityInfoCount, DialogTemplate.this.certs, DialogTemplate.this.start, DialogTemplate.this.end, DialogTemplate.this.majorWarning, DialogTemplate.this.sandboxApp, true);
                        info.setVisible(true);
                    }
                }
            };
            JPanel yellowPanel = DialogTemplate.createYellowWarningPanel(this.getMessage("security.dialog.native.sandbox.warning"), hyperlinkListener, 300);
            JPanel warningPanel = new JPanel(new BorderLayout());
            warningPanel.setBorder(new EmptyBorder(0, 0, 0, 24));
            warningPanel.add(yellowPanel);
            warningPanel.setOpaque(false);
            bottomPanel.add((Component)warningPanel, "West");
        } else {
            bottomPanel.add((Component)iconInfoPanel, "West");
        }
        bottomPanel.add((Component)buttonPanel, "East");
        this.setCancelAction();
        return bottomPanel;
    }

    public static JPanel createYellowWarningPanel(String html, HyperlinkListener hyperlinkListener, final int preferredWidth) {
        JPanel warningPanel = DialogTemplate.createWarningPanel();
        warningPanel.setOpaque(false);
        warningPanel.setBackground(new Color(0xFFFCC4));
        JEditorPane text = new JEditorPane(){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(preferredWidth, this.getContentHeight(this.getText()));
            }

            private int getContentHeight(String content) {
                JEditorPane dummyEditorPane = new JEditorPane();
                dummyEditorPane.setEditorKit(new PromptEditorKit(ssvSmallFont, ssvSmallBoldFont, false));
                dummyEditorPane.setSize(preferredWidth, Short.MAX_VALUE);
                dummyEditorPane.setText(content);
                return dummyEditorPane.getPreferredSize().height;
            }
        };
        text.setOpaque(false);
        text.setEditable(false);
        text.setEditorKit(new PromptEditorKit(ssvSmallFont, ssvSmallBoldFont, false));
        text.setContentType("text/html");
        text.setText(html);
        text.addHyperlinkListener(hyperlinkListener);
        warningPanel.add((Component)text, "Center");
        return warningPanel;
    }

    private static JPanel createWarningPanel() {
        JPanel contentPanel = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Dimension arcs = new Dimension(10, 10);
                int width = this.getWidth();
                int height = this.getHeight();
                Graphics2D graphics = (Graphics2D)g;
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics.setColor(this.getBackground());
                graphics.fillRoundRect(0, 0, width - 1, height - 1, arcs.width, arcs.height);
                graphics.setColor(new Color(13943130));
                graphics.setStroke(new BasicStroke(2.0f));
                graphics.drawRoundRect(0, 0, width - 1, height - 1, arcs.width, arcs.height);
            }
        };
        return contentPanel;
    }

    private JPanel createSecurityBottomPanel(boolean https) {
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.setOpaque(false);
        bottomPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 16, 16));
        JPanel top = new JPanel(new BorderLayout());
        JPanel bot = new JPanel(new BorderLayout());
        top.setOpaque(false);
        bot.setOpaque(false);
        final String showStr = this.getMessage("security.dialog.show.options");
        final String hideStr = this.getMessage("security.dialog.hide.options");
        final ImageIcon iconUp = ResourceManager.getIcon("toggle_up2.image");
        final ImageIcon iconDown = ResourceManager.getIcon("toggle_down2.image");
        final JButton showBtn = new JButton(showStr, iconDown);
        showBtn.setOpaque(false);
        showBtn.setEnabled(true);
        showBtn.setContentAreaFilled(false);
        showBtn.setBorderPainted(false);
        String key = "security.dialog.show.options";
        showBtn.setMnemonic(ResourceManager.getMnemonic(key));
        top.add((Component)showBtn, "West");
        if (https) {
            key = "https.dialog.always";
            this.always = new JCheckBox(this.getMessage(key));
            this.always.setMnemonic(ResourceManager.getMnemonic(key));
            this.always.setVisible(false);
            this.always.setEnabled(true);
        } else {
            this.always = new JCheckBox(this.alwaysString);
            this.always.setMnemonic(ResourceManager.getMnemonic("security.dialog.always"));
            this.always.setVisible(false);
            this.always.setEnabled(false);
        }
        this.always.setFont(ssvSmallFont);
        this.always.setOpaque(false);
        this.always.setSelected(false);
        bot.add((Component)this.always, "West");
        bot.setBorder(BorderFactory.createEmptyBorder(0, 32, 0, 16));
        showBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String btnText = evt.getActionCommand();
                if (btnText.equals(showStr)) {
                    showBtn.setIcon(iconUp);
                    showBtn.setText(hideStr);
                    showBtn.setMnemonic(ResourceManager.getMnemonic("security.dialog.hide.options"));
                    DialogTemplate.this.always.setVisible(true);
                } else {
                    showBtn.setIcon(iconDown);
                    showBtn.setText(showStr);
                    showBtn.setMnemonic(ResourceManager.getMnemonic("security.dialog.show.options"));
                    DialogTemplate.this.always.setVisible(false);
                }
                DialogTemplate.this.dialog.pack();
                DialogTemplate.this.dialog.setResizable(false);
            }
        });
        bottomPanel.add((Component)top, "North");
        bottomPanel.add((Component)bot, "South");
        return bottomPanel;
    }

    private void consumeAlertString0() {
        if (this.alertStrs.length > 1) {
            String[] newAlertStrs = new String[this.alertStrs.length - 1];
            for (int i = 0; i < newAlertStrs.length; ++i) {
                newAlertStrs[i] = this.alertStrs[i + 1];
            }
            this.alertStrs = newAlertStrs;
        } else {
            this.alertStrs = null;
        }
    }

    private JPanel createPasswordPanel(String details, boolean showUserName, boolean showDomain, String userName, String domain, boolean saveEnabled, char[] sugPass, String scheme, String warning) {
        JLabel uNameLbl = new JLabel();
        JLabel domainLbl = new JLabel();
        Font plain = uNameLbl.getFont().deriveFont(0);
        Font bold = uNameLbl.getFont().deriveFont(1);
        JLabel banner = new JLabel();
        banner.setIcon(ResourceManager.getIcon("pwd-masthead.png"));
        if (showUserName) {
            String userNameKey = "password.dialog.username";
            uNameLbl.setText(this.getMessage(userNameKey));
            uNameLbl.setDisplayedMnemonic(ResourceManager.getMnemonic(userNameKey));
            this.pwdName = new JTextField();
            this.pwdName.setText(userName);
            uNameLbl.setLabelFor(this.pwdName);
            uNameLbl.setFont(bold);
        }
        String passwordKey = "password.dialog.password";
        JLabel passwordLbl = new JLabel(this.getMessage(passwordKey));
        this.password = new JPasswordField();
        this.password.setText(String.valueOf(sugPass));
        passwordLbl.setLabelFor(this.password);
        passwordLbl.setDisplayedMnemonic(ResourceManager.getMnemonic(passwordKey));
        passwordLbl.setFont(bold);
        if (showDomain) {
            String domainKey = "password.dialog.domain";
            domainLbl.setText(this.getMessage(domainKey));
            this.pwdDomain = new JTextField();
            this.pwdDomain.setText(domain);
            domainLbl.setLabelFor(this.pwdDomain);
            domainLbl.setDisplayedMnemonic(ResourceManager.getMnemonic(domainKey));
            domainLbl.setFont(bold);
        }
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel elementsPanel = new JPanel();
        elementsPanel.setLayout(gb);
        c.fill = 1;
        c.gridwidth = 0;
        gb.setConstraints(banner, c);
        elementsPanel.add(banner);
        JSeparator sep = new JSeparator();
        gb.setConstraints(sep, c);
        elementsPanel.add(sep);
        UITextArea detailsText = new UITextArea(uNameLbl.getFont().getSize(), banner.getPreferredSize().width - 24, false);
        detailsText.setFont(plain);
        detailsText.setText(details);
        Dimension pref = detailsText.getPreferredSize();
        detailsText.setSize(pref.width, pref.height);
        c.gridwidth = 0;
        c.insets = new Insets(12, 12, 0, 12);
        gb.setConstraints(detailsText, c);
        elementsPanel.add(detailsText);
        Insets labelInsets = new Insets(12, 12, 0, 6);
        Insets fieldInsets = new Insets(12, 0, 0, 12);
        c.gridwidth = 1;
        c.insets = labelInsets;
        if (showUserName) {
            gb.setConstraints(uNameLbl, c);
            elementsPanel.add(uNameLbl);
            c.gridwidth = 0;
            c.insets = fieldInsets;
            gb.setConstraints(this.pwdName, c);
            elementsPanel.add(this.pwdName);
        }
        c.gridwidth = 1;
        c.insets = labelInsets;
        gb.setConstraints(passwordLbl, c);
        elementsPanel.add(passwordLbl);
        c.gridwidth = 0;
        c.insets = fieldInsets;
        gb.setConstraints(this.password, c);
        elementsPanel.add(this.password);
        if (showDomain) {
            c.gridwidth = 1;
            c.insets = labelInsets;
            gb.setConstraints(domainLbl, c);
            elementsPanel.add(domainLbl);
            c.gridwidth = 0;
            c.insets = fieldInsets;
            gb.setConstraints(this.pwdDomain, c);
            elementsPanel.add(this.pwdDomain);
        }
        if (Config.getBooleanProperty("deployment.security.password.cache") && saveEnabled) {
            c.gridwidth = 0;
            c.insets = new Insets(12, 8, 0, 12);
            String key = "password.dialog.save";
            this.always = new JCheckBox(this.getMessage(key));
            if (sugPass.length > 0) {
                this.always.setSelected(true);
            } else {
                this.always.setSelected(false);
            }
            gb.setConstraints(this.always, c);
            elementsPanel.add(this.always);
        }
        if (warning != null) {
            UITextArea warningText = new UITextArea(uNameLbl.getFont().getSize(), banner.getPreferredSize().width - 24, false);
            warningText.setFont(plain);
            warningText.setText(warning);
            Dimension prefSize = warningText.getPreferredSize();
            warningText.setSize(prefSize.width, prefSize.height);
            c.gridwidth = 0;
            c.insets = new Insets(12, 12, 0, 12);
            gb.setConstraints(warningText, c);
            elementsPanel.add(warningText);
        }
        JPanel btnsPanel = new JPanel();
        btnsPanel.setLayout(new BoxLayout(btnsPanel, 2));
        this.okBtn = new JButton(this.getMessage("common.ok_btn"));
        this.okBtn.setActionCommand("OK");
        this.okBtn.addActionListener(this);
        this.dialog.getRootPane().setDefaultButton(this.okBtn);
        this.cancelBtn = new JButton(this.getMessage("common.cancel_btn"));
        this.cancelBtn.addActionListener(this);
        this.setCancelAction();
        JButton[] buttons = new JButton[]{this.okBtn, this.cancelBtn};
        DialogTemplate.resizeButtons(buttons);
        btnsPanel.add(Box.createHorizontalGlue());
        btnsPanel.add(this.okBtn);
        btnsPanel.add(Box.createHorizontalStrut(6));
        btnsPanel.add(this.cancelBtn);
        btnsPanel.add(Box.createHorizontalStrut(12));
        JPanel schemePanel = null;
        if (scheme != null) {
            schemePanel = new JPanel();
            schemePanel.setLayout(new FlowLayout(3, 0, 0));
            schemePanel.add(Box.createHorizontalStrut(12));
            JLabel schemeLabel = new JLabel(ResourceManager.getString("password.dialog.scheme", scheme));
            schemeLabel.setFont(plain);
            schemePanel.add(schemeLabel);
        }
        JPanel allComponents = new JPanel();
        allComponents.setLayout(new BoxLayout(allComponents, 3));
        allComponents.add(elementsPanel);
        allComponents.add(Box.createVerticalStrut(24));
        allComponents.add(btnsPanel);
        allComponents.add(Box.createVerticalStrut(12));
        if (schemePanel != null) {
            allComponents.add(new JSeparator());
            allComponents.add(Box.createVerticalStrut(12));
            allComponents.add(schemePanel);
            allComponents.add(Box.createVerticalStrut(12));
        }
        return allComponents;
    }

    void showMoreInfo() {
        MoreInfoDialog info = this.throwable == null && this.detailString == null ? new MoreInfoDialog(this.dialog, this.alertStrs, this.infoStrs, this.securityInfoCount, this.certs, this.start, this.end, this.majorWarning, this.sandboxApp, false) : new MoreInfoDialog(this.dialog, this.detailString, this.throwable, this.certs, false);
        info.setVisible(true);
    }

    void showMixedcodeMoreInfo() {
        MoreInfoDialog info = new MoreInfoDialog(this.dialog, null, this.infoStrs, 0, null, 0, 0, false, this.sandboxApp, false);
        info.setVisible(true);
    }

    void showCertificateDetails() {
        Certificate[] selectCert = null;
        Iterator<X509Certificate[]> iter = this.clientAuthCertsMap.values().iterator();
        for (int selectedIndex = this.scrollList.getSelectedIndex(); selectedIndex >= 0 && iter.hasNext(); --selectedIndex) {
            selectCert = iter.next();
        }
        if (selectCert != null) {
            CertificateDialog.showCertificates(this.dialog, selectCert, 0, selectCert.length);
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            final DialogListener dl = UIFactory.getDialogListener();
            final Frame dummy = this.dummyFrame;
            final boolean disabled = URLClassPathControl.isDisabledInCurrentThread();
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    if (dl != null) {
                        dl.beforeShow();
                    }
                    if (dummy != null) {
                        dummy.setVisible(true);
                    }
                    if (disabled) {
                        URLClassPathControl.disable();
                    }
                    try {
                        DialogTemplate.this.dialog.pack();
                        UIFactory.placeWindow(DialogTemplate.this.dialog);
                        DialogTemplate.this.dialog.pack();
                        if (DialogTemplate.this.requestFocusOkBtn && DialogTemplate.this.okBtn != null) {
                            DialogTemplate.this.okBtn.requestFocusInWindow();
                            DialogTemplate.this.requestFocusOkBtn = false;
                        } else if (DialogTemplate.this.requestFocusCancelBtn && DialogTemplate.this.cancelBtn != null) {
                            DialogTemplate.this.cancelBtn.requestFocusInWindow();
                            DialogTemplate.this.requestFocusCancelBtn = false;
                        }
                        DialogTemplate.this.dialog.setVisible(true);
                    }
                    finally {
                        if (disabled) {
                            URLClassPathControl.enable();
                        }
                    }
                }
            };
            this.runSwingRunner(runner);
        } else {
            this.dialog.setVisible(false);
            this.dialog.dispose();
            if (this.dummyFrame != null) {
                this.dummyFrame.setVisible(false);
                this.dummyFrame.dispose();
            }
        }
    }

    private void runSwingRunner(Runnable runner) {
        if (runner == null) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            runner.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runner);
            }
            catch (Exception e) {
                Trace.ignored(e);
            }
        }
    }

    public void setMasthead(String text, boolean singleLine) {
        if (this.masthead != null) {
            this.topText = text;
            this.masthead.setText(text);
            if (singleLine) {
                this.masthead.setBorder(BorderFactory.createEmptyBorder(16, 12, 16, 6));
            } else {
                this.masthead.setBorder(BorderFactory.createEmptyBorder(6, 12, 6, 6));
            }
        }
    }

    public static void resizeButtons(JButton[] buttons) {
        int i;
        int len = buttons.length;
        int widest = 50;
        for (i = 0; i < len; ++i) {
            if (buttons[i].getPreferredSize().width <= widest) continue;
            widest = buttons[i].getPreferredSize().width;
        }
        for (i = 0; i < len; ++i) {
            Dimension d = buttons[i].getPreferredSize();
            d.width = widest;
            buttons[i].setPreferredSize(d);
        }
    }

    private String getMessage(String id) {
        return ResourceManager.getString(id);
    }

    private String getErrorComponent() {
        String compString = null;
        if (this.throwable instanceof DownloadException) {
            DownloadException de = (DownloadException)this.throwable;
            compString = de.getResourceString();
        }
        return compString;
    }

    private String getReasonString() {
        String reasonString = null;
        if (Config.isJavaVersionAtLeast17()) {
            if (this.throwable instanceof BlockedException) {
                BlockedException be = (BlockedException)this.throwable;
                reasonString = be.getReason();
            } else {
                reasonString = this.throwable != null ? this.throwable.getMessage() : this.reason;
            }
        }
        return reasonString;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        if (command.equals("OK")) {
            this.userAnswer = 0;
            if (this.always != null && this.always.isSelected()) {
                this.userAnswer = 2;
            }
            if (this.stayAliveOnOk) {
                return;
            }
            if (this.password != null) {
                this.pwd = this.password.getPassword();
            }
            if (this.pwdName != null) {
                this.userName = this.pwdName.getText();
            }
            if (this.pwdDomain != null) {
                this.domain = this.pwdDomain.getText();
            }
            if (this.scrollList != null) {
                this.userAnswer = this.scrollList.getSelectedIndex();
            }
        } else {
            if (this.throwable != null || this.detailString != null) {
                this.showMoreInfo();
                return;
            }
            this.userAnswer = 1;
            if (this.scrollList != null) {
                this.userAnswer = -1;
            }
        }
        this.setVisible(false);
    }

    public void cancelAction() {
        this.userAnswer = 1;
        this.setVisible(false);
    }

    public int getUserAnswer() {
        return this.userAnswer;
    }

    void setUserAnswer(int answer) {
        this.userAnswer = answer;
    }

    char[] getPassword() {
        return this.pwd;
    }

    String getUserName() {
        return this.userName;
    }

    String getDomain() {
        return this.domain;
    }

    public boolean isPasswordSaved() {
        return this.always != null && this.always.isSelected();
    }

    public void progress(int progress) {
        if (this.progressBar != null) {
            if (progress <= 100) {
                boolean vis = this.progressBar.isVisible();
                this.progressBar.setValue(progress);
                this.progressBar.setVisible(true);
            } else {
                this.progressBar.setVisible(false);
            }
        }
    }

    void setMastheadBackground(Image image) {
        if (this.masthead != null && this.masthead instanceof UITextArea) {
            ((UITextArea)this.masthead).setBackgroundImage(image);
        }
    }

    public void disposeDialog() {
        this.dialog.dispose();
    }

    public Component deriveParent(Component owner, String title) {
        if (owner == null && Config.getOSName().equals("Windows")) {
            this.dummyFrame = new Frame(title);
            this.dummyFrame.setLocation(-4096, -4096);
            return this.dummyFrame;
        }
        for (Component comp = owner; comp != null; comp = comp.getParent()) {
            if (!(comp instanceof Dialog) && !(comp instanceof Frame)) continue;
            return comp;
        }
        return null;
    }

    public JDialog getDialog() {
        return this.dialog;
    }

    public void setInfo(String name, String publisher, URL urlFrom, String displayFrom) {
        if (this.nameInfo != null) {
            this.nameInfo.setText(name);
        }
        if (this.publisherInfo != null) {
            this.appPublisher = publisher;
            this.publisherInfo.setText(publisher);
        }
        if (this.urlInfo != null) {
            String tooltip = urlFrom == null ? " " : urlFrom.toString();
            String from = displayFrom == null ? "" : displayFrom;
            this.urlInfo.setText(from);
            this.urlInfo.setToolTipText(tooltip);
        }
    }

    public void setInfo(AppInfo info) {
        this.setInfo(info.getDisplayTitle(), info.getDisplayVendor(), info.getFrom(), info.getDisplayFrom());
        if (info.shouldDisplayMainJNLP() && this.originInfo != null) {
            this.originInfo.setText(info.getDisplayMainJNLP());
            this.originInfo.setToolTipText(info.getDisplayMainJNLPTooltip());
        }
        if (info.shouldDisplayDocumentBase() && this.appletLocationInfo != null) {
            this.appletLocationInfo.setText(info.getDisplayDocumentBase());
            this.appletLocationInfo.setToolTipText(info.getDocumentBase().toString());
        }
    }

    void showOk(boolean show) {
        JButton[] buttons = new JButton[]{this.okBtn, this.cancelBtn};
        DialogTemplate.resizeButtons(buttons);
        this.okBtn.setVisible(show);
    }

    void stayAlive() {
        this.stayAliveOnOk = true;
    }

    public void setProgressStatusText(String text) {
        if (this.progressStatusLabel != null) {
            if (text == null || text.length() == 0) {
                text = " ";
            }
            this.progressStatusLabel.setText(text);
        }
    }

    @Override
    public void imageAvailable(URL url, String version, Image image, File file) {
        final int w = image.getWidth(null);
        final int h = image.getHeight(null);
        final Image imageIn = image;
        final JLabel label = this.topIcon;
        SafeThreadFactory.createThread(new Runnable(){

            @Override
            public void run() {
                Image im = imageIn;
                if (48 != w || 48 != h) {
                    im = imageIn.getScaledInstance(48, 48, 1);
                }
                label.setIcon(new ImageIcon(im, "Application Image"));
            }
        }).start();
    }

    @Override
    public void finalImageAvailable(URL url, String version, Image image, File file) {
        this.imageAvailable(url, version, image, file);
    }

    public static int getSubpanelFontSize() {
        Font f = ResourceManager.getUIFont();
        int newFontSize = f.getSize() - 2;
        if (Config.getOSName().equalsIgnoreCase("windows")) {
            newFontSize = f.getSize() - 1;
        }
        if (newFontSize < minFontSize) {
            newFontSize = minFontSize;
        }
        return newFontSize;
    }

    public void addWindowListener(WindowListener wl) {
        this.dialog.addWindowListener(wl);
    }

    public void removeWindowListener(WindowListener wl) {
        this.dialog.removeWindowListener(wl);
    }

    static {
        MAIN_TEXT_WIDTH = 426;
        minFontSize = ResourceManager.getMinFontSize();
    }

    private class WindowListenerImpl
    implements WindowListener {
        private WindowListenerImpl() {
        }

        @Override
        public void windowOpened(WindowEvent e) {
        }

        @Override
        public void windowClosing(WindowEvent e) {
        }

        @Override
        public void windowClosed(WindowEvent e) {
        }

        @Override
        public void windowIconified(WindowEvent e) {
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
        }

        @Override
        public void windowActivated(WindowEvent e) {
            DialogTemplate.this.runSwingRunner(DialogTemplate.this.toFrontRunner);
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
        }
    }

    private class LinkText
    extends JPanel {
        private static final long serialVersionUID = -4261591455361119502L;
        private JSmartTextArea _text;
        private FancyButton _link;
        Dimension size;

        public LinkText(String beforeText, String linkText, URL linkURL) {
            String urlStr;
            super(new BorderLayout());
            this.size = null;
            String string = urlStr = linkURL == null ? "http://java.com" : linkURL.toString();
            if (beforeText != null && beforeText.length() > 0) {
                this._text = new JSmartTextArea(beforeText);
            }
            this._link = new FancyButton(linkText, 0, DialogTemplate.this.LINK_COLOR);
            this._link.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
            this._link.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent me) {
                }

                @Override
                public void mousePressed(MouseEvent me) {
                }

                @Override
                public void mouseReleased(MouseEvent me) {
                }

                @Override
                public void mouseEntered(MouseEvent me) {
                    LinkText.this._link.setForeground(DialogTemplate.this.LINK_HIGHLIGHT_COLOR);
                }

                @Override
                public void mouseExited(MouseEvent me) {
                    LinkText.this._link.setForeground(DialogTemplate.this.LINK_COLOR);
                }
            });
            this._link.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    Platform.get().showDocument(urlStr);
                }
            });
            JPanel south = new JPanel(new BorderLayout());
            south.setOpaque(false);
            south.add((Component)this._link, "West");
            if (this._text != null) {
                this.add((Component)this._text, "North");
            }
            this.add((Component)south, "South");
        }

        public void setText(String text) {
            if (this._text != null) {
                this._text.setText(text);
            }
        }

        @Override
        public void setFont(Font f) {
            if (this._text != null) {
                this._text.setFont(f);
            }
            if (this._link != null) {
                this._link.setFont(f);
            }
            this.size = null;
        }

        @Override
        public void setOpaque(boolean opaque) {
            super.setOpaque(opaque);
            if (this._text != null) {
                this._text.setOpaque(opaque);
            }
            if (this._link != null) {
                this._link.setOpaque(opaque);
            }
        }
    }

    private class SSVChoicePanel
    extends JPanel {
        private static final long serialVersionUID = -9036212255932269398L;
        ButtonGroup group;
        JRadioButton button1;
        JRadioButton button2;

        public SSVChoicePanel(String choiceText, String choice1Label, String choice2Label) {
            super(new BorderLayout());
            this.setOpaque(false);
            this.setBorder(BorderFactory.createEmptyBorder(8, 16, 0, 16));
            JPanel top = new JPanel(new BorderLayout());
            JPanel bot = new JPanel(new BorderLayout());
            top.setOpaque(false);
            bot.setOpaque(false);
            JLabel textLabel = new JLabel(choiceText);
            textLabel.setOpaque(false);
            textLabel.setFont(ssvSmallBoldFont);
            top.add((Component)textLabel, "Center");
            this.button1 = new JRadioButton(choice1Label, true);
            this.button1.setFont(ssvSmallFont);
            this.button1.setOpaque(false);
            this.button2 = new JRadioButton(choice2Label, false);
            this.button2.setFont(ssvSmallFont);
            this.button2.setOpaque(false);
            this.group = new ButtonGroup();
            this.group.add(this.button1);
            this.group.add(this.button2);
            bot.add((Component)this.button1, "North");
            bot.add((Component)this.button2, "South");
            bot.setBorder(BorderFactory.createEmptyBorder(0, 32, 0, 16));
            this.add((Component)top, "North");
            this.add((Component)bot, "South");
            this.button1.requestFocusInWindow();
        }

        public int getSelection() {
            if (this.button2.isSelected()) {
                return 1;
            }
            return 0;
        }
    }
}

