/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.ui;

import com.sun.deploy.config.Config;
import com.sun.deploy.config.Platform;
import com.sun.deploy.net.DownloadException;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.BlockedException;
import com.sun.deploy.security.CertificateDialog;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.ui.DialogTemplate;
import com.sun.deploy.ui.FancyButton;
import com.sun.deploy.ui.JSmartTextArea;
import com.sun.deploy.ui.UIFactory;
import com.sun.deploy.ui.UITextArea;
import com.sun.deploy.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.cert.Certificate;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

class MoreInfoDialog
extends JDialog {
    private static final long serialVersionUID = 1732843154120581169L;
    private FancyButton details;
    private String[] alerts;
    private String[] infos;
    private int securityInfoCount;
    private Certificate[] certs;
    private int start;
    private int end;
    private boolean majorWarning;
    private boolean sandboxApp = false;
    private boolean nativeSandbox = false;
    private Throwable throwable = null;
    private final String WARNING_ICON = "icon-warning16.png";
    private final String INFO_ICON = "icon-info16.png";
    private final int VERTICAL_STRUT = 18;
    private final int HORIZONTAL_STRUT = 12;
    private final String linkUrlStr = "http://java.com/en/download/faq/self_signed.xml";
    private final int TEXT_WIDTH = 326;

    MoreInfoDialog(JDialog parent, String[] alerts, String[] infos, int securityInfoCount, Certificate[] certs, int start, int end, boolean majorWarning, boolean sandboxApp, boolean nativeSandbox) {
        super((Dialog)parent, true);
        this.alerts = alerts;
        this.infos = infos;
        this.securityInfoCount = securityInfoCount;
        this.certs = certs;
        this.start = start;
        this.end = end;
        this.majorWarning = majorWarning;
        this.sandboxApp = sandboxApp;
        this.nativeSandbox = nativeSandbox;
        this.initComponents(null, null);
        this.setResizable(false);
        if (parent != null && parent.isAlwaysOnTop()) {
            this.setAlwaysOnTop(true);
        }
    }

    MoreInfoDialog(JDialog parent, String detailString, Throwable throwable, Certificate[] certs, boolean majorWarning) {
        super((Dialog)parent, true);
        this.certs = certs;
        this.start = 0;
        this.end = certs == null ? 0 : certs.length;
        this.majorWarning = majorWarning;
        this.throwable = throwable;
        this.initComponents(detailString, throwable);
        if (parent != null && parent.isAlwaysOnTop()) {
            this.setAlwaysOnTop(true);
        }
    }

    private void initComponents(String detailString, Throwable throwable) {
        this.setTitle(this.getMessage("security.more.info.title"));
        this.getContentPane().setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel();
        contentPanel.setBorder(BorderFactory.createEmptyBorder(16, 16, 12, 16));
        contentPanel.setLayout(new BoxLayout(contentPanel, 1));
        contentPanel.setAlignmentX(0.0f);
        if (detailString != null) {
            JPanel detailPanel = this.createDetailPanel(detailString);
            contentPanel.add(detailPanel);
        } else if (throwable != null) {
            contentPanel.add(Box.createHorizontalStrut(440));
            JPanel labelPanel = new JPanel(new BorderLayout());
            JLabel label = new JLabel(ResourceManager.getString("exception.details.label"));
            label.setBorder(BorderFactory.createEmptyBorder(0, 0, 8, 0));
            labelPanel.add((Component)label, "West");
            contentPanel.add(labelPanel);
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            throwable.printStackTrace(pw);
            JTextArea text = new JTextArea(sw.toString(), 20, 60);
            text.setFont(ResourceManager.getUIFont());
            text.setEditable(false);
            text.setLineWrap(true);
            text.setWrapStyleWord(false);
            JScrollPane sp = new JScrollPane(text, 20, 30);
            contentPanel.add(sp);
            if (this.certs != null) {
                contentPanel.add(Box.createVerticalStrut(18));
                contentPanel.add(this.getLinkPanel());
            }
        } else {
            contentPanel.add(this.getSecurityPanel());
            if (this.certs != null) {
                contentPanel.add(this.getLinkPanel());
            }
            if (this.nativeSandbox) {
                JPanel panel = this.createNativeSandboxPanel();
                contentPanel.add(panel);
            }
            contentPanel.add(Box.createVerticalStrut(18));
            contentPanel.add(this.getIntegrationPanel());
        }
        contentPanel.add(Box.createVerticalStrut(18));
        contentPanel.add(this.getBtnPanel());
        this.getContentPane().add((Component)contentPanel, "Center");
        this.pack();
        UIFactory.placeWindow(this);
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "cancel");
        this.getRootPane().getActionMap().put("cancel", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MoreInfoDialog.this.dismissAction();
            }
        });
    }

    private JPanel getSecurityPanel() {
        JPanel securityPanel = new JPanel();
        securityPanel.setLayout(new BoxLayout(securityPanel, 1));
        int end = this.alerts == null ? 0 : this.alerts.length;
        securityPanel.add(this.blockPanel("icon-warning16.png", this.alerts, 0, end));
        String infoIconString = null;
        if (end == 0) {
            infoIconString = "icon-info16.png";
        }
        end = this.securityInfoCount;
        securityPanel.add(this.blockPanel(infoIconString, this.infos, 0, end));
        return securityPanel;
    }

    private JPanel getLinkPanel() {
        JPanel linkPanel = new JPanel();
        linkPanel.setLayout(new BoxLayout(linkPanel, 0));
        linkPanel.setAlignmentX(0.0f);
        linkPanel.add(Box.createHorizontalGlue());
        String key = this.sandboxApp ? "sandbox.security.more.info.details" : "security.more.info.details";
        this.details = new FancyButton(ResourceManager.getString(key), ResourceManager.getMnemonic(key), Color.blue);
        this.details.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getComponent() instanceof FancyButton) {
                    MoreInfoDialog.this.showCertDetails();
                }
            }

            @Override
            public void mouseEntered(MouseEvent me) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        this.details.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                MoreInfoDialog.this.showCertDetails();
            }
        });
        linkPanel.add(this.details);
        return linkPanel;
    }

    private JPanel getIntegrationPanel() {
        int start = this.securityInfoCount;
        int end = this.infos == null ? 0 : this.infos.length;
        return this.blockPanel("icon-info16.png", this.infos, start, end);
    }

    private JPanel getBtnPanel() {
        JPanel btnPanel = new JPanel();
        btnPanel.setLayout(new BoxLayout(btnPanel, 0));
        btnPanel.setAlignmentX(0.0f);
        btnPanel.add(Box.createHorizontalGlue());
        JButton dismissBtn = new JButton(this.getMessage("common.close_btn"));
        dismissBtn.setAlignmentY(0.0f);
        dismissBtn.setAlignmentX(0.0f);
        dismissBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                MoreInfoDialog.this.dismissAction();
            }
        });
        this.getRootPane().setDefaultButton(dismissBtn);
        if (this.majorWarning) {
            String key = "security.more.info.linkurl";
            FancyButton linkInfoButton = new FancyButton(ResourceManager.getString(key), ResourceManager.getMnemonic(key));
            linkInfoButton.setAlignmentY(0.0f);
            linkInfoButton.setAlignmentX(0.0f);
            linkInfoButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    Platform.get().showDocument("http://java.com/en/download/faq/self_signed.xml");
                }
            });
            btnPanel.add(linkInfoButton);
            btnPanel.add(Box.createHorizontalStrut(95));
        }
        btnPanel.add(dismissBtn);
        return btnPanel;
    }

    private JPanel blockPanel(String iconLblStr, String[] strs, int start, int end) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        if (strs != null) {
            for (int i = start; i < end; ++i) {
                JPanel p = new JPanel();
                p.setLayout(new BoxLayout(p, 0));
                p.setAlignmentX(0.0f);
                JLabel iconLbl = new JLabel();
                if (i == start && iconLblStr != null) {
                    iconLbl.setIcon(ResourceManager.getIconResource(iconLblStr));
                } else {
                    iconLbl.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
                }
                iconLbl.setAlignmentY(0.0f);
                iconLbl.setAlignmentX(0.0f);
                UITextArea text = new UITextArea(new JLabel().getFont().getSize(), 326, false);
                text.setText(strs[i]);
                Dimension pref = text.getPreferredSize();
                text.setSize(pref.width, pref.height);
                text.setAlignmentY(0.0f);
                text.setAlignmentX(0.0f);
                p.add(iconLbl);
                p.add(Box.createHorizontalStrut(12));
                p.add(text);
                p.add(Box.createHorizontalGlue());
                panel.add(p);
                panel.add(Box.createVerticalStrut(18));
            }
        }
        return panel;
    }

    private JPanel createNativeSandboxPanel() {
        HyperlinkListener hyperlinkListener = new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        Platform.get().showDocument(e.getURL().toString());
                    }
                    catch (Exception eu) {
                        Trace.ignored(eu);
                    }
                }
            }
        };
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.setAlignmentX(0.0f);
        JLabel iconLbl = new JLabel();
        iconLbl.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        p.add(iconLbl);
        p.add(Box.createHorizontalStrut(12));
        p.add(DialogTemplate.createYellowWarningPanel(this.getMessage("security.moreinfo.native.sandbox.warning"), hyperlinkListener, 330));
        p.add(Box.createHorizontalGlue());
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(8, 0, 0, 0));
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(p);
        panel.add(Box.createVerticalStrut(18));
        return panel;
    }

    private void showCertDetails() {
        CertificateDialog.showCertificates(this, this.certs, this.start, this.end);
    }

    private void dismissAction() {
        this.setVisible(false);
        this.dispose();
    }

    private String getMessage(String id) {
        return ResourceManager.getString(id);
    }

    private String getErrorComponent() {
        String compString = null;
        if (this.throwable instanceof DownloadException) {
            DownloadException de = (DownloadException)this.throwable;
            compString = de.getResourceString();
        }
        return compString;
    }

    private String getReasonString() {
        String reasonString = null;
        if (Config.isJavaVersionAtLeast17()) {
            if (this.throwable instanceof BlockedException) {
                BlockedException be = (BlockedException)this.throwable;
                reasonString = be.getReason();
            } else if (this.throwable != null) {
                reasonString = this.throwable.getMessage();
            }
        }
        return reasonString;
    }

    private JPanel createLabelsPanel() {
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel labelsPanel = new JPanel();
        labelsPanel.setLayout(gb);
        labelsPanel.setBorder(BorderFactory.createEmptyBorder());
        JLabel label = new JLabel();
        Font bold = label.getFont().deriveFont(1);
        Font plain = label.getFont().deriveFont(0);
        String reasonString = this.getReasonString();
        String errorComponent = this.getErrorComponent();
        if (errorComponent != null) {
            JLabel componentLbl = new JLabel(this.getMessage("deployment.ssv.component"));
            componentLbl.setFont(bold);
            JLabel componentInfo = new JLabel();
            componentInfo.setFont(plain);
            componentInfo.putClientProperty("html.disable", Boolean.TRUE);
            c.fill = 2;
            c.weightx = 0.0;
            c.gridwidth = 1;
            c.anchor = 18;
            c.insets = new Insets(12, 0, 0, 12);
            gb.setConstraints(componentLbl, c);
            labelsPanel.add(componentLbl);
            c.insets = new Insets(12, 0, 0, 12);
            c.gridwidth = 0;
            c.weightx = 1.0;
            c.weighty = 1.0;
            gb.setConstraints(componentInfo, c);
            componentInfo.setText(errorComponent);
            labelsPanel.add(componentInfo);
        }
        if (reasonString != null) {
            JSmartTextArea reasonInfo = new JSmartTextArea(reasonString);
            reasonInfo.setFont(plain);
            reasonInfo.setLineWrap(true);
            reasonInfo.setWrapStyleWord(true);
            reasonInfo.setOpaque(false);
            int height = reasonInfo.getPreferredSize().height * 3;
            reasonInfo.setPreferredSize(new Dimension(reasonInfo.getPreferredSize().width, height));
            c.insets = new Insets(12, 0, 0, 12);
            c.gridwidth = 0;
            c.weightx = 1.0;
            c.weighty = 1.0;
            gb.setConstraints(reasonInfo, c);
            labelsPanel.add(reasonInfo);
        }
        return labelsPanel;
    }

    private JPanel createDetailPanel(String detailString) {
        String[] msg;
        JPanel detailPanel = new JPanel(){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(480, 300);
            }
        };
        detailPanel.setLayout(new BorderLayout());
        JTabbedPane tabPane = new JTabbedPane();
        detailPanel.add((Component)tabPane, "Center");
        tabPane.setBorder(BorderFactory.createEmptyBorder(8, 0, 0, 0));
        JPanel intro = new JPanel(new BorderLayout());
        JLabel label = new JLabel(ResourceManager.getString("launcherrordialog.error.label"));
        Font bold = label.getFont().deriveFont(1);
        label.setFont(bold);
        JPanel labelsPanel = this.createLabelsPanel();
        intro.add((Component)labelsPanel, "West");
        try {
            msg = detailString.split("<split>");
        }
        catch (NoSuchMethodError nsme) {
            msg = StringUtils.splitString(detailString, "<split>");
        }
        detailPanel.add((Component)intro, "North");
        int i = 1;
        while (i + 1 < msg.length) {
            JTextArea tp12 = new JTextArea();
            tp12.setFont(ResourceManager.getUIFont());
            tp12.setEditable(false);
            tp12.setLineWrap(true);
            tp12.setText(msg[i + 1]);
            tabPane.add(msg[i], new JScrollPane(tp12));
            i += 2;
        }
        return detailPanel;
    }
}

