/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.Base64Wrapper;
import com.sun.deploy.util.JVMParameters;
import com.sun.deploy.util.SystemUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ArgumentParsingUtil {
    private static final String encprop = "sun.jnu.encoding";
    private static String encoding = null;
    private static boolean isCharsetSupported = false;

    public static List<String> parseCommandLine(String in) {
        if (in == null || in.isEmpty()) {
            return new ArrayList<String>();
        }
        Pattern pattern = Pattern.compile("(?:(?:([\"'])(?:\\\\\\1|.)*?(?:\\1|$))|(?:\\\\[\"'\\s]|[^\\s]))++");
        Matcher m = pattern.matcher(in);
        ArrayList<String> listOut = new ArrayList<String>();
        while (m.find()) {
            String s = in.substring(m.start(), m.end()).trim();
            if (s.isEmpty()) continue;
            listOut.add(ArgumentParsingUtil.unquoteIfNeeded(s));
        }
        Trace.println(" --- parseCommandLine converted : " + in + "\ninto:\n" + listOut, TraceLevel.SECURITY);
        return listOut;
    }

    public static List<String> getSecureLaunchArgs(JREInfo jreInfo, List<String> cmdArgs, JVMParameters secureJVMParams, boolean isRelaunch, boolean excludeJCPArgs) {
        List<String> appVmArgsListPre;
        List<String> appVmArgsList;
        String jcpVmArgs;
        ArrayList<String> args = new ArrayList<String>();
        if (jreInfo == null) {
            throw new IllegalArgumentException("Invalid JRE info passed.");
        }
        String jrePath = jreInfo.getJREPath();
        if (jrePath == null || jrePath.isEmpty()) {
            throw new IllegalArgumentException("Invalid JRE path passed.");
        }
        if (cmdArgs == null || cmdArgs.isEmpty()) {
            throw new IllegalArgumentException("Invalid argument list passed.");
        }
        String mainClass = null;
        int mainClassIndexOffset = 0;
        Iterator<String> iter = cmdArgs.iterator();
        if (iter.hasNext()) {
            iter.next();
        }
        while (iter.hasNext()) {
            String arg = iter.next();
            if (arg.charAt(0) == '-') {
                if (!arg.equals("-classpath") && !arg.equals("-cp") && !arg.equals("-jar") && !arg.equals("-m") && !arg.equals("--add-modules") && !arg.equals("--module-path") && !arg.equals("-p")) continue;
                if (!arg.equals("-m")) {
                    if (!iter.hasNext()) continue;
                    iter.next();
                    continue;
                }
                mainClassIndexOffset = 1;
                continue;
            }
            mainClass = arg;
            break;
        }
        if (mainClass == null) {
            Trace.println("Can't launch non-existent main class!");
            return null;
        }
        Trace.println("Main class is: " + mainClass, TraceLevel.SECURITY);
        if (!(mainClass.equals("sun.plugin2.main.WebStart") || mainClass.equals("jdk.plugin/sun.plugin2.main.WebStart") || mainClass.equals("sun.plugin2.main.client.PluginMain") || mainClass.equals("jdk.plugin/sun.plugin2.main.client.PluginMain"))) {
            Trace.println("Cannot use secure launcher with main class: " + mainClass);
            return null;
        }
        int mainClassIndex = cmdArgs.indexOf(mainClass);
        List<String> vmArgs = cmdArgs.subList(1, mainClassIndex - mainClassIndexOffset);
        List<String> mainArgs = cmdArgs.subList(mainClassIndex + 1, cmdArgs.size());
        ArrayList<String> extra = null;
        if (isRelaunch) {
            extra = new ArrayList<String>();
        }
        if (excludeJCPArgs && (jcpVmArgs = jreInfo.getVmArgs()) != null && !jcpVmArgs.isEmpty()) {
            List<String> jcpVmArgsList = ArgumentParsingUtil.parseCommandLine(jcpVmArgs);
            ArrayList<String> out = new ArrayList<String>();
            ArgumentParsingUtil.getExcludedListForJCPArgs(vmArgs, out, extra, jcpVmArgsList);
            vmArgs = out;
        }
        String encodedVMArgs = ArgumentParsingUtil.encodeArgumentList(vmArgs);
        String encodedMainArgs = ArgumentParsingUtil.encodeArgumentList(mainArgs);
        args.add(cmdArgs.get(0));
        args.add("-secure");
        if (!jreInfo.isModularJRE()) {
            args.add("-legacy");
        }
        if (mainClass.equals("sun.plugin2.main.WebStart") || mainClass.equals("jdk.plugin/sun.plugin2.main.WebStart")) {
            args.add("-javaws");
        } else {
            args.add("-plugin");
        }
        args.add("-jre");
        args.add(jrePath);
        args.add("-vma");
        args.add(encodedVMArgs);
        args.add("-ma");
        args.add(encodedMainArgs);
        if (extra != null && !extra.isEmpty()) {
            Trace.println("Adding extra vm args from JCP: " + extra, TraceLevel.BASIC);
            args.add("-ta");
            args.add(ArgumentParsingUtil.encodeArgumentList(extra));
        }
        if (secureJVMParams != null && !(appVmArgsList = ArgumentParsingUtil.getMergedList(appVmArgsListPre = secureJVMParams.getCommandLineArguments(jreInfo, false), vmArgs)).isEmpty()) {
            Trace.println("Adding vm args from HTML or JNLP: " + appVmArgsList, TraceLevel.BASIC);
            args.add("-ta");
            args.add(ArgumentParsingUtil.encodeArgumentList(appVmArgsList));
        }
        if (isRelaunch) {
            args.add("-checkParent");
        }
        return args;
    }

    private static List<String> getMergedList(List<String> pre, List<String> vmArgs) {
        ArrayList<String> merged = new ArrayList<String>();
        if (pre != null && vmArgs != null) {
            for (String arg : pre) {
                if (!Config.isSecureVmArg(arg)) {
                    merged.add(arg);
                    continue;
                }
                if (vmArgs.contains(arg)) continue;
                merged.add(arg);
            }
        }
        return merged;
    }

    private static void getExcludedListForJCPArgs(List<String> in, List<String> out, List<String> extra, List<String> exclude) {
        if (in != null && out != null && exclude != null) {
            for (String arg : in) {
                if (exclude.contains(arg)) continue;
                out.add(arg);
            }
            if (extra != null) {
                for (String arg : exclude) {
                    if (!Config.getBooleanProperty("deployment.relaunch.increment.debug.port") || !SystemUtils.isJdwpDtSocketServerDebugParam(arg)) continue;
                    arg = SystemUtils.convertDebugParamForRelaunch(arg);
                    extra.add(arg);
                    break;
                }
            }
        }
    }

    private static void initEncoding() {
        if (encoding == null) {
            try {
                encoding = System.getProperty(encprop);
                isCharsetSupported = Charset.isSupported(encoding);
                Trace.println("Using " + encoding + " to encode arguments.", TraceLevel.BASIC);
            }
            catch (Exception ex) {
                Trace.ignoredException(ex);
                Trace.println("Using system default encoding to encode arguments.", TraceLevel.BASIC);
            }
        }
    }

    public static String encodeArgumentList(List<String> args) {
        if (args == null) {
            throw new NullPointerException();
        }
        if (args.isEmpty()) {
            return "";
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (String arg : args) {
            try {
                byte[] argBytes = isCharsetSupported ? arg.getBytes(encoding) : arg.getBytes();
                baos.write(argBytes, 0, argBytes.length);
                baos.write(0);
            }
            catch (UnsupportedEncodingException uee) {
                Trace.println("Internal error while encoding argument list.", TraceLevel.DEFAULT);
                return "";
            }
        }
        return Base64Wrapper.encodeToStringWithoutLineBreaks(baos.toByteArray());
    }

    public static List<String> decodeArgumentList(String encodedArgs) {
        byte[] argBytes;
        if (encodedArgs == null || encodedArgs.isEmpty()) {
            return new ArrayList<String>();
        }
        ArrayList<String> outArgs = new ArrayList<String>();
        try {
            argBytes = Base64Wrapper.decodeFromString(encodedArgs);
        }
        catch (IOException ioe) {
            Trace.println("Internal error while decoding argument list.", TraceLevel.DEFAULT);
            return null;
        }
        int argStart = 0;
        for (int index = 0; index < argBytes.length; ++index) {
            if (argBytes[index] != 0 && index != argBytes.length - 1) continue;
            if (index > argStart) {
                try {
                    String arg = isCharsetSupported ? new String(argBytes, argStart, index - argStart, encoding) : new String(argBytes, argStart, index - argStart);
                    outArgs.add(arg);
                }
                catch (UnsupportedEncodingException uee) {
                    Trace.println("Bad characters encountered while decoding command line argument.", TraceLevel.DEFAULT);
                    return null;
                }
            }
            argStart = index + 1;
        }
        return outArgs;
    }

    public static String serializeArgumentListForDebugging(List<String> args) {
        if (args == null) {
            throw new NullPointerException();
        }
        StringBuilder sb = new StringBuilder();
        Iterator<String> iter = args.iterator();
        while (iter.hasNext()) {
            sb.append(" \"");
            sb.append(iter.next());
            sb.append("\"");
        }
        return sb.toString();
    }

    public static String unquoteIfNeeded(String in) {
        if (in == null) {
            return null;
        }
        if (in.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int codeLen = in.codePointCount(0, in.length());
        int quoteChar = -1;
        for (int i = 0; i < codeLen; ++i) {
            int code = in.codePointAt(i);
            if (code == 34 || code == 39) {
                if (i > 0 && in.codePointAt(i - 1) == 92) {
                    sb.deleteCharAt(sb.length() - 1);
                    sb.appendCodePoint(code);
                    continue;
                }
                if (quoteChar != -1) {
                    if (code == quoteChar) {
                        quoteChar = -1;
                        continue;
                    }
                    sb.appendCodePoint(code);
                    continue;
                }
                quoteChar = code;
                continue;
            }
            sb.appendCodePoint(code);
        }
        return sb.toString();
    }

    static {
        ArgumentParsingUtil.initEncoding();
    }
}

