/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.xdg;

import com.sun.deploy.Environment;
import com.sun.deploy.util.SystemPropertyUtil;
import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.StringTokenizer;

public final class BaseDir {
    private static BaseDir instance;

    public static synchronized BaseDir getInstance() {
        if (instance == null) {
            instance = new BaseDir();
        }
        return instance;
    }

    public String getUserDataDir() {
        Object userData = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return Environment.getenv("XDG_DATA_HOME");
            }
        });
        if (userData == null) {
            userData = SystemPropertyUtil.getProperty("user.home") + File.separatorChar + ".local" + File.separatorChar + "share";
        }
        if (!this.checkDir((String)userData)) {
            userData = null;
        }
        return userData;
    }

    public String getUserConfigDir() {
        return System.getProperty("user.home") + File.separatorChar + ".config";
    }

    public String getSystemDataDir() {
        Object sysDataDirs = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Environment.getenv("XDG_DATA_HOME");
            }
        });
        if (sysDataDirs == null) {
            sysDataDirs = File.separatorChar + "usr" + File.separatorChar + "local" + File.separatorChar + "share" + File.pathSeparatorChar + File.separatorChar + "usr" + File.separatorChar + "share";
        }
        StringTokenizer tokenizer = new StringTokenizer((String)sysDataDirs, File.pathSeparator);
        ArrayList<String> dirs = new ArrayList<String>(tokenizer.countTokens());
        while (tokenizer.hasMoreTokens()) {
            dirs.add(tokenizer.nextToken());
        }
        ListIterator iter = dirs.listIterator(dirs.size());
        String goodDirectory = null;
        while (goodDirectory == null && iter.hasPrevious()) {
            String dir = (String)iter.previous();
            if (!this.checkDir(dir)) continue;
            goodDirectory = dir;
        }
        return goodDirectory;
    }

    public String[] getSystemDataDirs() {
        Object sysDataDirs = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Environment.getenv("XDG_DATA_HOME");
            }
        });
        if (sysDataDirs == null) {
            sysDataDirs = File.separatorChar + "usr" + File.separatorChar + "local" + File.separatorChar + "share" + File.pathSeparatorChar + File.separatorChar + "usr" + File.separatorChar + "share";
        }
        StringTokenizer tokenizer = new StringTokenizer((String)sysDataDirs, File.pathSeparator);
        ArrayList<String> dirs = new ArrayList<String>(tokenizer.countTokens());
        while (tokenizer.hasMoreTokens()) {
            dirs.add(tokenizer.nextToken());
        }
        return dirs.toArray(new String[dirs.size()]);
    }

    private boolean checkDir(String dir) {
        File f = new File(dir);
        return f.isDirectory() && f.canRead() && f.canWrite();
    }
}

