/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.cache;

import com.sun.deploy.Environment;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.Cache6Upgrader;
import com.sun.deploy.cache.CacheEntry;
import com.sun.deploy.cache.CacheUpgradeHelper;
import com.sun.deploy.cache.UpgradeStatus;
import com.sun.deploy.config.Config;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.services.ServiceManager;
import com.sun.deploy.trace.FileTraceListener;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.SafeThreadFactory;
import com.sun.deploy.util.SystemUtils;
import com.sun.deploy.util.VersionString;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;

abstract class CacheUpgrader {
    private static CacheUpgrader instance;
    private static CacheUpgrader systemInstance;
    private static boolean backgroundRunning;
    private final String name;
    protected final File oldCacheDir;
    protected final File newCacheDir;
    protected UpgradeStatus old;
    protected UpgradeStatus current;
    private static final UpgradeStatus NOOP_STATUS;
    private static final String SEP;
    private static File oldDefaultCacheDir;
    private static File oldDefaultSystemCacheDir;

    protected CacheUpgrader(String string, File file, File file2) {
        this.name = string;
        this.oldCacheDir = file;
        this.newCacheDir = file2;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    static synchronized CacheUpgrader getInstance() {
        File file;
        if (instance == null && !Config.get().isCacheUpgradeSkipped() && UpgradeStatus.beenInitialized("Cache6Upgrader") && (file = CacheUpgrader.getOldDefaultCacheDir()) != null) {
            Cache6Upgrader cache6Upgrader;
            boolean bl;
            File file2 = new File(Config.get().getDefaultCacheVersionDirectory());
            File file3 = Cache.getCacheDir();
            boolean bl2 = file2.equals(file3);
            boolean bl3 = bl = !file.equals(file3);
            if (bl2 && bl && !(cache6Upgrader = Cache6Upgrader.createInstance(false, file, file3)).isUpgradeDone()) {
                instance = cache6Upgrader;
                CacheUpgrader.startBackgroundUpgradeIfNeeded();
            }
        }
        if (instance == null) {
            instance = new NoopUpgrader();
        }
        return instance;
    }

    static synchronized CacheUpgrader getSystemInstance() {
        if (systemInstance == null && !Config.get().isCacheUpgradeSkipped() && UpgradeStatus.beenInitialized("SystemCache6Upgrader")) {
            File file = CacheUpgrader.getOldDefaultSystemCacheDir();
            File file2 = Cache.getSystemCacheDir();
            if (file != null && file2 != null) {
                Cache6Upgrader cache6Upgrader;
                boolean bl;
                String string = Config.get().getDefaultSystemCacheVersionDirectory();
                File file3 = string != null ? new File(string) : null;
                boolean bl2 = file2.equals(file3);
                boolean bl3 = bl = !file.equals(file2);
                if (bl2 && bl && !(cache6Upgrader = Cache6Upgrader.createInstance(false, file, file2)).isUpgradeDone()) {
                    systemInstance = cache6Upgrader;
                    CacheUpgrader.startBackgroundUpgradeIfNeeded();
                }
            }
        }
        if (systemInstance == null) {
            systemInstance = new NoopUpgrader();
        }
        return systemInstance;
    }

    static void setInstance(CacheUpgrader cacheUpgrader) {
        instance = cacheUpgrader;
    }

    static void setSystemInstance(CacheUpgrader cacheUpgrader) {
        systemInstance = cacheUpgrader;
    }

    public void upgrade() throws IOException {
        if (this.oldCacheDir == null) {
            if (CacheUpgrader.isTracing()) {
                CacheUpgrader.trace(this + ": No old cache, no upgrade");
            }
            return;
        }
        if (!this.incrementUpgradeAttempts()) {
            return;
        }
        this.upgradeImpl();
        this.setUpgradeCompleted();
        if (CacheUpgrader.isTracing()) {
            CacheUpgrader.trace(this + ": End upgrade");
        }
    }

    public CacheEntry upgradeItem(URL uRL, String string, int n) {
        if (this.oldCacheDir == null) {
            return null;
        }
        if (this.oldCacheDir.equals(this.newCacheDir)) {
            return null;
        }
        return this.upgradeItemImpl(uRL, string, n);
    }

    protected abstract void upgradeImpl();

    protected abstract CacheEntry upgradeItemImpl(URL var1, String var2, int var3);

    protected UpgradeStatus getStatus() {
        this.old = this.current;
        this.current = UpgradeStatus.getUpgradeStatus(this.getName());
        return this.current;
    }

    protected boolean incrementUpgradeAttempts() {
        this.getStatus();
        int n = this.old == null ? 0 : this.old.getUpgradeAttempts();
        return this.current.incrementUpgradeAttempt(n);
    }

    protected void setUpgradeCompleted() {
        this.getStatus().setCompleted();
    }

    protected static File getOldDefaultCacheDir() {
        if (oldDefaultCacheDir == null) {
            oldDefaultCacheDir = CacheUpgrader.getOldDefaultCache6Dir();
        }
        if (oldDefaultCacheDir != null && SystemUtils.priviledgedIsDirectory(oldDefaultCacheDir)) {
            return oldDefaultCacheDir;
        }
        return null;
    }

    static void setOldDefaultCacheDir(File file) {
        oldDefaultCacheDir = file;
    }

    protected static File getOldDefaultSystemCacheDir() {
        if (oldDefaultSystemCacheDir == null) {
            oldDefaultSystemCacheDir = CacheUpgrader.getOldDefaultSystemCache6Dir();
        }
        if (oldDefaultSystemCacheDir != null && SystemUtils.priviledgedIsDirectory(oldDefaultSystemCacheDir)) {
            return oldDefaultSystemCacheDir;
        }
        return null;
    }

    static void setOldDefaultSystemCacheDir(File file) {
        oldDefaultSystemCacheDir = file;
    }

    static File getOldDefaultCache6Dir() {
        return new File(Config.getUserHome() + SEP + "cache" + SEP + "6.0");
    }

    static File getOldDefaultSystemCache6Dir() {
        return new File(Config.getUserHome() + SEP + "SystemCache" + SEP + "6.0");
    }

    protected CacheEntry getCacheEntryFromIndexFile(File file) {
        CacheEntry cacheEntry = new CacheEntry(file);
        if (cacheEntry != null && cacheEntry.isValidEntry()) {
            return cacheEntry;
        }
        return null;
    }

    protected CacheEntry getOldCacheEntry(URL uRL, String string, int n) {
        if (this.oldCacheDir == null) {
            throw new IllegalStateException("Should never called w/o old cache");
        }
        CacheEntry cacheEntry = null;
        File[] fileArray = Cache.getMatchingIndexFiles(this.oldCacheDir, uRL);
        if (fileArray != null) {
            File file;
            for (int i = 0; i < fileArray.length; ++i) {
                CacheEntry cacheEntry2 = new CacheEntry(fileArray[i]);
                if (!cacheEntry2.isValidEntry() || !cacheEntry2.getURL().equals(uRL.toString())) continue;
                cacheEntry = CacheUpgrader.getBetterMatch(string, cacheEntry2, cacheEntry);
            }
            if (cacheEntry != null && DownloadEngine.isNativeContentType(n) && !(file = new File(cacheEntry.getNativeLibPath())).isDirectory()) {
                cacheEntry = null;
            }
        }
        return cacheEntry;
    }

    protected boolean resourcePresentInNewCache(URL uRL) {
        if (this.newCacheDir == null) {
            throw new IllegalStateException("Should never called w/o new cache");
        }
        File[] fileArray = Cache.getMatchingIndexFiles(this.newCacheDir, uRL);
        return fileArray != null && fileArray.length > 0;
    }

    static CacheEntry getBetterMatch(String string, CacheEntry cacheEntry, CacheEntry cacheEntry2) {
        if (string == null) {
            if (cacheEntry.getVersion() == null) {
                cacheEntry2 = cacheEntry;
            } else if (cacheEntry2 != null && cacheEntry2.getVersion() != null && cacheEntry.getVersion().compareTo(cacheEntry2.getVersion()) > 0) {
                cacheEntry2 = cacheEntry;
            }
        } else if (new VersionString(string).contains(cacheEntry.getVersion())) {
            if (cacheEntry2 == null) {
                cacheEntry2 = cacheEntry;
            } else if (cacheEntry.getVersion() != null && cacheEntry.getVersion().compareTo(cacheEntry2.getVersion()) > 0) {
                cacheEntry2 = cacheEntry;
            }
        }
        return cacheEntry2;
    }

    protected static void copyDirIgnoresErrors(File file, File file2) {
        CacheUpgrader.copyDirIgnoresErrors(file, file2, null);
    }

    protected static void copyDirIgnoresErrors(File file, File file2, FilenameFilter filenameFilter) {
        if (file.isDirectory()) {
            file2.mkdirs();
            File[] fileArray = file.listFiles(filenameFilter);
            for (int i = 0; i < fileArray.length; ++i) {
                File file3 = fileArray[i];
                File file4 = new File(file2, file3.getName());
                if (fileArray[i].isDirectory()) {
                    CacheUpgrader.copyDirIgnoresErrors(file3, file4, filenameFilter);
                    continue;
                }
                if (file4.exists()) continue;
                try {
                    Cache.copyFile(file3, file4);
                    continue;
                }
                catch (IOException iOException) {
                    Trace.ignored(iOException);
                }
            }
        }
    }

    protected CacheEntry copyToNewCache(final CacheEntry cacheEntry) {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<CacheEntry>(){

                @Override
                public CacheEntry run() throws IOException {
                    return CacheUpgrader.this._copyToNewCache(cacheEntry);
                }
            });
        }
        catch (Exception exception) {
            Trace.ignoredException(exception);
            return null;
        }
    }

    private CacheEntry _copyToNewCache(CacheEntry cacheEntry) {
        Object object;
        if (CacheUpgrader.isTracing()) {
            CacheUpgrader.trace(this + " start copying entry: " + cacheEntry.getDataFile());
        }
        CacheEntry cacheEntry2 = null;
        try {
            object = new URL(cacheEntry.getURL());
            String string = cacheEntry.getVersion();
            String string2 = Cache.generateCacheFileName((URL)object, string);
            File file = new File(this.newCacheDir, string2 + ".idx");
            cacheEntry2 = new CacheEntry(file);
            File file2 = new File(cacheEntry.getResourceFilename());
            File file3 = new File(this.newCacheDir, string2);
            file3.getParentFile().mkdirs();
            Cache.copyFile(file2, file3);
            File file4 = new File(cacheEntry.getNativeLibPath());
            if (file4.isDirectory()) {
                CacheUpgrader.copyDirIgnoresErrors(file4, new File(cacheEntry2.getNativeLibPath()));
            }
            cacheEntry2.setURL(((URL)object).toString());
            cacheEntry2.setContentLength(cacheEntry.getContentLength());
            cacheEntry2.setLastModified(cacheEntry.getLastModified());
            cacheEntry2.setExpirationDate(cacheEntry.getExpirationDate());
            if (string != null) {
                cacheEntry2.setVersion(string);
            }
            cacheEntry2.setHeaders(cacheEntry.cloneHeaders());
            cacheEntry2.setBusy(0);
            cacheEntry2.setIncomplete(0);
            cacheEntry2.writeFileToDisk();
            Cache.recordLastAccessed();
            if (cacheEntry2.isJNLPFile()) {
                this.upgradeLocalAppProperties(cacheEntry2, cacheEntry);
            }
        }
        catch (Exception exception) {
            if (cacheEntry2 != null) {
                Cache.removeCacheEntry(cacheEntry2);
            }
            Trace.ignoredException(exception);
            cacheEntry2 = null;
        }
        if (CacheUpgrader.isTracing()) {
            object = cacheEntry2 == null ? " failed" : cacheEntry2.getDataFile() + " done.";
            System.out.println(this + " copy entry: " + (String)object);
        }
        return cacheEntry2;
    }

    protected void upgradeLocalAppProperties(CacheEntry cacheEntry, CacheEntry cacheEntry2) {
        CacheUpgradeHelper.upgradeLocalAppProperties(cacheEntry, cacheEntry2);
    }

    boolean isUpgradeDone() {
        return this.getStatus().isDone();
    }

    private static String getClassPath() {
        String string = SystemUtils.getJarPath(Object.class);
        File file = new File(string, "jsse.jar");
        String string2 = SystemUtils.getJarPath(CacheUpgrader.class);
        return CacheUpgradeHelper.getHelperJarPaths() + ';' + string2 + ';' + string + ';' + file.getPath();
    }

    private static synchronized void startBackgroundUpgradeIfNeeded() {
        if (backgroundRunning) {
            return;
        }
        backgroundRunning = true;
        try {
            if (CacheUpgrader.noBackgroundUpgradeStartedRecenty()) {
                final String[] stringArray = new String[]{Environment.getJavawCommand(), "-Xbootclasspath:" + CacheUpgrader.getClassPath(), CacheUpgrader.class.getName()};
                if (CacheUpgrader.isTracing()) {
                    String string = Arrays.asList(stringArray).toString();
                    CacheUpgrader.trace("Starting background upgrade: " + string);
                }
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws IOException {
                        Process process = Runtime.getRuntime().exec(stringArray);
                        Thread thread = SafeThreadFactory.createThread(new ProcesOutputHandler(process.getInputStream()));
                        thread.setDaemon(true);
                        thread.start();
                        Thread thread2 = SafeThreadFactory.createThread(new ProcesOutputHandler(process.getErrorStream()));
                        thread2.setDaemon(true);
                        thread2.start();
                        return null;
                    }
                });
            }
        }
        catch (Exception exception) {
            Trace.ignored(exception);
        }
    }

    private static boolean noBackgroundUpgradeStartedRecenty() throws IOException {
        return !CacheUpgrader.getInstance().isBackgroundUpgradeStartedRecenty() && !CacheUpgrader.getSystemInstance().isBackgroundUpgradeStartedRecenty();
    }

    boolean isBackgroundUpgradeStartedRecenty() {
        return this.getStatus().wasStartedRecently();
    }

    public static void setupServices() {
        String string = System.getProperty("os.name");
        if (string.startsWith("Win")) {
            ServiceManager.setService(33024);
        } else if (string.indexOf("OS X") != -1) {
            ServiceManager.setService(40960);
        } else {
            ServiceManager.setService(36864);
        }
    }

    private static void initTrace() {
        if (Config.getBooleanProperty("deployment.trace")) {
            File file = new File(Config.getStringProperty("deployment.user.logdir"));
            if (file.exists() && file.isDirectory()) {
                FileTraceListener fileTraceListener = new FileTraceListener(new File(file, "cacheUpgrade.trace"), false);
                Trace.addTraceListener(fileTraceListener);
            }
            Trace.redirectStdioStderr();
            Trace.setEnabled(TraceLevel.CACHE, true);
            Trace.setEnabled(TraceLevel.BASIC, true);
            Trace.setEnabled(TraceLevel.TEMP, true);
        }
    }

    protected static boolean isTracing() {
        return Trace.isEnabled(TraceLevel.CACHE);
    }

    protected static void trace(String string) {
        Trace.println(string, TraceLevel.CACHE);
    }

    protected static void trace(Exception exception) {
        Trace.ignoredException(exception);
    }

    static void initializeUpgraderKeys() {
        if (!UpgradeStatus.beenInitialized("Cache6Upgrader")) {
            UpgradeStatus.initialized("Cache6Upgrader");
        }
        if (!UpgradeStatus.beenInitialized("SystemCache6Upgrader")) {
            UpgradeStatus.initialized("SystemCache6Upgrader");
        }
    }

    public static void main(String[] stringArray) {
        backgroundRunning = true;
        CacheUpgrader.initTrace();
        CacheUpgrader.trace("Start upgraders");
        try {
            CacheUpgrader.setupServices();
            CacheUpgrader.getSystemInstance().upgrade();
            CacheUpgrader.getInstance().upgrade();
        }
        catch (IOException iOException) {
            CacheUpgrader.trace(iOException);
        }
        CacheUpgrader.trace("End upgraders");
    }

    static {
        NOOP_STATUS = UpgradeStatus.getUpgradeStatus("noopUpgradeBegin", Long.MAX_VALUE, "noopUpgradeCount", Integer.MAX_VALUE);
        SEP = File.separator;
    }

    static class ProcesOutputHandler
    implements Runnable {
        private BufferedReader reader;

        public ProcesOutputHandler(InputStream inputStream) {
            this.reader = new BufferedReader(new InputStreamReader(inputStream));
        }

        @Override
        public void run() {
            try {
                String string = null;
                while ((string = this.reader.readLine()) != null) {
                    Trace.print(string, TraceLevel.CACHE);
                }
            }
            catch (IOException iOException) {
                Trace.ignored(iOException);
            }
        }
    }

    private static class NoopUpgrader
    extends CacheUpgrader {
        public NoopUpgrader() {
            super("Noop-Upgrader", null, null);
        }

        @Override
        protected void upgradeImpl() {
        }

        @Override
        protected CacheEntry upgradeItemImpl(URL uRL, String string, int n) {
            return null;
        }

        @Override
        protected UpgradeStatus getStatus() {
            return NOOP_STATUS;
        }

        @Override
        protected boolean incrementUpgradeAttempts() {
            return true;
        }

        @Override
        protected void setUpgradeCompleted() {
        }

        @Override
        boolean isBackgroundUpgradeStartedRecenty() {
            return false;
        }

        @Override
        boolean isUpgradeDone() {
            return true;
        }
    }
}

