/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net;

import com.sun.applet2.preloader.CancelException;
import com.sun.deploy.Environment;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.Platform;
import com.sun.deploy.net.CanceledDownloadException;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.net.HttpDownload;
import com.sun.deploy.net.HttpDownloadListener;
import com.sun.deploy.net.HttpRequest;
import com.sun.deploy.net.HttpUtils;
import com.sun.deploy.net.MessageHeader;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.SafeThreadFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.SortedMap;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

final class HttpDownloadHelper
implements HttpDownload {
    private static final int BUF_SIZE = 32768;
    private static final int BUFFER_SIZE = 8192;
    private static final String JAR_FILE_EXT = ".jar";
    private static final String JARJAR_FILE_EXT = ".jarjar";
    private static final String META_FILE_DIR = "meta-inf/";
    private HttpRequest _httpRequest;
    private static int jarCompression = -1;

    public HttpDownloadHelper(HttpRequest httpRequest) {
        this._httpRequest = httpRequest;
    }

    private static int getJarCompressionLevel() {
        if (jarCompression == -1) {
            String string = Config.getStringProperty("deployment.cache.jarcompression");
            string = string.trim();
            try {
                jarCompression = Integer.valueOf(string);
                if (jarCompression < 0 || jarCompression > 9) {
                    jarCompression = 0;
                }
            }
            catch (NumberFormatException numberFormatException) {
                jarCompression = 0;
            }
        }
        return jarCompression;
    }

    static int checkAndNotifyProgress(Pack200.Unpacker unpacker, HttpDownloadListener httpDownloadListener, int n, int n2) {
        SortedMap sortedMap = unpacker.properties();
        String string = (String)sortedMap.get("unpack.progress");
        if (string == null) {
            return n;
        }
        int n3 = Integer.parseInt(string);
        if (httpDownloadListener != null && n3 != n) {
            try {
                httpDownloadListener.downloadProgress(n3 * n2 / 100, n2);
            }
            catch (CancelException cancelException) {
                // empty catch block
            }
        }
        return n3;
    }

    static void unpack(Pack200.Unpacker unpacker, InputStream inputStream, JarOutputStream jarOutputStream, HttpDownloadListener httpDownloadListener, int n) throws IOException {
        IOException iOException;
        UnpackerTask unpackerTask = new UnpackerTask(unpacker, inputStream, jarOutputStream);
        Thread thread = SafeThreadFactory.createThread(unpackerTask);
        thread.start();
        int n2 = 0;
        boolean bl = false;
        while (thread.isAlive()) {
            n2 = HttpDownloadHelper.checkAndNotifyProgress(unpacker, httpDownloadListener, n2, n);
            try {
                thread.join(200L);
            }
            catch (InterruptedException interruptedException) {
                bl = true;
            }
        }
        HttpDownloadHelper.checkAndNotifyProgress(unpacker, httpDownloadListener, n2, n);
        if (bl) {
            Thread.currentThread().interrupt();
        }
        if ((iOException = unpackerTask.ioe()) != null) {
            throw iOException;
        }
    }

    public MessageHeader download(int n, URL uRL, InputStream inputStream, String string, File file, HttpDownloadListener httpDownloadListener, int n2) throws CanceledDownloadException, IOException {
        return this.download(n, uRL, inputStream, string, file, httpDownloadListener, n2, true);
    }

    @Override
    public MessageHeader download(int n, URL uRL, InputStream inputStream, String string, File file, HttpDownloadListener httpDownloadListener, int n2, boolean bl) throws CanceledDownloadException, IOException {
        MessageHeader messageHeader = null;
        boolean bl2 = HttpDownloadHelper.needsGUnzip(bl, string);
        int n3 = n;
        if (httpDownloadListener != null) {
            httpDownloadListener.downloadProgress(0, n3);
        }
        if (Trace.isEnabled(TraceLevel.NETWORK)) {
            Trace.println(ResourceManager.getString("httpDownloadHelper.doingDownload", uRL == null ? "" : uRL.toString(), n, string), TraceLevel.NETWORK);
        }
        OutputStream outputStream = null;
        ZipOutputStream zipOutputStream = null;
        ZipInputStream zipInputStream = null;
        ZipInputStream zipInputStream2 = null;
        boolean bl3 = false;
        try {
            outputStream = Platform.get().getNativeSandboxBroker().getOutputStream(file, true);
            if ("pack200-gzip".equals(string)) {
                Pack200.Unpacker unpacker = Pack200.newUnpacker();
                JarOutputStream jarOutputStream = new JarOutputStream(outputStream);
                if (Environment.isJavaPlugin() && HttpDownloadHelper.getJarCompressionLevel() != 0) {
                    jarOutputStream.setLevel(HttpDownloadHelper.getJarCompressionLevel());
                }
                HttpDownloadHelper.unpack(unpacker, new GZIPInputStream(inputStream), jarOutputStream, httpDownloadListener, n3);
                jarOutputStream.close();
                messageHeader = this.createHeaderAdjustment(file.length(), null);
            } else {
                String string2 = HttpUtils.removeQueryStringFromURL(uRL).toString().toLowerCase();
                String string3 = string;
                if (this.isJarOrJarjar(string2) && (!HttpUtils.hasGzipEncoding(string) || bl2)) {
                    zipOutputStream = new JarOutputStream(outputStream);
                    if (HttpDownloadHelper.getJarCompressionLevel() != 0) {
                        zipOutputStream.setLevel(HttpDownloadHelper.getJarCompressionLevel());
                    }
                    if (bl2) {
                        zipInputStream = new ZipInputStream(new GZIPInputStream((InputStream)new BufferedInputStream(inputStream), 8192));
                        this.decompressWrite(zipInputStream, zipOutputStream, n3, httpDownloadListener);
                        string3 = HttpUtils.removeGzipEncoding(string);
                    } else {
                        ZipEntry zipEntry;
                        zipInputStream = new ZipInputStream(new BufferedInputStream(inputStream, 8192));
                        if (string2.endsWith(JARJAR_FILE_EXT)) {
                            Trace.msgPrintln("cache.jarjar.deprecated", new Object[]{string2});
                            zipEntry = zipInputStream.getNextEntry();
                            while (zipEntry != null) {
                                if (zipEntry.toString().toLowerCase().startsWith(META_FILE_DIR)) {
                                    zipEntry = zipInputStream.getNextEntry();
                                    continue;
                                }
                                if (zipEntry.toString().toLowerCase().endsWith(JAR_FILE_EXT)) break;
                                throw new IOException("cache.jarjar.invalid_file");
                            }
                            zipInputStream2 = zipInputStream;
                            zipInputStream = new ZipInputStream(zipInputStream);
                        }
                        this.decompressWrite(zipInputStream, zipOutputStream, n3, httpDownloadListener);
                        if (zipInputStream2 != null && (zipEntry = zipInputStream2.getNextEntry()) != null) {
                            String string4 = null;
                            string4 = !zipEntry.toString().toLowerCase().endsWith(JAR_FILE_EXT) ? "cache.jarjar.invalid_file" : "cache.jarjar.multiple_jar";
                            throw new IOException(string4);
                        }
                    }
                    if (zipOutputStream != null) {
                        zipOutputStream.close();
                        zipOutputStream = null;
                    }
                    messageHeader = this.createHeaderAdjustment(file.length(), string3);
                } else {
                    FilterInputStream filterInputStream = new BufferedInputStream(inputStream);
                    if (bl2) {
                        filterInputStream = new GZIPInputStream((InputStream)filterInputStream, 8192);
                        string3 = HttpUtils.removeGzipEncoding(string);
                    }
                    int n4 = 0;
                    int n5 = 0;
                    byte[] byArray = new byte[32768];
                    int n6 = 0;
                    while ((n4 = ((InputStream)filterInputStream).read(byArray, 0, byArray.length)) != -1) {
                        if (DownloadEngine.isJarContentType(n2) && n6 == 0 && !DownloadEngine.isJarHeaderValid(byArray)) {
                            throw new IOException("Invalid jar file");
                        }
                        outputStream.write(byArray, 0, n4);
                        n5 += n4;
                        if (httpDownloadListener != null) {
                            int n7 = n5;
                            if (n7 > n3 && n3 != 0) {
                                n7 = n3;
                            }
                            httpDownloadListener.downloadProgress(n7, n3);
                        }
                        ++n6;
                    }
                    if (bl2) {
                        messageHeader = this.createHeaderAdjustment(n5, string3);
                    }
                }
            }
            if (Trace.isEnabled(TraceLevel.NETWORK)) {
                Trace.println(ResourceManager.getString("httpDownloadHelper.wroteUrlToFile", uRL == null ? "" : uRL.toString(), file == null ? "" : file.toString()), TraceLevel.NETWORK);
            }
        }
        catch (IOException iOException) {
            bl3 = true;
            throw iOException;
        }
        finally {
            if (zipInputStream2 != null) {
                zipInputStream2.close();
            } else if (zipInputStream != null) {
                zipInputStream.close();
            } else if (inputStream != null) {
                inputStream.close();
            }
            if (zipOutputStream != null) {
                zipOutputStream.close();
            } else if (outputStream != null) {
                outputStream.close();
            }
            if (bl3 && file != null) {
                Platform.get().getNativeSandboxBroker().deleteFile(file);
            }
        }
        if (httpDownloadListener != null) {
            httpDownloadListener.downloadProgress(n3, n3);
        }
        return messageHeader;
    }

    private static boolean needsGUnzip(boolean bl, String string) {
        return bl && HttpUtils.hasGzipEncoding(string);
    }

    private MessageHeader createHeaderAdjustment(long l, String string) {
        MessageHeader messageHeader = new MessageHeader();
        messageHeader.add("content-encoding", string);
        String string2 = l > -1L ? String.valueOf(l) : null;
        messageHeader.add("content-length", string2);
        return messageHeader;
    }

    private void decompressWrite(ZipInputStream zipInputStream, ZipOutputStream zipOutputStream, int n, HttpDownloadListener httpDownloadListener) throws IOException {
        byte[] byArray = new byte[8192];
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        int n2 = 0;
        while (zipEntry != null) {
            ZipEntry zipEntry2 = (ZipEntry)zipEntry.clone();
            zipEntry2.setCompressedSize(-1L);
            zipOutputStream.putNextEntry(zipEntry2);
            int n3 = 0;
            while ((n3 = zipInputStream.read(byArray, 0, byArray.length)) != -1) {
                zipOutputStream.write(byArray, 0, n3);
                if ((n2 += n3) > n && n != 0) {
                    n2 = n;
                }
                if (httpDownloadListener == null) continue;
                httpDownloadListener.downloadProgress(n2, n);
            }
            zipOutputStream.closeEntry();
            zipEntry = zipInputStream.getNextEntry();
        }
        zipOutputStream.flush();
    }

    private boolean isJarOrJarjar(String string) {
        return string.endsWith(JAR_FILE_EXT) || string.endsWith(JARJAR_FILE_EXT);
    }

    private static class UnpackerTask
    implements Runnable {
        private final Pack200.Unpacker unpacker;
        private final InputStream in;
        private final JarOutputStream out;
        private volatile IOException ioe;

        UnpackerTask(Pack200.Unpacker unpacker, InputStream inputStream, JarOutputStream jarOutputStream) {
            this.unpacker = unpacker;
            this.in = inputStream;
            this.out = jarOutputStream;
        }

        IOException ioe() {
            return this.ioe;
        }

        @Override
        public void run() {
            try {
                this.unpacker.unpack(this.in, this.out);
            }
            catch (IOException iOException) {
                this.ioe = iOException;
            }
        }
    }
}

