/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class MessageHeader {
    private String[] keys;
    private String[] values;
    private int nkeys;

    public MessageHeader() {
        this.grow();
    }

    public MessageHeader(MessageHeader messageHeader) {
        this.keys = (String[])messageHeader.keys.clone();
        this.values = (String[])messageHeader.values.clone();
        this.nkeys = messageHeader.nkeys;
    }

    synchronized String findValue(String string) {
        if (string == null) {
            int n = this.nkeys;
            while (--n >= 0) {
                if (this.keys[n] != null) continue;
                return this.values[n];
            }
        } else {
            int n = this.nkeys;
            while (--n >= 0) {
                if (!string.equalsIgnoreCase(this.keys[n])) continue;
                return this.values[n];
            }
        }
        return null;
    }

    public synchronized int getKey(String string) {
        int n = this.nkeys;
        while (--n >= 0) {
            if (this.keys[n] != string && (string == null || !string.equalsIgnoreCase(this.keys[n]))) continue;
            return n;
        }
        return -1;
    }

    public synchronized String getKey(int n) {
        if (n < 0 || n >= this.nkeys) {
            return null;
        }
        return this.keys[n];
    }

    public synchronized String getValue(int n) {
        if (n < 0 || n >= this.nkeys) {
            return null;
        }
        return this.values[n];
    }

    public synchronized Map<String, List<String>> getHeaders() {
        HashMap<Object, List<Object>> hashMap = new HashMap<Object, List<Object>>();
        int n = this.nkeys;
        while (--n >= 0) {
            List list = (List)hashMap.get(this.keys[n]);
            if (list == null) {
                list = new ArrayList();
                hashMap.put(this.keys[n], list);
            }
            list.add(this.values[n]);
        }
        for (List list : hashMap.keySet()) {
            List list2 = (List)hashMap.get(list);
            hashMap.put(list, Collections.unmodifiableList(list2));
        }
        return Collections.unmodifiableMap(hashMap);
    }

    public synchronized void add(String string, String string2) {
        this.grow();
        this.keys[this.nkeys] = string;
        this.values[this.nkeys] = string2;
        ++this.nkeys;
    }

    public static MessageHeader merge(MessageHeader messageHeader, MessageHeader messageHeader2) {
        String string;
        if (messageHeader2 == null) {
            return messageHeader;
        }
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(messageHeader2.keys));
        MessageHeader messageHeader3 = new MessageHeader();
        for (int i = 0; i < messageHeader.keys.length; ++i) {
            String string2 = messageHeader.keys[i];
            string = messageHeader.values[i];
            if (string2 == null) {
                if (string == null) continue;
                messageHeader3.add(string2, string);
                continue;
            }
            int n = messageHeader2.getKey(string2);
            if (n == -1) {
                if (string == null) continue;
                messageHeader3.add(string2, string);
                continue;
            }
            hashSet.remove(string2);
            String string3 = messageHeader2.values[n];
            if (string3 == null) continue;
            messageHeader3.add(string2, string3);
        }
        for (String string2 : hashSet) {
            string = messageHeader2.findValue(string2);
            if (string == null) continue;
            messageHeader3.add(string2, string);
        }
        return messageHeader3;
    }

    private void grow() {
        if (this.keys == null || this.nkeys >= this.keys.length) {
            String[] stringArray = new String[this.nkeys + 4];
            String[] stringArray2 = new String[this.nkeys + 4];
            if (this.keys != null) {
                System.arraycopy(this.keys, 0, stringArray, 0, this.nkeys);
            }
            if (this.values != null) {
                System.arraycopy(this.values, 0, stringArray2, 0, this.nkeys);
            }
            this.keys = stringArray;
            this.values = stringArray2;
        }
    }

    public synchronized String toString() {
        String string = super.toString();
        for (int i = 0; i < this.keys.length; ++i) {
            string = string + "{" + this.keys[i] + ": " + this.values[i] + "}";
        }
        return string;
    }

    public int getContentLength(int n) {
        String string = this.findValue("content-length");
        if (string != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }
}

