/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net.proxy;

import com.sun.deploy.net.proxy.DynamicProxyManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URL;
import java.util.List;

public class DeployProxySelector
extends ProxySelector {
    public static void reset() {
        DynamicProxyManager.reset();
        ProxySelector.setDefault(new DeployProxySelector());
    }

    protected URL getURLFromURI(URI uRI, boolean bl) {
        Object object;
        if (uRI == null) {
            return null;
        }
        int n = uRI.getPort();
        Object object2 = uRI.getHost();
        if (object2 == null && (object = uRI.getAuthority()) != null) {
            int n2 = ((String)object).indexOf(64);
            if (n2 >= 0) {
                object = ((String)object).substring(n2 + 1);
            }
            if ((n2 = ((String)object).lastIndexOf(58)) >= 0) {
                try {
                    n = Integer.parseInt(((String)object).substring(n2 + 1));
                }
                catch (NumberFormatException numberFormatException) {
                    n = -1;
                }
                object = ((String)object).substring(0, n2);
            }
            object2 = object;
        }
        object = null;
        try {
            String string = uRI.getScheme();
            object = bl ? (n == -1 ? new URL("http://" + (String)object2 + "/") : new URL("http://" + (String)object2 + ":" + n + "/")) : uRI.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        return object;
    }

    @Override
    public List<Proxy> select(URI uRI) {
        if (uRI == null) {
            throw new IllegalArgumentException();
        }
        String string = uRI.getScheme();
        boolean bl = string.equalsIgnoreCase("socket") || string.equalsIgnoreCase("serversocket");
        URL uRL = this.getURLFromURI(uRI, bl);
        List<Proxy> list = null;
        try {
            list = DynamicProxyManager.getProxyList(uRL, bl);
            if (Trace.isEnabled(TraceLevel.NETWORK)) {
                Trace.msgNetPrintln("net.proxy.connect", new Object[]{uRI, list.get(0)});
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return list;
    }

    @Override
    public void connectFailed(URI uRI, SocketAddress socketAddress, IOException iOException) {
        if (uRI == null || socketAddress == null || iOException == null) {
            throw new IllegalArgumentException("Arguments can't be null.");
        }
        if (Trace.isEnabled(TraceLevel.NETWORK)) {
            Trace.msgNetPrintln("net.proxy.connectionFailure", new Object[]{uRI.toString() + ", " + socketAddress.toString() + iOException.toString()});
        }
        try {
            DynamicProxyManager.removeProxyFromCache(uRI.toURL(), socketAddress.toString());
        }
        catch (Exception exception) {
            Trace.securityPrintException(exception);
        }
    }
}

