/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net.proxy;

import com.sun.deploy.Environment;
import com.sun.deploy.config.Platform;
import com.sun.deploy.net.proxy.BrowserProxyInfo;
import com.sun.deploy.net.proxy.ProxyConfigException;
import com.sun.deploy.net.proxy.ProxyHandler;
import com.sun.deploy.net.proxy.ProxyInfo;
import com.sun.deploy.net.proxy.ProxyUnavailableException;
import com.sun.deploy.trace.Trace;
import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import java.util.Properties;

public class MSystemProxyHandler
implements ProxyHandler {
    protected static boolean hasSystemProxies;

    @Override
    public final boolean isSupported(int n) {
        return n == 4;
    }

    @Override
    public final boolean isProxyCacheSupported() {
        return false;
    }

    @Override
    public final void init(BrowserProxyInfo browserProxyInfo) throws ProxyConfigException {
        Trace.msgNetPrintln("net.proxy.loading.system");
        if (!this.isSupported(browserProxyInfo.getType())) {
            throw new ProxyConfigException("Unable to support proxy type: " + browserProxyInfo.getType());
        }
        Trace.msgNetPrintln("net.proxy.loading.done");
    }

    @Override
    public final ProxyInfo[] getProxyInfo(URL uRL) throws ProxyUnavailableException {
        ProxyInfo[] proxyInfoArray = new ProxyInfo[1];
        String string = uRL.getProtocol();
        String string2 = uRL.getHost();
        String string3 = this.getSystemProxyFromEnv(string);
        if (string3 == null) {
            string3 = this.getSystemProxyFromEtc(string);
        }
        if (hasSystemProxies && string3 == null) {
            string3 = this.getSystemProxy(string, string2);
        }
        if (string3 == null) {
            return new ProxyInfo[]{new ProxyInfo(null)};
        }
        proxyInfoArray[0] = new ProxyInfo(string3);
        return proxyInfoArray;
    }

    private String getSystemProxyFromEtc(String string) {
        String string2 = ProxyEnvVars.valueOf(string.toUpperCase(Locale.ENGLISH)).getEnvVar();
        final File file = new File("/etc/environment");
        Properties properties = (Properties)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Properties properties = new Properties();
                if (file.exists()) {
                    try {
                        properties.load(new FileInputStream(file));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                return properties;
            }
        });
        if (properties.isEmpty()) {
            return null;
        }
        String string3 = (String)properties.get(string2);
        if (string3 == null) {
            string3 = (String)properties.get(string2.toUpperCase(Locale.ENGLISH));
        }
        return string3 != null ? string3.replaceAll("^\"|\"$", "") : null;
    }

    private String getSystemProxyFromEnv(String string) {
        String string2 = ProxyEnvVars.valueOf(string.toUpperCase(Locale.ENGLISH)).getEnvVar();
        String string3 = Environment.getenv(string2);
        if (string3 == null) {
            string3 = Environment.getenv(string2.toUpperCase(Locale.ENGLISH));
        }
        return string3;
    }

    protected static native boolean init();

    protected native String getSystemProxy(String var1, String var2);

    static {
        Platform.get().loadDeployNativeLib();
        hasSystemProxies = false;
        hasSystemProxies = MSystemProxyHandler.init();
    }

    private static enum ProxyEnvVars {
        HTTP("http_proxy"),
        HTTPS("https_proxy"),
        FTP("ftp_proxy"),
        GOPHER("gopher_proxy"),
        SOCKS("all_proxy");

        private final String env_var;

        private ProxyEnvVars(String string2) {
            this.env_var = string2;
        }

        String getEnvVar() {
            return this.env_var;
        }
    }
}

