/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net.proxy.pac;

import com.sun.deploy.net.proxy.pac.PACFunctions;
import java.net.InetAddress;
import java.net.SocketPermission;
import java.net.UnknownHostException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.StringTokenizer;

public class PACFunctionsImpl
implements PACFunctions {
    private static final AccessControlContext ACC_SOCKET_INSTANCE;

    @Override
    public boolean dnsDomainIs(String string, String string2) {
        if (string2 != null && string2.charAt(0) != '.') {
            return this.shExpMatch(string, string2);
        }
        return this.shExpMatch(string, "*" + string2);
    }

    @Override
    public boolean shExpMatch(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "*");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            int n2 = string.indexOf(string3, n);
            if (n2 < 0) {
                return false;
            }
            n = n2 + string3.length();
        }
        return n >= string.length() || string2.endsWith("*");
    }

    @Override
    public String myIpAddress() {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return PACFunctionsImpl.this.myIpAddressImpl();
            }
        });
    }

    private String myIpAddressImpl() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            return inetAddress.getHostAddress();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return "127.0.0.1";
        }
    }

    @Override
    public String dnsResolve(final String string) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return PACFunctionsImpl.this.dnsResolveImpl(string);
            }
        }, ACC_SOCKET_INSTANCE);
    }

    private String dnsResolveImpl(String string) {
        String string2 = "";
        try {
            string2 = InetAddress.getByName(string).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
        }
        return string2;
    }

    @Override
    public boolean isPlainHostName(String string) {
        return !string.contains(".");
    }

    @Override
    public boolean localHostOrDomainIs(String string, String string2) {
        return this.shExpMatch(string2, string + "*");
    }

    @Override
    public boolean isResolvable(String string) {
        return !"".equals(this.dnsResolve(string));
    }

    @Override
    public int dnsDomainLevels(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '.') continue;
            ++n;
        }
        return n;
    }

    static {
        Permissions permissions = new Permissions();
        SocketPermission socketPermission = new SocketPermission("*", "connect,resolve");
        ((PermissionCollection)permissions).add(socketPermission);
        ACC_SOCKET_INSTANCE = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, permissions)});
    }
}

