/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.si;

import com.sun.deploy.config.Config;
import com.sun.deploy.config.Platform;
import com.sun.deploy.si.DeploySIListener;
import com.sun.deploy.si.SingleInstanceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.SafeThreadFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Iterator;

public class SingleInstanceImpl {
    public static final String SI_FILEDIR = Config.getTempDirectory() + File.separator + "si" + File.separator;
    public static final String SI_MAGICWORD = "javaws.singleinstance.init";
    public static final String SI_MAGICWORD_OPENPRINT = "javaws.singleinstance.init.openprint";
    public static final String SI_ACK = "javaws.singleinstance.ack";
    public static final String SI_STOP = "javaws.singleinstance.stop";
    public static final String SI_EOF = "EOF";
    private ArrayList<DeploySIListener> _sil_list = new ArrayList();
    private static boolean _serverStarted = false;
    private Object _lock = new Object();
    private SingleInstanceServer _sis;
    private static int DEFAULT_FILESIZE = Integer.MAX_VALUE;
    private static final SecureRandom random = new SecureRandom();
    private static int _randomNumber;

    public static String getSingleInstanceFilePrefix(String string) {
        String string2 = string.replace('/', '_');
        string2 = string2.replace(':', '_');
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSingleInstanceListener(DeploySIListener deploySIListener, String string) {
        if (deploySIListener == null) {
            return;
        }
        ArrayList<DeploySIListener> arrayList = this._lock;
        synchronized (arrayList) {
            if (!_serverStarted) {
                Trace.println("unique id: " + string, TraceLevel.BASIC);
                try {
                    String string2 = string + Platform.get().getSessionSpecificString();
                    this._sis = new SingleInstanceServer(string2, this);
                    this._sis.start();
                }
                catch (Exception exception) {
                    Trace.println("addSingleInstanceListener failed", TraceLevel.BASIC);
                    Trace.ignoredException(exception);
                    return;
                }
                _serverStarted = true;
            }
        }
        arrayList = this._sil_list;
        synchronized (arrayList) {
            if (!this._sil_list.contains(deploySIListener)) {
                this._sil_list.add(deploySIListener);
            }
        }
    }

    public boolean isSame(String string, String string2) {
        return true;
    }

    public String[] getArguments(String string, String string2) {
        String[] stringArray = new String[]{string};
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSingleInstanceListener(DeploySIListener deploySIListener) {
        ArrayList<DeploySIListener> arrayList = this._sil_list;
        synchronized (arrayList) {
            Object object = deploySIListener.getSingleInstanceListener();
            Object object2 = null;
            int n = -1;
            for (int i = 0; i < this._sil_list.size(); ++i) {
                object2 = this._sil_list.get(i).getSingleInstanceListener();
                if (!object2.equals(object)) continue;
                n = i;
                break;
            }
            if (n < 0 || n >= this._sil_list.size()) {
                return;
            }
            this._sil_list.remove(n);
            if (this._sil_list.isEmpty()) {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        try {
                            Socket socket = new Socket("127.0.0.1", SingleInstanceImpl.this._sis.getPort());
                            OutputStream outputStream = socket.getOutputStream();
                            byte[] byArray = new byte[]{1};
                            outputStream.write(byArray);
                            String string = Charset.defaultCharset().name();
                            PrintStream printStream = new PrintStream(outputStream, true, string);
                            printStream.println(_randomNumber);
                            printStream.println(SingleInstanceImpl.SI_STOP);
                            printStream.flush();
                            socket.close();
                            _serverStarted = false;
                        }
                        catch (IOException iOException) {
                            Trace.ignoredException(iOException);
                        }
                        return null;
                    }
                });
            }
        }
    }

    private class SingleInstanceServerRunnable
    implements Runnable {
        ServerSocket _ss;
        int _port;
        String _idString;
        String[] _arguments;
        SingleInstanceImpl _impl;

        int getPort() {
            return this._port;
        }

        SingleInstanceServerRunnable(String string, SingleInstanceImpl singleInstanceImpl2) throws IOException {
            this._idString = string;
            this._impl = singleInstanceImpl2;
            this._ss = null;
            this._ss = new ServerSocket(0, 0, InetAddress.getByName("127.0.0.1"));
            this._port = this._ss.getLocalPort();
            Trace.println("server port at: " + this._port, TraceLevel.BASIC);
            this.createSingleInstanceFile(this._idString, this._port);
        }

        private String getSingleInstanceFilename(String string, int n) {
            String string2 = SI_FILEDIR + SingleInstanceImpl.getSingleInstanceFilePrefix(string) + "_" + n;
            Trace.println("getSingleInstanceFilename: " + string2, TraceLevel.BASIC);
            return string2;
        }

        private void removeSingleInstanceFile(String string, int n) {
            new File(this.getSingleInstanceFilename(string, n)).delete();
            Trace.println("removed SingleInstanceFile: " + this.getSingleInstanceFilename(string, n), TraceLevel.BASIC);
        }

        private void createSingleInstanceFile(final String string, int n) {
            String string2 = this.getSingleInstanceFilename(string, n);
            final File file = new File(string2);
            final File file2 = new File(SI_FILEDIR);
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    file2.mkdirs();
                    String[] stringArray = file2.list();
                    if (stringArray != null) {
                        for (int i = 0; i < stringArray.length; ++i) {
                            if (!stringArray[i].startsWith(SingleInstanceImpl.getSingleInstanceFilePrefix(string))) continue;
                            Trace.println("file should be removed: " + SI_FILEDIR + stringArray[i], TraceLevel.BASIC);
                            new File(SI_FILEDIR + stringArray[i]).delete();
                        }
                    }
                    try {
                        file.createNewFile();
                        file.deleteOnExit();
                        PrintStream printStream = new PrintStream(new FileOutputStream(file));
                        _randomNumber = random.nextInt();
                        printStream.print(_randomNumber);
                        printStream.close();
                    }
                    catch (IOException iOException) {
                        Trace.ignoredException(iOException);
                    }
                    return null;
                }
            });
        }

        boolean isSameInstance(String string) {
            if (this._impl.isSame(string, this._idString)) {
                this._arguments = this._impl.getArguments(string, this._idString);
                return true;
            }
            return false;
        }

        @Override
        public void run() {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void run() {
                    while (true) {
                        InputStream inputStream = null;
                        Socket socket = null;
                        String string = null;
                        String string2 = "";
                        boolean bl = false;
                        int n = -1;
                        String string3 = null;
                        try {
                            Iterator iterator;
                            Trace.println("waiting connection", TraceLevel.BASIC);
                            socket = SingleInstanceServerRunnable.this._ss.accept();
                            inputStream = socket.getInputStream();
                            int n2 = inputStream.read();
                            if (n2 == 1) {
                                string3 = Charset.defaultCharset().name();
                            } else if (n2 == 2) {
                                string3 = "UTF-16LE";
                            } else {
                                Trace.println("SingleInstanceImpl - unknown encoding", TraceLevel.BASIC);
                                iterator = null;
                                return iterator;
                            }
                            iterator = new BufferedReader(new InputStreamReader(inputStream, string3));
                            string = ((BufferedReader)((Object)iterator)).readLine();
                            if (!string.equals(String.valueOf(_randomNumber))) {
                                SingleInstanceServerRunnable.this.removeSingleInstanceFile(SingleInstanceServerRunnable.this._idString, SingleInstanceServerRunnable.this._port);
                                SingleInstanceServerRunnable.this._ss.close();
                                _serverStarted = false;
                                Trace.println("Unexpected Error, SingleInstanceService disabled", TraceLevel.BASIC);
                                Void void_ = null;
                                return void_;
                            }
                            string = ((BufferedReader)((Object)iterator)).readLine();
                            Trace.println("recv: " + string, TraceLevel.BASIC);
                            if (string.equals(SingleInstanceImpl.SI_MAGICWORD)) {
                                Trace.println("got magic word!!!", TraceLevel.BASIC);
                                while (true) {
                                    try {
                                        while ((string = ((BufferedReader)((Object)iterator)).readLine()) == null || !string.equals(SingleInstanceImpl.SI_EOF)) {
                                            string2 = string2 + string;
                                        }
                                    }
                                    catch (IOException iOException) {
                                        Trace.ignoredException(iOException);
                                        continue;
                                    }
                                    break;
                                }
                                Trace.println(string2, TraceLevel.BASIC);
                                if (!SingleInstanceServerRunnable.this.isSameInstance(string2)) continue;
                                bl = true;
                                continue;
                            }
                            if (string.equals(SingleInstanceImpl.SI_STOP)) {
                                SingleInstanceServerRunnable.this.removeSingleInstanceFile(SingleInstanceServerRunnable.this._idString, SingleInstanceServerRunnable.this._port);
                                break;
                            }
                            if (!string.equals(SingleInstanceImpl.SI_MAGICWORD_OPENPRINT)) continue;
                            int n3 = 0;
                            SingleInstanceServerRunnable.this._arguments = new String[2];
                            Trace.println("GOT OPENPRINT MAGICWORD", TraceLevel.BASIC);
                            for (int i = 0; i < 3; ++i) {
                                try {
                                    string = ((BufferedReader)((Object)iterator)).readLine();
                                    if (string != null && string.equals(SingleInstanceImpl.SI_EOF)) break;
                                    Trace.println(string, TraceLevel.BASIC);
                                    if (n3 >= 2) continue;
                                    SingleInstanceServerRunnable.this._arguments[n3] = string;
                                    ++n3;
                                    continue;
                                }
                                catch (IOException iOException) {
                                    Trace.ignoredException(iOException);
                                }
                            }
                            if (n3 == 2) {
                                SingleInstanceManager.setActionName(SingleInstanceServerRunnable.this._arguments[0]);
                                SingleInstanceManager.setOpenPrintFilePath(SingleInstanceServerRunnable.this._arguments[1]);
                            }
                            bl = true;
                            continue;
                        }
                        catch (IOException iOException) {
                            Trace.ignoredException(iOException);
                            continue;
                        }
                        finally {
                            try {
                                if (bl) {
                                    for (int i = 0; i < SingleInstanceServerRunnable.this._arguments.length; ++i) {
                                        Trace.println("Starting new instance with arguments: " + SingleInstanceServerRunnable.this._arguments[i], TraceLevel.BASIC);
                                    }
                                    ArrayList arrayList = (ArrayList)SingleInstanceImpl.this._sil_list.clone();
                                    for (DeploySIListener deploySIListener : arrayList) {
                                        deploySIListener.newActivation(SingleInstanceServerRunnable.this._arguments);
                                    }
                                    Trace.println("sending out ACK..", TraceLevel.BASIC);
                                    PrintStream printStream = new PrintStream(socket.getOutputStream(), true, string3);
                                    printStream.println(SingleInstanceImpl.SI_ACK);
                                    printStream.flush();
                                }
                                if (socket == null) continue;
                                socket.close();
                            }
                            catch (IOException iOException) {
                                Trace.ignoredException(iOException);
                            }
                            continue;
                        }
                        break;
                    }
                    return null;
                }
            });
        }
    }

    class SingleInstanceServer {
        private final SingleInstanceServerRunnable sisr;
        private final Thread thread;

        public SingleInstanceServer(SingleInstanceServerRunnable singleInstanceServerRunnable) throws IOException {
            this.thread = SafeThreadFactory.createThread(singleInstanceServerRunnable);
            this.thread.setDaemon(true);
            this.sisr = singleInstanceServerRunnable;
        }

        public SingleInstanceServer(String string, SingleInstanceImpl singleInstanceImpl2) throws IOException {
            this(singleInstanceImpl.new SingleInstanceServerRunnable(string, singleInstanceImpl2));
        }

        int getPort() {
            return this.sisr.getPort();
        }

        public void start() {
            this.thread.start();
        }
    }
}

