/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.Environment;
import com.sun.deploy.config.BuiltInProperties;
import com.sun.deploy.config.ClientConfig;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.DefaultConfig;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.config.Platform;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.TrustDecider;
import com.sun.deploy.security.ValidationState;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.JarUtil;
import com.sun.deploy.util.SystemUtils;
import com.sun.deploy.util.VersionID;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class SecurityBaseline {
    private static String baseline_131 = BuiltInProperties.getProperty("BASELINE_VERSION_131");
    private static String baseline_142 = BuiltInProperties.getProperty("BASELINE_VERSION_142");
    private static String baseline_150 = BuiltInProperties.getProperty("BASELINE_VERSION_150");
    private static String baseline_160 = BuiltInProperties.getProperty("BASELINE_VERSION_160");
    private static String baseline_170 = BuiltInProperties.getProperty("BASELINE_VERSION_170");
    private static String baseline_180 = BuiltInProperties.getProperty("BASELINE_VERSION_180");
    private static String baseline_190 = BuiltInProperties.getProperty("BASELINE_VERSION_190");
    private static volatile boolean baselines_initialized = false;
    private static final boolean DEBUG = Config.getBooleanProperty("deployment.baseline.debug");
    private static final long UPDATE_INTERVAL = DEBUG ? 10000 : 86400000;
    private static final long THREAD_SLEEP_INTERVAL = DEBUG ? 1000 : 30000;
    private static final String BASELINE_FILENAME = "baseline.versions";
    private static final String SECURITY_PACK_FILENAME = "securitypack.jar";
    private static final String DYNAMIC_BLACKLIST_FILENAME = "blacklist.dynamic";
    private static final String BLACKLIST_CERT_FILENAME = "blacklisted.certs";
    private static final String UPDATE_TIMESTAMP = "update.securitypack.timestamp";
    private static final File securityDir = new File(Config.getLocalOrRoamingUserHome(), "security");
    private static final File securityPackFile = new File(securityDir, "securitypack.jar");
    private static final File baselineFile = new File(securityDir, "baseline.versions");
    private static final File blacklistFile = new File(Config.getDynamicBlacklistFile());
    private static final File blacklistCertsFile = new File(Config.getDynamicBlacklistCertsFile());
    private static final File updateTimestampFile = new File(securityDir, "update.securitypack.timestamp");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initialize_baselines() {
        if (!baselines_initialized && baselineFile.exists()) {
            BufferedReader bufferedReader = null;
            try {
                long l = System.currentTimeMillis();
                bufferedReader = new BufferedReader(new FileReader(baselineFile));
                boolean bl = false;
                while (!bl) {
                    String string = bufferedReader.readLine();
                    if (string == null) {
                        bl = true;
                        continue;
                    }
                    if (string.startsWith("9.")) {
                        baseline_190 = string;
                        Platform.get().cacheSecurityBaseline("9.0", baseline_190);
                        continue;
                    }
                    if (string.startsWith("1.8")) {
                        baseline_180 = string;
                        Platform.get().cacheSecurityBaseline("1.8.0", baseline_180);
                        continue;
                    }
                    if (string.startsWith("1.7")) {
                        baseline_170 = string;
                        Platform.get().cacheSecurityBaseline("1.7.0", baseline_170);
                        continue;
                    }
                    if (string.startsWith("1.6")) {
                        baseline_160 = string;
                        Platform.get().cacheSecurityBaseline("1.6.0", baseline_160);
                        continue;
                    }
                    if (string.startsWith("1.5")) {
                        baseline_150 = string;
                        Platform.get().cacheSecurityBaseline("1.5.0", baseline_150);
                        continue;
                    }
                    if (string.startsWith("1.4.2")) {
                        baseline_142 = string;
                        Platform.get().cacheSecurityBaseline("1.4.2", baseline_142);
                        continue;
                    }
                    if (!string.startsWith("1.3.1")) continue;
                    baseline_131 = string;
                    Platform.get().cacheSecurityBaseline("1.3.1", baseline_131);
                }
                if (DEBUG) {
                    Trace.println("It took " + (System.currentTimeMillis() - l) + " Ms. to read baseline file", TraceLevel.BASIC);
                }
            }
            catch (Exception exception) {
                Trace.ignored(exception);
            }
            finally {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {
                    Trace.ignored(iOException);
                }
            }
        }
        baselines_initialized = true;
    }

    public static String getBaselineVersion(String string) {
        if (!baselines_initialized) {
            SecurityBaseline.initialize_baselines();
        }
        String string2 = string.startsWith("9") ? baseline_190 : (string.startsWith("1.8") ? baseline_180 : (string.startsWith("1.7") ? baseline_170 : (string.startsWith("1.6") ? baseline_160 : (string.startsWith("1.5") ? baseline_150 : (string.startsWith("1.4.2") ? baseline_142 : (string.startsWith("1.3.1") ? baseline_131 : BuiltInProperties.getProperty("CURRENT_VERSION")))))));
        if (DEBUG) {
            Trace.println("for requested version: " + string + "baseline version is: " + string2, TraceLevel.SECURITY);
        }
        return string2;
    }

    public static boolean satisfiesSecurityBaseline(String string) {
        if (!Config.isExpirationCheckEnabled()) {
            return true;
        }
        VersionID versionID = new VersionID(string);
        VersionID versionID2 = new VersionID(SecurityBaseline.getBaselineVersion(string));
        if (versionID.isGreaterThanOrEqual(versionID2)) {
            return true;
        }
        return versionID.equals(JREInfo.getLatestVersion(true));
    }

    public static boolean satisfiesBaselineStrictly(String string) {
        String string2 = SecurityBaseline.getBaselineVersion(string);
        if (!Config.isExpirationCheckEnabled()) {
            return true;
        }
        int n = (string = string.replace(".ea", "-ea")).indexOf("-");
        String string3 = n > 0 ? string.substring(0, n) : string;
        n = string3.indexOf("+");
        string3 = n > 0 ? string3.substring(0, n) : string3;
        VersionID versionID = new VersionID(string3);
        VersionID versionID2 = new VersionID(string2);
        boolean bl = versionID.isGreaterThanOrEqual(versionID2);
        if (DEBUG) {
            Trace.println("strictly satisfied=" + bl + "  for version: " + string + "  baseline is: " + SecurityBaseline.getBaselineVersion(string));
        }
        return bl;
    }

    public static String getDeployVersion() {
        return BuiltInProperties.getProperty("DEPLOY_VERSION");
    }

    public static String getCurrentVersion() {
        return BuiltInProperties.getProperty("CURRENT_VERSION");
    }

    private static synchronized void checkForUpdates(boolean bl) {
        UpdateThread updateThread = new UpdateThread(new Runnable(){

            @Override
            public void run() {
                UpdateCheckStatus updateCheckStatus = SecurityBaseline.checkForUpdate(Config.getStringProperty("deployment.baseline.url"), securityPackFile);
                if (updateCheckStatus == UpdateCheckStatus.NEW_UPDATE_DOWNLOADED) {
                    Config config;
                    SecurityBaseline.verifyJar(securityPackFile);
                    SecurityBaseline.extractManifests();
                    baselines_initialized = false;
                    SecurityBaseline.initialize_baselines();
                    if (SecurityBaseline.isExpired() && (config = Config.get()) instanceof ClientConfig) {
                        ((ClientConfig)config).storeConfig();
                    }
                }
                if (updateCheckStatus != UpdateCheckStatus.UPDATE_CHECK_FAILED && updateCheckStatus != UpdateCheckStatus.UPDATE_CHECK_SKIPPED) {
                    SecurityBaseline.setLastChecked(new Date().getTime());
                }
            }
        });
        updateThread.setDaemon(!bl);
        updateThread.start();
        try {
            updateThread.join();
        }
        catch (InterruptedException interruptedException) {
            Trace.ignored(interruptedException);
        }
    }

    private static void extractManifests() {
        JarFile jarFile = null;
        try {
            jarFile = JarUtil.createJarFile(securityPackFile, false);
            SecurityBaseline.extractManifest(jarFile, BASELINE_FILENAME, baselineFile);
            SecurityBaseline.extractManifest(jarFile, BLACKLIST_CERT_FILENAME, blacklistCertsFile);
            SecurityBaseline.extractManifest(jarFile, DYNAMIC_BLACKLIST_FILENAME, blacklistFile);
        }
        catch (IOException iOException) {
            String string = "Manifest extractions failed for signed security pack file " + securityPackFile;
            Trace.println(string, TraceLevel.SECURITY);
            throw new SecurityException(string, iOException);
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {
                    Trace.ignored(iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyJar(File file) {
        HashSet<CodeSigner> hashSet = new HashSet<CodeSigner>();
        JarFile jarFile = null;
        String[] stringArray = new String[]{BASELINE_FILENAME, BLACKLIST_CERT_FILENAME, DYNAMIC_BLACKLIST_FILENAME};
        String string = null;
        Exception exception = null;
        try {
            jarFile = JarUtil.createJarFile(file, true);
            for (String object2 : stringArray) {
                InputStream inputStream = null;
                try {
                    int n;
                    Object object;
                    JarEntry iOException = jarFile.getJarEntry(object2);
                    if (iOException == null) {
                        object = "Verification failed for signed security pack file " + file + ", missing entry " + object2;
                        Trace.println((String)object, TraceLevel.SECURITY);
                        throw new SecurityException((String)object, null);
                    }
                    inputStream = jarFile.getInputStream(iOException);
                    object = new byte[1024];
                    while ((n = inputStream.read((byte[])object)) != -1) {
                    }
                    if (iOException.getCodeSigners() == null) continue;
                    for (CodeSigner codeSigner : iOException.getCodeSigners()) {
                        hashSet.add(codeSigner);
                    }
                }
                finally {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {
                            Trace.ignored(iOException);
                        }
                    }
                }
            }
            Object[] objectArray = new ArrayList(hashSet).toArray(new CodeSigner[hashSet.size()]);
            URL uRL = file.toURI().toURL();
            CodeSource codeSource = new CodeSource(uRL, (CodeSigner[])objectArray);
            ValidationState validationState = TrustDecider.getJarValidationState(codeSource, null, null);
            if (validationState.trustDecision == 0L) {
                string = "deployment.securitypack.cannot.validate";
            } else if (validationState.certValidity != 0) {
                string = "deployment.securitypack.cannot.validate";
            } else if (!validationState.rootCAValid) {
                string = "deployment.securitypack.cannot.validate.selfsigned";
            } else if (!validationState.timeValid) {
                string = "deployment.securitypack.cannot.validate.expired";
                exception = validationState.certExpiredException != null ? validationState.certExpiredException : validationState.certNotYetValidException;
            }
        }
        catch (IOException iOException) {
            string = "deployment.securitypack.cannot.validate.exception";
            exception = iOException;
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {
                    Trace.ignored(iOException);
                }
            }
        }
        if (string != null) {
            Trace.println("Verification failed for signed security pack file " + file, TraceLevel.SECURITY);
            throw new SecurityException(ResourceManager.getString(string), exception);
        }
        Trace.println("Verification succeeded for signed security pack file " + file, TraceLevel.SECURITY);
    }

    private static void extractManifest(JarFile jarFile, String string, File file) {
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            int n;
            JarEntry jarEntry = jarFile.getJarEntry(string);
            if (jarEntry == null) {
                String string2 = "Missing  entry " + string;
                Trace.println(string2, TraceLevel.SECURITY);
                throw new SecurityException(string2, null);
            }
            if (file.exists() && file.isDirectory()) {
                SystemUtils.deleteRecursive(file);
            }
            inputStream = jarFile.getInputStream(jarEntry);
            fileOutputStream = new FileOutputStream(file);
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            String string3 = "Failed to extract " + string;
            Trace.println(string3, TraceLevel.SECURITY);
            throw new SecurityException(string3, iOException);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    Trace.ignored(iOException);
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    Trace.ignored(iOException);
                }
            }
        }
    }

    private static UpdateCheckStatus checkForUpdate(final String string, final File file) {
        if (Platform.get().isScreenLocked()) {
            return UpdateCheckStatus.UPDATE_CHECK_SKIPPED;
        }
        UpdateCheckStatus updateCheckStatus = AccessController.doPrivileged(new PrivilegedAction<UpdateCheckStatus>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public UpdateCheckStatus run() {
                UpdateCheckStatus updateCheckStatus = UpdateCheckStatus.UPDATE_NOT_REQUIRED;
                if (string != null && string.length() > 0) {
                    long l = 0L;
                    long l2 = 0L;
                    if (file.exists()) {
                        l = file.lastModified();
                    }
                    InputStream inputStream = null;
                    FileOutputStream fileOutputStream = null;
                    try {
                        Trace.println("Checking for update at: " + string, TraceLevel.NETWORK);
                        URL uRL = new URL(string);
                        URLConnection uRLConnection = uRL.openConnection();
                        uRLConnection.setUseCaches(false);
                        l2 = uRLConnection.getLastModified();
                        if (l2 >= l) {
                            int n;
                            Trace.println("Updating file at: " + file + " from url: " + string, TraceLevel.NETWORK);
                            inputStream = uRLConnection.getInputStream();
                            fileOutputStream = new FileOutputStream(file);
                            byte[] byArray = new byte[8192];
                            while ((n = inputStream.read(byArray)) != -1) {
                                fileOutputStream.write(byArray, 0, n);
                            }
                            updateCheckStatus = UpdateCheckStatus.NEW_UPDATE_DOWNLOADED;
                        }
                    }
                    catch (Exception exception) {
                        updateCheckStatus = UpdateCheckStatus.UPDATE_CHECK_FAILED;
                        Trace.ignored(exception);
                    }
                    finally {
                        if (fileOutputStream != null) {
                            try {
                                fileOutputStream.close();
                            }
                            catch (Exception exception) {
                                Trace.ignored(exception);
                            }
                            if (l2 > 0L) {
                                file.setLastModified(l2);
                            }
                        }
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Exception exception) {
                                Trace.ignored(exception);
                            }
                        }
                    }
                }
                return updateCheckStatus;
            }
        });
        return updateCheckStatus;
    }

    private static long getLastChecked() {
        if (updateTimestampFile.exists()) {
            return updateTimestampFile.lastModified();
        }
        return 0L;
    }

    private static void setLastChecked(long l) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(updateTimestampFile);
            ((OutputStream)fileOutputStream).write(46);
            ((OutputStream)fileOutputStream).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void backgroundUpdate() {
        if (Platform.get().isNativeSandbox()) {
            return;
        }
        UpdateThread updateThread = new UpdateThread(new Runnable(){

            @Override
            public void run() {
                long l = new Date().getTime();
                if (l > SecurityBaseline.getLastChecked() + UPDATE_INTERVAL) {
                    try {
                        Thread.sleep(THREAD_SLEEP_INTERVAL);
                        SecurityBaseline.checkForUpdates(false);
                    }
                    catch (Exception exception) {
                        Trace.ignored(exception);
                    }
                }
                if (DEBUG) {
                    Trace.println("Baseline/Blacklist thread exiting time: " + (new Date().getTime() - l), TraceLevel.BASIC);
                }
            }
        });
        updateThread.setDaemon(true);
        updateThread.start();
    }

    public static void forceBaselineUpdate() {
        SecurityBaseline.checkForUpdates(true);
        SecurityBaseline.initialize_baselines();
    }

    public static boolean isExpired() {
        if (!Config.isExpirationCheckEnabled()) {
            return false;
        }
        Boolean bl = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                if (Environment.getenv("JRE_NOTEXPIRED") != null) {
                    return Boolean.FALSE;
                }
                if (Environment.getenv("JRE_EXPIRED") != null) {
                    return Boolean.TRUE;
                }
                return null;
            }
        });
        if (bl != null) {
            return bl;
        }
        Date date = new Date(BuiltInProperties.getExpirationTime());
        if (date.before(new Date())) {
            return true;
        }
        return !SecurityBaseline.satisfiesBaselineStrictly(JREInfo.getLatest());
    }

    public static boolean isUpdateThread() {
        return Thread.currentThread() instanceof UpdateThread;
    }

    static {
        if (Config.get() instanceof DefaultConfig) {
            Trace.ignored(new RuntimeException("Default config is used for security baseline initialization."));
        }
        securityDir.mkdirs();
        SecurityBaseline.backgroundUpdate();
    }

    private static class UpdateThread
    extends Thread {
        UpdateThread(Runnable runnable) {
            super(runnable);
        }
    }

    static enum UpdateCheckStatus {
        NEW_UPDATE_DOWNLOADED,
        UPDATE_NOT_REQUIRED,
        UPDATE_CHECK_FAILED,
        UPDATE_CHECK_SKIPPED;

    }
}

