/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.SyncAccess;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;

public class SyncFileAccess {
    private static final AccessControlContext ACC_FILE_INSTANCE;
    private static final int TYPE_RANDOM_ACCESS_FILE = 1;
    private static final int TYPE_FILE_INPUT_STREAM = 2;
    private static final int TYPE_FILE_OUTPUT_STREAM = 3;
    private final SyncAccess fileAccSync;
    private final File file;

    public SyncFileAccess(File file) {
        this.file = file;
        this.fileAccSync = new SyncAccess(8);
    }

    public RandomAccessFileLock openLockRandomAccessFile(String string, int n, boolean bl) throws IOException {
        Object object = this.openLockFileObject(1, string, n, bl, false);
        return (RandomAccessFileLock)object;
    }

    public FileInputStreamLock openLockFileInputStream(int n, boolean bl) throws IOException {
        Object object = this.openLockFileObject(2, "r", n, bl, false);
        return (FileInputStreamLock)object;
    }

    public FileOutputStreamLock openLockFileOutputStream(boolean bl, int n, boolean bl2) throws IOException {
        Object object = this.openLockFileObject(3, "rw", n, bl2, bl);
        return (FileOutputStreamLock)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object openLockFileObject(final int n, final String string, int n2, boolean bl, final boolean bl2) throws IOException {
        boolean bl3 = n2 == 0;
        boolean bl4 = string.equals("r");
        SyncAccess.Lock lock = this.fileAccSync.lock(bl4 ? 2 : 4);
        Object object = null;
        try {
            while (null == object) {
                if (bl) {
                    object = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            Closeable closeable = null;
                            try {
                                switch (n) {
                                    case 1: {
                                        closeable = new RandomAccessFile(SyncFileAccess.this.file, string);
                                        break;
                                    }
                                    case 2: {
                                        closeable = new FileInputStream(SyncFileAccess.this.file);
                                        break;
                                    }
                                    case 3: {
                                        closeable = new FileOutputStream(SyncFileAccess.this.file.getPath(), bl2);
                                        break;
                                    }
                                    default: {
                                        throw new InternalError("wrong fobj type: " + n);
                                    }
                                }
                            }
                            catch (FileNotFoundException fileNotFoundException) {
                                Trace.ignoredException(fileNotFoundException);
                            }
                            return closeable;
                        }
                    }, ACC_FILE_INSTANCE);
                } else {
                    try {
                        switch (n) {
                            case 1: {
                                object = new RandomAccessFile(this.file, string);
                                break;
                            }
                            case 2: {
                                object = new FileInputStream(this.file);
                                break;
                            }
                            case 3: {
                                object = new FileOutputStream(this.file.getPath(), bl2);
                                break;
                            }
                            default: {
                                throw new InternalError("wrong fobj type: " + n);
                            }
                        }
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        Trace.ignoredException(fileNotFoundException);
                    }
                }
                if (null == object) {
                    throw new FileNotFoundException("index file not found");
                }
                FileChannel fileChannel = null;
                switch (n) {
                    case 1: {
                        fileChannel = ((RandomAccessFile)object).getChannel();
                        break;
                    }
                    case 2: {
                        fileChannel = ((FileInputStream)object).getChannel();
                        break;
                    }
                    case 3: {
                        fileChannel = ((FileOutputStream)object).getChannel();
                        break;
                    }
                    default: {
                        throw new InternalError("wrong fobj type: " + n);
                    }
                }
                if (fileChannel == null) {
                    throw new InternalError("Invalid FileChannel");
                }
                if (!fileChannel.isOpen()) {
                    fileChannel = null;
                    object = null;
                    if (!bl3 && n2 <= 0) {
                        throw new IOException("index file could not be opened, timeout reached");
                    }
                    Trace.println("SyncFileAccess.openLock: index file not opened, remaining TO : " + n2, TraceLevel.NETWORK);
                    try {
                        if (!bl3) {
                            Thread.sleep(n2 > 100 ? 100L : (long)n2);
                            n2 -= 100;
                            continue;
                        }
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                try {
                    FileLock fileLock = null;
                    while (fileLock == null) {
                        try {
                            fileLock = fileChannel.lock(0L, Long.MAX_VALUE, bl4);
                        }
                        catch (OverlappingFileLockException overlappingFileLockException) {
                            if (!bl3 && n2 <= 0) {
                                throw new IOException("handled OverlappingFileLockException, timeout reached", overlappingFileLockException);
                            }
                            Trace.println("SyncFileAccess.openLock: handled OverlappingFileLockException, remainint TO : " + n2, TraceLevel.NETWORK);
                            try {
                                if (!bl3) {
                                    Thread.sleep(n2 > 100 ? 100L : (long)n2);
                                    n2 -= 100;
                                } else {
                                    Thread.sleep(100L);
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            fileLock = null;
                        }
                        catch (IOException iOException) {
                            object = null;
                            Object var13_20 = null;
                            if (object == null) {
                                lock.release();
                            }
                            return var13_20;
                        }
                    }
                }
                catch (ClosedChannelException closedChannelException) {
                    object = null;
                    if (!bl3 && n2 <= 0) {
                        throw new IOException("handled ClosedChannelException, timeout reached", closedChannelException);
                    }
                    Trace.println("SyncFileAccess.openLock: handled ClosedChannelException, remaining TO: " + n2, TraceLevel.NETWORK);
                    try {
                        if (!bl3) {
                            Thread.sleep(n2 > 100 ? 100L : (long)n2);
                            n2 -= 100;
                            continue;
                        }
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        finally {
            if (object == null) {
                lock.release();
            }
        }
        if (object != null) {
            return FObjLock.createFObjLock(n, object, lock);
        }
        return null;
    }

    static {
        Permissions permissions = new Permissions();
        FilePermission filePermission = new FilePermission("<<ALL FILES>>", "read,write");
        ((PermissionCollection)permissions).add(filePermission);
        ACC_FILE_INSTANCE = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, permissions)});
    }

    private static class FObjLock {
        protected Object fobj;
        private SyncAccess.Lock lock;

        private FObjLock(Object object, SyncAccess.Lock lock) {
            this.fobj = object;
            this.lock = lock;
        }

        public void release() {
            if (this.lock != null) {
                this.lock.release();
                this.lock = null;
            }
        }

        protected static Object createFObjLock(int n, Object object, SyncAccess.Lock lock) {
            FObjLock fObjLock;
            switch (n) {
                case 1: {
                    fObjLock = new RandomAccessFileLock((RandomAccessFile)object, lock);
                    break;
                }
                case 2: {
                    fObjLock = new FileInputStreamLock((FileInputStream)object, lock);
                    break;
                }
                case 3: {
                    fObjLock = new FileOutputStreamLock((FileOutputStream)object, lock);
                    break;
                }
                default: {
                    throw new InternalError("wrong fobj type: " + n);
                }
            }
            return fObjLock;
        }
    }

    public static class FileOutputStreamLock
    extends FObjLock {
        private FileOutputStreamLock(FileOutputStream fileOutputStream, SyncAccess.Lock lock) {
            super(fileOutputStream, lock);
        }

        public FileOutputStream getFileOutputStream() {
            return (FileOutputStream)this.fobj;
        }
    }

    public static class FileInputStreamLock
    extends FObjLock {
        private FileInputStreamLock(FileInputStream fileInputStream, SyncAccess.Lock lock) {
            super(fileInputStream, lock);
        }

        public FileInputStream getFileInputStream() {
            return (FileInputStream)this.fobj;
        }
    }

    public static class RandomAccessFileLock
    extends FObjLock {
        private RandomAccessFileLock(RandomAccessFile randomAccessFile, SyncAccess.Lock lock) {
            super(randomAccessFile, lock);
        }

        public RandomAccessFile getRandomAccessFile() {
            return (RandomAccessFile)this.fobj;
        }
    }
}

