/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.security;

import com.sun.deploy.model.DeployCacheJarAccess;
import com.sun.deploy.model.Resource;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.net.JARSigningException;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.JarUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class SigningInfo {
    private static DeployCacheJarAccess jarAccess = ResourceProvider.get().getJarAccess();
    private Resource ce = null;
    private URL location = null;
    private String version = null;
    private boolean fileInCache;
    private boolean jarIsEmpty;
    private String jarFilePath = null;
    private boolean wasChecked = false;

    public static Certificate[] toCertificateArray(List<CertChain> list) {
        Certificate[] certificateArray;
        Iterator<CertChain> iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            certificateArray = iterator.next();
            if (certificateArray instanceof CertChain) {
                n += ((CertChain)certificateArray).getLength();
                continue;
            }
            return null;
        }
        certificateArray = new Certificate[n];
        iterator = list.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            Certificate[] certificateArray2 = iterator.next().getCertificates();
            System.arraycopy(certificateArray2, 0, certificateArray, n2, certificateArray2.length);
            n2 += certificateArray2.length;
        }
        return certificateArray;
    }

    private static boolean setContains(List<CodeSigner> list, CodeSigner codeSigner) {
        if (list == null || codeSigner == null) {
            return false;
        }
        for (CodeSigner codeSigner2 : list) {
            if (!codeSigner2.getSignerCertPath().equals(codeSigner.getSignerCertPath())) continue;
            return true;
        }
        return false;
    }

    public static List<CertChain> overlapChainLists(List<CertChain> list, List<CertChain> list2) {
        if (list == null || list2 == null) {
            return null;
        }
        ArrayList<CertChain> arrayList = new ArrayList<CertChain>();
        for (CertChain certChain : list) {
            if (!list2.contains(certChain)) continue;
            arrayList.add(certChain);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList;
    }

    public static List<CodeSigner> overlapSigners(List<CodeSigner> list, CodeSigner[] codeSignerArray) {
        ArrayList<CodeSigner> arrayList = new ArrayList<CodeSigner>();
        if (codeSignerArray == null) {
            return arrayList;
        }
        for (CodeSigner codeSigner : codeSignerArray) {
            if (list != null && !SigningInfo.setContains(list, codeSigner)) continue;
            arrayList.add(codeSigner);
        }
        return arrayList;
    }

    private static CertChain getAChain(Certificate[] certificateArray, int n) {
        if (n > certificateArray.length - 1) {
            return null;
        }
        int n2 = 0;
        for (n2 = n; n2 < certificateArray.length - 1 && ((X509Certificate)certificateArray[n2 + 1]).getSubjectDN().equals(((X509Certificate)certificateArray[n2]).getIssuerDN()); ++n2) {
        }
        return new CertChain(certificateArray, n, n2);
    }

    public SigningInfo(URL uRL, String string) {
        this.location = uRL;
        this.version = string;
        boolean bl = false;
        try {
            this.jarFilePath = ResourceProvider.get().getCachedResourceFilePath(uRL, string);
            this.fileInCache = true;
        }
        catch (IOException iOException) {
            if (string != null) {
                try {
                    this.jarFilePath = ResourceProvider.get().getCachedResourceFilePath(uRL, null);
                    bl = true;
                }
                catch (IOException iOException2) {
                    this.fileInCache = false;
                }
            }
            this.fileInCache = false;
        }
        if (this.fileInCache && ResourceProvider.get().canCache(null)) {
            this.ce = ResourceProvider.get().getCachedResource(uRL, bl ? null : string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CodeSigner> check() throws IOException, JARSigningException {
        List<CodeSigner> list = null;
        if (this.ce != null) {
            JarFile jarFile = this.ce.getJarFile();
            Trace.println((String)("Validating cached jar url=" + this.ce.getURL() + " ffile=" + this.ce.getResourceFilename() + " " + jarFile), (TraceLevel)TraceLevel.SECURITY);
            list = this.getCommonCodeSignersForJar(jarFile);
            if (list != null && list.isEmpty()) {
                list = null;
                throw new JARSigningException(this.location, this.version, 1);
            }
            this.wasChecked = true;
        } else {
            ZipFile zipFile = null;
            try {
                JarFile jarFile = ResourceProvider.get().getCachedJarFile(this.location, this.version);
                if (jarFile == null) {
                    if (this.jarFilePath != null) {
                        jarFile = JarUtil.createJarFile((File)new File(this.jarFilePath), (boolean)true);
                        zipFile = jarFile;
                    } else {
                        throw new SecurityException("Unable to get path for main jar");
                    }
                }
                if ((list = this.getCommonCodeSignersForJar(jarFile)) != null && list.isEmpty()) {
                    list = null;
                    throw new JARSigningException(this.location, this.version, 1);
                }
            }
            finally {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
        }
        return list;
    }

    public List<CertChain> signersToCertChains(List<CodeSigner> list) throws IOException, JARSigningException {
        ArrayList<CertChain> arrayList = new ArrayList<CertChain>();
        if (list != null) {
            for (CodeSigner codeSigner : list) {
                CertChain certChain;
                List<? extends Certificate> list2 = codeSigner.getSignerCertPath().getCertificates();
                Certificate[] certificateArray = list2.toArray(new Certificate[0]);
                int n = 0;
                while ((certChain = SigningInfo.getAChain(certificateArray, n)) != null) {
                    arrayList.add(certChain);
                    n += certChain.getLength();
                }
            }
        }
        return arrayList;
    }

    public List<CodeSigner> getCertificates() {
        if (this.ce != null) {
            return SigningInfo.overlapSigners(null, this.ce.getCodeSigners());
        }
        return null;
    }

    public boolean isFileKnownToBeNotCached() {
        return !this.fileInCache;
    }

    public boolean isJarKnownToBeEmpty() {
        return this.jarIsEmpty;
    }

    List<CodeSigner> getCommonCodeSignersForJar(JarFile jarFile) throws IOException {
        List<CodeSigner> list = null;
        boolean bl = false;
        try {
            if (jarAccess != null) {
                jarAccess.getCodeSource(jarFile, new URL("http:"), "/NOP");
                CodeSource[] codeSourceArray = jarAccess.getCodeSources(jarFile, null);
                jarAccess.setEagerValidation(jarFile, true);
                Enumeration enumeration = jarAccess.entryNames(jarFile, codeSourceArray);
                while (enumeration.hasMoreElements() && (list == null || !list.isEmpty())) {
                    String string = (String)enumeration.nextElement();
                    CodeSource codeSource = jarAccess.getCodeSource(jarFile, null, string);
                    bl = true;
                    CodeSigner[] codeSignerArray = codeSource.getCodeSigners();
                    if (codeSignerArray == null) continue;
                    list = SigningInfo.overlapSigners(list, codeSignerArray);
                }
            } else {
                Enumeration<JarEntry> enumeration = jarFile.entries();
                while (enumeration.hasMoreElements() && (list == null || !list.isEmpty())) {
                    byte[] byArray = new byte[8192];
                    JarEntry jarEntry = enumeration.nextElement();
                    if (JarUtil.canSkipEntry((ZipEntry)jarEntry)) continue;
                    bl = true;
                    InputStream inputStream = jarFile.getInputStream(jarEntry);
                    while (inputStream.read(byArray, 0, byArray.length) != -1) {
                    }
                    inputStream.close();
                    CodeSigner[] codeSignerArray = jarEntry.getCodeSigners();
                    if (codeSignerArray == null) continue;
                    list = SigningInfo.overlapSigners(list, codeSignerArray);
                }
            }
        }
        catch (JARSigningException jARSigningException) {
            throw jARSigningException;
        }
        catch (IOException iOException) {
            throw new JARSigningException(this.location, this.version, 2, (Exception)iOException);
        }
        catch (SecurityException securityException) {
            throw new JARSigningException(this.location, this.version, 2, (Exception)securityException);
        }
        this.jarIsEmpty = !bl;
        return list;
    }

    static class CertChain {
        Certificate[] certs;

        CertChain(Certificate[] certificateArray, int n, int n2) {
            this.certs = new Certificate[n2 - n + 1];
            for (int i = 0; i < this.certs.length; ++i) {
                this.certs[i] = certificateArray[n + i];
            }
        }

        Certificate[] getCertificates() {
            return this.certs;
        }

        int getLength() {
            return this.certs.length;
        }

        public int hashCode() {
            if (this.certs.length == 0) {
                return 0;
            }
            return this.certs[0].hashCode();
        }

        public boolean equals(Object object) {
            CertChain certChain = (CertChain)object;
            if (certChain == null || certChain.getLength() != this.getLength()) {
                return false;
            }
            for (int i = 0; i < this.certs.length; ++i) {
                if (certChain.certs[i].equals(this.certs[i])) continue;
                return false;
            }
            return true;
        }
    }
}

