/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.media.sound.JavaSoundAudioClip;
import java.applet.AudioClip;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.Permission;
import java.util.HashMap;
import java.util.Map;

final class AppletAudioClip
implements AudioClip {
    private URL url = null;
    private AudioClip audioClip = null;
    private static Map<URL, AudioClip> audioClips = new HashMap<URL, AudioClip>();

    public AppletAudioClip() {
    }

    public AppletAudioClip(URL uRL) {
        this.url = uRL;
        try {
            InputStream inputStream = uRL.openStream();
            this.createAppletAudioClip(inputStream);
        }
        catch (IOException iOException) {
            Trace.println((String)("IOException creating AppletAudioClip" + iOException), (TraceLevel)TraceLevel.BASIC);
        }
    }

    public static synchronized AudioClip get(URL uRL) {
        AppletAudioClip.checkConnect(uRL);
        AudioClip audioClip = audioClips.get(uRL);
        if (audioClip == null) {
            audioClip = new AppletAudioClip(uRL);
            audioClips.put(uRL, audioClip);
        }
        return audioClip;
    }

    void createAppletAudioClip(InputStream inputStream) throws IOException {
        this.audioClip = new JavaSoundAudioClip(inputStream);
    }

    private static void checkConnect(URL uRL) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                Permission permission = uRL.openConnection().getPermission();
                if (permission != null) {
                    securityManager.checkPermission(permission);
                } else {
                    securityManager.checkConnect(uRL.getHost(), uRL.getPort());
                }
            }
            catch (IOException iOException) {
                securityManager.checkConnect(uRL.getHost(), uRL.getPort());
            }
        }
    }

    @Override
    public synchronized void play() {
        if (this.audioClip != null) {
            this.audioClip.play();
        }
    }

    @Override
    public synchronized void loop() {
        if (this.audioClip != null) {
            this.audioClip.loop();
        }
    }

    @Override
    public synchronized void stop() {
        if (this.audioClip != null) {
            this.audioClip.stop();
        }
    }
}

